/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.builtin;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.UDFContext;

public class IsFirstReduceOfKey
extends EvalFunc<Boolean> {
    protected static final TupleFactory tf = TupleFactory.getInstance();
    protected Map<Object, Pair<Integer, Integer>> reducerMap = null;

    protected void init() {
        Configuration conf = (Configuration)PigMapReduce.sJobConfInternal.get();
        String keyDistFile = conf.get("pig.keyDistFile", "");
        if (keyDistFile.length() == 0) {
            throw new RuntimeException(this.getClass().getSimpleName() + " used but no key distribution found");
        }
        try {
            Integer[] redCnt = new Integer[1];
            this.reducerMap = MapRedUtil.loadPartitionFileFromLocalCache(keyDistFile, redCnt, (byte)110, conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Boolean exec(Tuple input) throws IOException {
        int reduceIndex;
        if (this.reducerMap == null) {
            this.init();
        }
        Object key = input.get(0);
        Tuple keyTuple = tf.newTuple(1);
        keyTuple.set(0, key);
        if (!this.reducerMap.containsKey(keyTuple)) {
            return true;
        }
        int firstReducerOfKey = (Integer)this.reducerMap.get((Object)keyTuple).first;
        if (firstReducerOfKey == (reduceIndex = UDFContext.getUDFContext().getJobConf().getInt("mapreduce.task.index", 0))) {
            return true;
        }
        return false;
    }
}

