/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.OutputStatisticsReporter;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezCountersDelegate;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezTaskContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.resources.MemoryDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezOutputContextImpl
extends TezTaskContextImpl
implements OutputContext {
    private static final Logger LOG = LoggerFactory.getLogger(TezOutputContextImpl.class);
    private volatile UserPayload userPayload;
    private final String destinationVertexName;
    private final EventMetaData sourceInfo;
    private final int outputIndex;
    private final OutputStatisticsReporterImpl statsReporter;

    @InterfaceAudience.Private
    public TezOutputContextImpl(Configuration conf, String[] workDirs, int appAttemptNumber, TezUmbilical tezUmbilical, String dagName, String taskVertexName, String destinationVertexName, int vertexParallelism, TezTaskAttemptID taskAttemptID, int outputIndex, @Nullable UserPayload userPayload, LogicalIOProcessorRuntimeTask runtimeTask, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv, MemoryDistributor memDist, OutputDescriptor outputDescriptor, ObjectRegistry objectRegistry, ExecutionContext ExecutionContext2, long memAvailable) {
        super(conf, workDirs, appAttemptNumber, dagName, taskVertexName, vertexParallelism, taskAttemptID, TezOutputContextImpl.wrapCounters(runtimeTask, taskVertexName, destinationVertexName, conf), runtimeTask, tezUmbilical, serviceConsumerMetadata, auxServiceEnv, memDist, (EntityDescriptor<?>)outputDescriptor, objectRegistry, ExecutionContext2, memAvailable);
        Preconditions.checkNotNull((Object)outputIndex, (Object)"outputIndex is null");
        Preconditions.checkNotNull((Object)destinationVertexName, (Object)"destinationVertexName is null");
        this.userPayload = userPayload;
        this.outputIndex = outputIndex;
        this.destinationVertexName = destinationVertexName;
        this.sourceInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.OUTPUT, taskVertexName, destinationVertexName, taskAttemptID);
        runtimeTask.getTaskStatistics().addIO(destinationVertexName);
        this.statsReporter = new OutputStatisticsReporterImpl();
    }

    private static TezCounters wrapCounters(LogicalIOProcessorRuntimeTask runtimeTask, String taskVertexName, String edgeVertexName, Configuration conf) {
        TezCounters tezCounters = runtimeTask.addAndGetTezCounter(edgeVertexName);
        if (conf.getBoolean("tez.task.generate.counters.per.io", false)) {
            return new TezCountersDelegate(tezCounters, taskVertexName, edgeVertexName, "OUTPUT");
        }
        return tezCounters;
    }

    public void sendEvents(List<Event> events) {
        Preconditions.checkNotNull(events, (Object)"events are null");
        ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>(events.size());
        for (Event e : events) {
            TezEvent tEvt = new TezEvent(e, this.sourceInfo);
            tezEvents.add(tEvt);
        }
        this.tezUmbilical.addEvents(tezEvents);
    }

    public UserPayload getUserPayload() {
        return this.userPayload;
    }

    public String getDestinationVertexName() {
        return this.destinationVertexName;
    }

    public void fatalError(Throwable exception, String message) {
        super.signalFatalError(exception, message, this.sourceInfo);
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public OutputStatisticsReporter getStatisticsReporter() {
        return this.statsReporter;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.userPayload = null;
        LOG.info("Cleared TezOutputContextImpl related information");
    }

    class OutputStatisticsReporterImpl
    implements OutputStatisticsReporter {
        OutputStatisticsReporterImpl() {
        }

        public synchronized void reportDataSize(long size) {
            TezOutputContextImpl.this.runtimeTask.getTaskStatistics().getIOStatistics().get(TezOutputContextImpl.this.destinationVertexName).setDataSize(size);
        }

        public void reportItemsProcessed(long items) {
            TezOutputContextImpl.this.runtimeTask.getTaskStatistics().getIOStatistics().get(TezOutputContextImpl.this.destinationVertexName).setItemsProcessed(items);
        }
    }
}

