/*
 * Decompiled with CFR 0.152.
 */
package sdsu.html;

import sdsu.html.Formatter;
import sdsu.html.HTML;

public class TextInput
implements HTML {
    private static final int NOT_SET = -1;
    private static final int TEXT_AREA = -1;
    private static final int INPUT_FIELD = 0;
    private static final int PASSWORD = 1;
    private String name;
    private String intialText = null;
    private int numberOfColumns;
    private int numberOfRows;
    private int maxTextLength = -1;
    private int inputType;

    private TextInput() {
    }

    private String inputFieldTags() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("\n<INPUT TYPE=\"text\" ");
        stringBuffer.append(" NAME=\"");
        stringBuffer.append(this.name);
        stringBuffer.append("\" SIZE=\"");
        stringBuffer.append(this.numberOfColumns);
        stringBuffer.append("\"");
        if (this.intialText != null) {
            stringBuffer.append(" VALUE=\"");
            stringBuffer.append(this.intialText);
            stringBuffer.append("\"");
        }
        if (this.maxTextLength != -1) {
            stringBuffer.append(" MAXLENGTH=\"");
            stringBuffer.append(this.maxTextLength);
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static TextInput password(String string, int n) {
        TextInput textInput = new TextInput();
        textInput.name = string;
        textInput.numberOfColumns = n;
        textInput.inputType = 1;
        return textInput;
    }

    private String passwordTags() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("\n<INPUT TYPE=\"password\" ");
        stringBuffer.append(" NAME=\"");
        stringBuffer.append(this.name);
        stringBuffer.append("\" SIZE=\"");
        stringBuffer.append(this.numberOfColumns);
        stringBuffer.append("\"");
        if (this.intialText != null) {
            stringBuffer.append(" VALUE=\"");
            stringBuffer.append(this.intialText);
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static TextInput scrolling(String string, int n, int n2) {
        TextInput textInput = new TextInput();
        textInput.name = string;
        textInput.numberOfRows = n;
        textInput.numberOfColumns = n2;
        textInput.inputType = -1;
        return textInput;
    }

    public void setInitalText(String string) {
        this.intialText = new Formatter(string).toString();
    }

    public static TextInput singleLine(String string, int n) {
        TextInput textInput = new TextInput();
        textInput.name = string;
        textInput.numberOfColumns = n;
        textInput.inputType = 0;
        return textInput;
    }

    public static TextInput singleLine(String string, int n, int n2) {
        TextInput textInput = new TextInput();
        textInput.name = string;
        textInput.numberOfColumns = n;
        textInput.inputType = 0;
        textInput.maxTextLength = n2;
        return textInput;
    }

    private String textAreaTags() {
        StringBuffer stringBuffer = new StringBuffer(9);
        stringBuffer.append("\n<TEXTAREA NAME=\"");
        stringBuffer.append(this.name);
        stringBuffer.append("\" COLS=\"");
        stringBuffer.append(this.numberOfColumns);
        stringBuffer.append("\" ROWS=\"");
        stringBuffer.append(this.numberOfRows);
        stringBuffer.append("\">");
        if (this.intialText != null) {
            stringBuffer.append(this.intialText);
        }
        stringBuffer.append("\n</TEXTAREA>");
        return stringBuffer.toString();
    }

    public String toString() {
        switch (this.inputType) {
            case -1: {
                return this.textAreaTags();
            }
            case 0: {
                return this.inputFieldTags();
            }
            case 1: {
                return this.passwordTags();
            }
        }
        return "";
    }
}

