/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.TableConfWatcher;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;

public class TableConfiguration
extends AccumuloConfiguration {
    private static final Logger log = Logger.getLogger(TableConfiguration.class);
    private static ZooCache tablePropCache = null;
    private final String instanceId;
    private final AccumuloConfiguration parent;
    private String table = null;
    private Set<ConfigurationObserver> observers;

    public TableConfiguration(String instanceId, String table, AccumuloConfiguration parent) {
        this.instanceId = instanceId;
        this.table = table;
        this.parent = parent;
        this.observers = Collections.synchronizedSet(new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    private static ZooCache getTablePropCache() {
        Instance inst = HdfsZooInstance.getInstance();
        if (tablePropCache != null) return tablePropCache;
        Class<TableConfiguration> clazz = TableConfiguration.class;
        synchronized (TableConfiguration.class) {
            if (tablePropCache != null) return tablePropCache;
            tablePropCache = new ZooCache(inst.getZooKeepers(), inst.getZooKeepersSessionTimeOut(), (Watcher)new TableConfWatcher(inst));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tablePropCache;
        }
    }

    public void addObserver(ConfigurationObserver co) {
        if (this.table == null) {
            String err = "Attempt to add observer for non-table configuration";
            log.error((Object)err);
            throw new RuntimeException(err);
        }
        this.iterator();
        this.observers.add(co);
    }

    public void removeObserver(ConfigurationObserver configObserver) {
        if (this.table == null) {
            String err = "Attempt to remove observer for non-table configuration";
            log.error((Object)err);
            throw new RuntimeException(err);
        }
        this.observers.remove(configObserver);
    }

    public void expireAllObservers() {
        Collection<ConfigurationObserver> copy = Collections.unmodifiableCollection(this.observers);
        for (ConfigurationObserver co : copy) {
            co.sessionExpired();
        }
    }

    public void propertyChanged(String key) {
        Collection<ConfigurationObserver> copy = Collections.unmodifiableCollection(this.observers);
        for (ConfigurationObserver co : copy) {
            co.propertyChanged(key);
        }
    }

    public void propertiesChanged(String key) {
        Collection<ConfigurationObserver> copy = Collections.unmodifiableCollection(this.observers);
        for (ConfigurationObserver co : copy) {
            co.propertiesChanged();
        }
    }

    public String get(Property property) {
        String key = property.getKey();
        String value = this.get(key);
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error((Object)("Using default value for " + key + " due to improperly formatted " + property.getType() + ": " + value));
            }
            value = this.parent.get(property);
        }
        return value;
    }

    private String get(String key) {
        String zPath = ZooUtil.getRoot((String)this.instanceId) + "/tables" + "/" + this.table + "/conf" + "/" + key;
        byte[] v = TableConfiguration.getTablePropCache().get(zPath);
        String value = null;
        if (v != null) {
            value = new String(v);
        }
        return value;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        TreeMap entries = new TreeMap();
        for (Map.Entry parentEntry : this.parent) {
            entries.put(parentEntry.getKey(), parentEntry.getValue());
        }
        List children = TableConfiguration.getTablePropCache().getChildren(ZooUtil.getRoot((String)this.instanceId) + "/tables" + "/" + this.table + "/conf");
        if (children != null) {
            for (String child : children) {
                String value = this.get(child);
                if (child == null || value == null) continue;
                entries.put(child, value);
            }
        }
        return entries.entrySet().iterator();
    }

    public String getTableId() {
        return this.table;
    }
}

