/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.CloneInfo;
import org.apache.accumulo.server.master.tableOps.ClonePermissions;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;

public class CloneTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo = new CloneInfo();

    public CloneTable(String user, String srcTableId, String tableName, Map<String, String> propertiesToSet, Set<String> propertiesToExclude) {
        this.cloneInfo.user = user;
        this.cloneInfo.srcTableId = srcTableId;
        this.cloneInfo.tableName = tableName;
        this.cloneInfo.propertiesToExclude = propertiesToExclude;
        this.cloneInfo.propertiesToSet = propertiesToSet;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveTable(this.cloneInfo.srcTableId, tid, false, true, TableOperation.CLONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        Utils.idLock.lock();
        try {
            Instance instance = HdfsZooInstance.getInstance();
            this.cloneInfo.tableId = Utils.getNextTableId(this.cloneInfo.tableName, instance);
            ClonePermissions clonePermissions = new ClonePermissions(this.cloneInfo);
            return clonePermissions;
        }
        finally {
            Utils.idLock.unlock();
        }
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        Utils.unreserveTable(this.cloneInfo.srcTableId, tid, false);
    }
}

