/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.server.master.tableOps.MapImportFileNames;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.tabletserver.UniqueNameAllocator;
import org.apache.hadoop.fs.Path;

class CreateImportDir
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    CreateImportDir(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        UniqueNameAllocator namer = UniqueNameAllocator.getInstance();
        Path directory = new Path(ServerConstants.getTablesDir() + "/" + this.tableInfo.tableId);
        Path newBulkDir = new Path(directory, "b-" + namer.getNextName());
        this.tableInfo.importDir = newBulkDir.toString();
        return new MapImportFileNames(this.tableInfo);
    }
}

