/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.ImportPopulateZookeeper;
import org.apache.accumulo.server.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.log4j.Logger;

class ImportSetupPermissions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    public ImportSetupPermissions(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        SecurityOperation security = AuditedSecurityOperation.getInstance();
        for (TablePermission permission : TablePermission.values()) {
            try {
                security.grantTablePermission(SecurityConstants.getSystemCredentials(), this.tableInfo.user, this.tableInfo.tableId, permission);
            }
            catch (ThriftSecurityException e) {
                Logger.getLogger(ImportSetupPermissions.class).error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return new ImportPopulateZookeeper(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        AuditedSecurityOperation.getInstance().deleteTable(SecurityConstants.getSystemCredentials(), this.tableInfo.tableId);
    }
}

