/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.ImportSetupPermissions;
import org.apache.accumulo.server.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.hadoop.fs.Path;

public class ImportTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo = new ImportedTableInfo();

    public ImportTable(String user, String tableName, String exportDir) {
        this.tableInfo.tableName = tableName;
        this.tableInfo.user = user;
        this.tableInfo.exportDir = exportDir;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveHdfsDirectory(new Path(this.tableInfo.exportDir).toString(), tid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        this.checkVersions(env);
        Utils.idLock.lock();
        try {
            Instance instance = HdfsZooInstance.getInstance();
            this.tableInfo.tableId = Utils.getNextTableId(this.tableInfo.tableName, instance);
            ImportSetupPermissions importSetupPermissions = new ImportSetupPermissions(this.tableInfo);
            return importSetupPermissions;
        }
        finally {
            Utils.idLock.unlock();
        }
    }

    public void checkVersions(Master env) throws ThriftTableOperationException {
        Path path = new Path(this.tableInfo.exportDir, "exportMetadata.zip");
        ZipInputStream zis = null;
        try {
            ZipEntry zipEntry;
            zis = new ZipInputStream((InputStream)env.getFileSystem().open(path));
            Integer exportVersion = null;
            Integer dataVersion = null;
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (!zipEntry.getName().equals("accumulo_export_info.txt")) continue;
                BufferedReader in = new BufferedReader(new InputStreamReader(zis));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String[] sa = line.split(":", 2);
                    if (sa[0].equals("exportVersion")) {
                        exportVersion = Integer.parseInt(sa[1]);
                        continue;
                    }
                    if (!sa[0].equals("srcDataVersion")) continue;
                    dataVersion = Integer.parseInt(sa[1]);
                }
                break block9;
            }
            zis.close();
            zis = null;
            if (exportVersion == null || exportVersion > 1) {
                throw new ThriftTableOperationException(null, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Incompatible export version " + exportVersion);
            }
            if (dataVersion == null || dataVersion > 5) {
                throw new ThriftTableOperationException(null, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Incompatible data version " + exportVersion);
            }
        }
        catch (IOException ioe) {
            log.warn((Object)ioe.getMessage(), (Throwable)ioe);
            throw new ThriftTableOperationException(null, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Failed to read export metadata " + ioe.getMessage());
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveHdfsDirectory(new Path(this.tableInfo.exportDir).toString(), tid);
    }
}

