/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;

public class RenameTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;
    private String oldTableName;
    private String newTableName;

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveTable(this.tableId, tid, true, true, TableOperation.RENAME);
    }

    public RenameTable(String tableId, String oldTableName, String newTableName) {
        this.tableId = tableId;
        this.oldTableName = oldTableName;
        this.newTableName = newTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Instance instance = master.getInstance();
        IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
        Utils.tableNameLock.lock();
        try {
            Utils.checkTableDoesNotExist(instance, this.newTableName, this.tableId, TableOperation.RENAME);
            String tap = ZooUtil.getRoot((Instance)instance) + "/tables" + "/" + this.tableId + "/name";
            zoo.mutate(tap, null, null, new ZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] current) throws Exception {
                    String currentName = new String(current);
                    if (currentName.equals(RenameTable.this.newTableName)) {
                        return null;
                    }
                    if (!currentName.equals(RenameTable.this.oldTableName)) {
                        throw new ThriftTableOperationException(null, RenameTable.this.oldTableName, TableOperation.RENAME, TableOperationExceptionType.NOTFOUND, "Name changed while processing");
                    }
                    return RenameTable.this.newTableName.getBytes();
                }
            });
            Tables.clearCache((Instance)instance);
        }
        finally {
            Utils.tableNameLock.unlock();
            Utils.unreserveTable(this.tableId, tid, true);
        }
        Logger.getLogger(RenameTable.class).debug((Object)("Renamed table " + this.tableId + " " + this.oldTableName + " " + this.newTableName));
        return null;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveTable(this.tableId, tid, true);
    }
}

