/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor.util.celltypes;

import org.apache.accumulo.server.monitor.util.celltypes.CellType;

public class NumberType<T extends Number>
extends CellType<T> {
    private T warnMin;
    private T warnMax;
    private T errMin;
    private T errMax;
    private static final String[] COUNTS = new String[]{"", "K", "M", "B", "T", "e15", "e18", "e21"};

    public NumberType(T warnMin, T warnMax, T errMin, T errMax) {
        this.warnMin = warnMin;
        this.warnMax = warnMax;
        this.errMin = errMin;
        this.errMax = errMax;
    }

    public NumberType(T errMin, T errMax) {
        this(null, null, errMin, errMax);
    }

    public NumberType() {
        this(null, null);
    }

    @Override
    public String format(Object obj) {
        Number number = (Number)obj;
        String s = "-";
        if (number instanceof Double || number instanceof Float) {
            s = this.warnMin != null && this.warnMax != null && this.errMin != null && this.errMax != null ? NumberType.commas(number.doubleValue(), ((Number)this.warnMin).doubleValue(), ((Number)this.warnMax).doubleValue(), ((Number)this.errMin).doubleValue(), ((Number)this.errMax).doubleValue()) : (this.errMin != null && this.errMax != null ? NumberType.commas(number.doubleValue(), ((Number)this.errMin).doubleValue(), ((Number)this.errMax).doubleValue()) : NumberType.commas(number.doubleValue()));
        } else if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            s = this.warnMin != null && this.warnMax != null && this.errMin != null && this.errMax != null ? NumberType.commas(number.longValue(), ((Number)this.warnMin).longValue(), ((Number)this.warnMax).longValue(), ((Number)this.errMin).longValue(), ((Number)this.errMax).longValue()) : (this.errMin != null && this.errMax != null ? NumberType.commas(number.longValue(), ((Number)this.errMin).longValue(), ((Number)this.errMax).longValue()) : NumberType.commas(number.longValue()));
        } else if (number != null) {
            s = String.valueOf(number);
        }
        return s;
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Double.valueOf(((Number)o1).doubleValue()).compareTo(((Number)o2).doubleValue());
    }

    public static String commas(long i) {
        return NumberType.bigNumber(i);
    }

    public static String commas(long i, long errMin, long errMax) {
        if (i < errMin || i > errMax) {
            return String.format("<span class='error'>%s</span>", NumberType.bigNumber(i));
        }
        return NumberType.bigNumber(i);
    }

    public static String commas(double i) {
        return NumberType.bigNumber((long)i);
    }

    public static String commas(double d, double errMin, double errMax) {
        if (d < errMin || d > errMax) {
            return String.format("<span class='error'>%s</span>", NumberType.bigNumber(d));
        }
        return NumberType.bigNumber(d);
    }

    public static String commas(long i, long warnMin, long warnMax, long errMin, long errMax) {
        if (i < errMin || i > errMax) {
            return String.format("<span class='error'>%s</span>", NumberType.bigNumber(i));
        }
        if (i < warnMin || i > warnMax) {
            return String.format("<span class='warning'>%s</span>", NumberType.bigNumber(i));
        }
        return NumberType.bigNumber(i);
    }

    public static String commas(double d, double warnMin, double warnMax, double errMin, double errMax) {
        if (d < errMin || d > errMax) {
            return String.format("<span class='error'>%s</span>", NumberType.bigNumber(d));
        }
        if (d < warnMin || d > warnMax) {
            return String.format("<span class='warning'>%s</span>", NumberType.bigNumber(d));
        }
        return NumberType.bigNumber(d);
    }

    public static String bigNumber(long big) {
        return NumberType.bigNumber(big, COUNTS, 1000L);
    }

    public static String bigNumber(double big) {
        return NumberType.bigNumber(big, COUNTS, 1000L);
    }

    public static String bigNumber(long big, String[] SUFFIXES, long base) {
        float divisor = 1.0f;
        for (int i = 0; i < SUFFIXES.length; ++i) {
            if ((float)big / divisor < 1024.0f) {
                if (i == 0) {
                    return String.format("%,d", big);
                }
                return String.format("%,.2f%s", Float.valueOf((float)big / divisor), SUFFIXES[i]);
            }
            divisor *= (float)base;
        }
        return String.format("%,.2f%s", Float.valueOf((float)big / divisor), SUFFIXES[SUFFIXES.length - 1]);
    }

    public static String bigNumber(double big, String[] SUFFIXES, long base) {
        float divisor = 1.0f;
        for (int i = 0; i < SUFFIXES.length; ++i) {
            if (big / (double)divisor < 1024.0) {
                return String.format("%,.2f%s", big / (double)divisor, SUFFIXES[i]);
            }
            divisor *= (float)base;
        }
        return String.format("%,.2f%s", big / (double)divisor, SUFFIXES[SUFFIXES.length - 1]);
    }

    @Override
    public String alignment() {
        return "right";
    }
}

