/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;

public interface PermissionHandler {
    public void initialize(String var1, boolean var2);

    public boolean validSecurityHandlers(Authenticator var1, Authorizor var2);

    public void initializeSecurity(TCredentials var1, String var2) throws AccumuloSecurityException, ThriftSecurityException;

    public boolean hasSystemPermission(String var1, SystemPermission var2) throws AccumuloSecurityException;

    public boolean hasCachedSystemPermission(String var1, SystemPermission var2) throws AccumuloSecurityException;

    public boolean hasTablePermission(String var1, String var2, TablePermission var3) throws AccumuloSecurityException, TableNotFoundException;

    public boolean hasCachedTablePermission(String var1, String var2, TablePermission var3) throws AccumuloSecurityException, TableNotFoundException;

    public void grantSystemPermission(String var1, SystemPermission var2) throws AccumuloSecurityException;

    public void revokeSystemPermission(String var1, SystemPermission var2) throws AccumuloSecurityException;

    public void grantTablePermission(String var1, String var2, TablePermission var3) throws AccumuloSecurityException, TableNotFoundException;

    public void revokeTablePermission(String var1, String var2, TablePermission var3) throws AccumuloSecurityException, TableNotFoundException;

    public void cleanTablePermissions(String var1) throws AccumuloSecurityException, TableNotFoundException;

    public void initUser(String var1) throws AccumuloSecurityException;

    public void initTable(String var1) throws AccumuloSecurityException;

    public void cleanUser(String var1) throws AccumuloSecurityException;
}

