/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.util.Halt;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class FileSystemMonitor {
    private static final String PROC_MOUNTS = "/proc/mounts";
    private static final Logger log = Logger.getLogger(FileSystemMonitor.class);
    private Map<String, Boolean> readWriteFilesystems = new HashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Mount> parse(String procFile) throws IOException {
        ArrayList<Mount> mounts = new ArrayList<Mount>();
        FileReader fr = new FileReader(procFile);
        BufferedReader br = new BufferedReader(fr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                mounts.add(new Mount(line));
            }
        }
        finally {
            br.close();
        }
        return mounts;
    }

    public FileSystemMonitor(final String procFile, long period) throws IOException {
        List<Mount> mounts = FileSystemMonitor.parse(procFile);
        for (Mount mount : mounts) {
            if (mount.options.contains("rw")) {
                this.readWriteFilesystems.put(mount.mountPoint, true);
                continue;
            }
            if (mount.options.contains("ro")) {
                this.readWriteFilesystems.put(mount.mountPoint, false);
                continue;
            }
            throw new IOException("Filesystem " + mount + " does not have ro or rw option");
        }
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                try {
                    FileSystemMonitor.this.checkMounts(procFile);
                }
                catch (Exception e) {
                    Halt.halt(-42, new Runnable(){

                        @Override
                        public void run() {
                            log.fatal((Object)"Exception while checking mount points, halting process", (Throwable)e);
                        }
                    });
                }
            }
        };
        Timer timer = new Timer("filesystem monitor timer", true);
        timer.schedule(tt, period, period);
    }

    protected void logAsync(final Level level, final String msg, final Exception e) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                log.log((Priority)level, (Object)msg, (Throwable)e);
            }
        };
        new Thread(r).start();
    }

    protected void checkMounts(String procFile) throws Exception {
        List<Mount> mounts = FileSystemMonitor.parse(procFile);
        for (Mount mount : mounts) {
            if (!this.readWriteFilesystems.containsKey(mount.mountPoint)) {
                if (mount.options.contains("rw")) {
                    this.readWriteFilesystems.put(mount.mountPoint, true);
                    continue;
                }
                if (mount.options.contains("ro")) {
                    this.readWriteFilesystems.put(mount.mountPoint, false);
                    continue;
                }
                throw new Exception("Filesystem " + mount + " does not have ro or rw option");
            }
            if (!mount.options.contains("ro") || !this.readWriteFilesystems.get(mount.mountPoint).booleanValue()) continue;
            throw new Exception("Filesystem " + mount.mountPoint + " switched to read only");
        }
    }

    public static void start(AccumuloConfiguration conf, Property prop) {
        if (conf.getBoolean(prop)) {
            if (new File(PROC_MOUNTS).exists()) {
                try {
                    new FileSystemMonitor(PROC_MOUNTS, 60000L);
                    log.info((Object)"Filesystem monitor started");
                }
                catch (IOException e) {
                    log.error((Object)"Failed to initialize file system monitor", (Throwable)e);
                }
            } else {
                log.info((Object)"Not monitoring filesystems, /proc/mounts does not exists");
            }
        }
    }

    private static class Mount {
        String mountPoint;
        Set<String> options;

        Mount(String line) {
            String[] tokens = line.split("\\s+");
            this.mountPoint = tokens[1];
            this.options = new HashSet<String>(Arrays.asList(tokens[3].split(",")));
        }
    }
}

