/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog;

import nl.basjes.parse.core.Parser;
import nl.basjes.parse.httpdlog.HttpdLogFormatDissector;
import nl.basjes.parse.httpdlog.dissectors.HttpFirstLineDissector;
import nl.basjes.parse.httpdlog.dissectors.HttpUriDissector;
import nl.basjes.parse.httpdlog.dissectors.ModUniqueIdDissector;
import nl.basjes.parse.httpdlog.dissectors.QueryStringFieldDissector;
import nl.basjes.parse.httpdlog.dissectors.RequestCookieListDissector;
import nl.basjes.parse.httpdlog.dissectors.ResponseSetCookieDissector;
import nl.basjes.parse.httpdlog.dissectors.ResponseSetCookieListDissector;
import nl.basjes.parse.httpdlog.dissectors.TimeStampDissector;

public class HttpdLoglineParser<RECORD>
extends Parser<RECORD> {
    public HttpdLoglineParser(Class<RECORD> clazz, String logformat) {
        super(clazz);
        this.setupDissectors(logformat, null);
    }

    public HttpdLoglineParser(Class<RECORD> clazz, String logformat, String timestampFormat) {
        super(clazz);
        this.setupDissectors(logformat, timestampFormat);
    }

    private void setupDissectors(String logformat, String timestampFormat) {
        this.addDissector(new HttpdLogFormatDissector(logformat));
        this.addDissector(new TimeStampDissector(timestampFormat));
        this.addDissector(new HttpFirstLineDissector());
        this.addDissector(new HttpUriDissector());
        this.addDissector(new QueryStringFieldDissector());
        this.addDissector(new RequestCookieListDissector());
        this.addDissector(new ResponseSetCookieListDissector());
        this.addDissector(new ResponseSetCookieDissector());
        this.addDissector(new ModUniqueIdDissector());
        this.setRootType("HTTPLOGLINE");
    }
}

