/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.pig.StoreFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.StorageUtil;

public class MultiStorage
extends StoreFunc {
    private Path outputPath;
    private int splitFieldIndex = -1;
    private String fieldDel;
    private Compression comp;
    private RecordWriter<String, Tuple> writer;

    public MultiStorage(String parentPathStr, String splitFieldIndex) {
        this(parentPathStr, splitFieldIndex, "none");
    }

    public MultiStorage(String parentPathStr, String splitFieldIndex, String compression) {
        this(parentPathStr, splitFieldIndex, compression, "\\t");
    }

    public MultiStorage(String parentPathStr, String splitFieldIndex, String compression, String fieldDel) {
        this.outputPath = new Path(parentPathStr);
        this.splitFieldIndex = Integer.parseInt(splitFieldIndex);
        this.fieldDel = fieldDel;
        try {
            this.comp = compression == null ? Compression.none : Compression.valueOf(compression.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            System.err.println("Exception when converting compression string: " + compression + " to enum. No compression will be used");
            this.comp = Compression.none;
        }
    }

    public void putNext(Tuple tuple) throws IOException {
        if (tuple.size() <= this.splitFieldIndex) {
            throw new IOException("split field index:" + this.splitFieldIndex + " >= tuple size:" + tuple.size());
        }
        Object field = null;
        try {
            field = tuple.get(this.splitFieldIndex);
        }
        catch (ExecException exec) {
            throw new IOException(exec);
        }
        try {
            this.writer.write((Object)String.valueOf(field), (Object)tuple);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public OutputFormat getOutputFormat() throws IOException {
        MultiStorageOutputFormat format = new MultiStorageOutputFormat();
        format.setKeyValueSeparator(this.fieldDel);
        return format;
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        job.getConfiguration().set("mapred.textoutputformat.separator", "");
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
        if (this.comp == Compression.bz2 || this.comp == Compression.bz) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, BZip2Codec.class);
        } else if (this.comp == Compression.gz) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, GzipCodec.class);
        }
    }

    public Boolean supportsParallelWriteToStoreLocation() {
        return false;
    }

    public static class MultiStorageOutputFormat
    extends TextOutputFormat<String, Tuple> {
        private String keyValueSeparator = "\\t";
        private byte fieldDel = (byte)9;

        public RecordWriter<String, Tuple> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            final TaskAttemptContext ctx = context;
            return new RecordWriter<String, Tuple>(){
                private Map<String, MyLineRecordWriter> storeMap = new HashMap<String, MyLineRecordWriter>();
                private static final int BUFFER_SIZE = 1024;
                private ByteArrayOutputStream mOut = new ByteArrayOutputStream(1024);

                public void write(String key, Tuple val) throws IOException {
                    int sz = val.size();
                    for (int i = 0; i < sz; ++i) {
                        Object field = val.get(i);
                        StorageUtil.putField((OutputStream)this.mOut, (Object)field);
                        if (i == sz - 1) continue;
                        this.mOut.write(MultiStorageOutputFormat.this.fieldDel);
                    }
                    this.getStore(key).write(null, new Text(this.mOut.toByteArray()));
                    this.mOut.reset();
                }

                public void close(TaskAttemptContext context) throws IOException {
                    for (MyLineRecordWriter out : this.storeMap.values()) {
                        out.close(context);
                    }
                }

                private MyLineRecordWriter getStore(String fieldValue) throws IOException {
                    MyLineRecordWriter store = this.storeMap.get(fieldValue);
                    if (store == null) {
                        DataOutputStream os = this.createOutputStream(fieldValue);
                        store = new MyLineRecordWriter(os, MultiStorageOutputFormat.this.keyValueSeparator);
                        this.storeMap.put(fieldValue, store);
                    }
                    return store;
                }

                private DataOutputStream createOutputStream(String fieldValue) throws IOException {
                    Configuration conf = ctx.getConfiguration();
                    TaskID taskId = ctx.getTaskAttemptID().getTaskID();
                    boolean isCompressed = FileOutputFormat.getCompressOutput((JobContext)ctx);
                    CompressionCodec codec = null;
                    String extension = "";
                    if (isCompressed) {
                        Class codecClass = FileOutputFormat.getOutputCompressorClass((JobContext)ctx, GzipCodec.class);
                        codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)ctx.getConfiguration());
                        extension = codec.getDefaultExtension();
                    }
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMinimumIntegerDigits(4);
                    Path path = new Path(fieldValue + extension, fieldValue + '-' + nf.format(taskId.getId()) + extension);
                    Path workOutputPath = ((FileOutputCommitter)MultiStorageOutputFormat.this.getOutputCommitter(ctx)).getWorkPath();
                    Path file = new Path(workOutputPath, path);
                    FileSystem fs = file.getFileSystem(conf);
                    FSDataOutputStream fileOut = fs.create(file, false);
                    if (isCompressed) {
                        return new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut));
                    }
                    return fileOut;
                }
            };
        }

        public void setKeyValueSeparator(String sep) {
            this.keyValueSeparator = sep;
            this.fieldDel = StorageUtil.parseFieldDel((String)this.keyValueSeparator);
        }

        protected static class MyLineRecordWriter
        extends TextOutputFormat.LineRecordWriter<WritableComparable, Text> {
            public MyLineRecordWriter(DataOutputStream out, String keyValueSeparator) {
                super(out, keyValueSeparator);
            }
        }
    }

    static enum Compression {
        none,
        bz2,
        bz,
        gz;

    }
}

