/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.validator;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.pig.PigServer;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.validator.PigCommandFilter;

public final class BlackAndWhitelistFilter
implements PigCommandFilter {
    private static final int BLACKANDWHITELIST_ERROR_CODE = 1856;
    private static final Splitter SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    private final PigContext context;
    private final Set<String> whitelist;
    private final Set<String> blacklist;

    public BlackAndWhitelistFilter(PigServer pigServer) {
        this(pigServer.getPigContext());
    }

    public BlackAndWhitelistFilter(PigContext context) {
        this.context = context;
        this.whitelist = Sets.newHashSet();
        this.blacklist = Sets.newHashSet();
        this.init();
    }

    private void init() {
        String blacklistConfig;
        String whitelistConfig = this.context.getProperties().getProperty("pig.whitelist");
        if (whitelistConfig != null) {
            Iterable<String> iter = SPLITTER.split(whitelistConfig);
            for (String elem : iter) {
                this.whitelist.add(elem.toUpperCase());
            }
        }
        if ((blacklistConfig = this.context.getProperties().getProperty("pig.blacklist")) != null) {
            Iterable<String> iter = SPLITTER.split(blacklistConfig);
            for (String elem : iter) {
                String uElem = elem.toUpperCase();
                if (this.whitelist.contains(uElem)) {
                    throw new IllegalStateException("Conflict between whitelist and blacklist. '" + elem + "' appears in both.");
                }
                this.blacklist.add(uElem);
            }
        }
    }

    @Override
    public void validate(PigCommandFilter.Command command) throws FrontendException {
        if (this.blacklist.contains(command.name())) {
            throw new FrontendException(command.name() + " command is not permitted. ", 1856);
        }
        if (this.whitelist.size() > 0 && !this.whitelist.contains(command.name())) {
            throw new FrontendException(command.name() + " command is not permitted. ", 1856);
        }
    }
}

