/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.org.roaringbitmap.buffer;

import org.apache.pig.org.roaringbitmap.ContainerBatchIterator;
import org.apache.pig.org.roaringbitmap.buffer.BufferUtil;
import org.apache.pig.org.roaringbitmap.buffer.MappeableRunContainer;

public class RunBatchIterator
implements ContainerBatchIterator {
    private final MappeableRunContainer runs;
    private int run = 0;
    private int cursor = 0;

    public RunBatchIterator(MappeableRunContainer runs) {
        this.runs = runs;
    }

    @Override
    public int next(int key, int[] buffer) {
        int consumed = 0;
        do {
            int runStart = BufferUtil.toIntUnsigned(this.runs.getValue(this.run));
            int runLength = BufferUtil.toIntUnsigned(this.runs.getLength(this.run));
            int chunkStart = runStart + this.cursor;
            int chunkEnd = chunkStart + Math.min(runLength - this.cursor, buffer.length - consumed - 1);
            int chunk = chunkEnd - chunkStart + 1;
            for (int i = 0; i < chunk; ++i) {
                buffer[consumed + i] = key + chunkStart + i;
            }
            consumed += chunk;
            if (runStart + runLength == chunkEnd) {
                ++this.run;
                this.cursor = 0;
                continue;
            }
            this.cursor += chunk;
        } while (consumed < buffer.length && this.run != this.runs.numberOfRuns());
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return this.run < this.runs.numberOfRuns();
    }
}

