/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ListOfCovNotifications implements Message {

  // Properties.
  protected final BACnetContextTagObjectIdentifier monitoredObjectIdentifier;
  protected final BACnetOpeningTag openingTag;
  protected final List<ListOfCovNotificationsValue> listOfValues;
  protected final BACnetClosingTag closingTag;

  public ListOfCovNotifications(
      BACnetContextTagObjectIdentifier monitoredObjectIdentifier,
      BACnetOpeningTag openingTag,
      List<ListOfCovNotificationsValue> listOfValues,
      BACnetClosingTag closingTag) {
    super();
    this.monitoredObjectIdentifier = monitoredObjectIdentifier;
    this.openingTag = openingTag;
    this.listOfValues = listOfValues;
    this.closingTag = closingTag;
  }

  public BACnetContextTagObjectIdentifier getMonitoredObjectIdentifier() {
    return monitoredObjectIdentifier;
  }

  public BACnetOpeningTag getOpeningTag() {
    return openingTag;
  }

  public List<ListOfCovNotificationsValue> getListOfValues() {
    return listOfValues;
  }

  public BACnetClosingTag getClosingTag() {
    return closingTag;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ListOfCovNotifications");

    // Simple Field (monitoredObjectIdentifier)
    writeSimpleField(
        "monitoredObjectIdentifier", monitoredObjectIdentifier, writeComplex(writeBuffer));

    // Simple Field (openingTag)
    writeSimpleField("openingTag", openingTag, writeComplex(writeBuffer));

    // Array Field (listOfValues)
    writeComplexTypeArrayField("listOfValues", listOfValues, writeBuffer);

    // Simple Field (closingTag)
    writeSimpleField("closingTag", closingTag, writeComplex(writeBuffer));

    writeBuffer.popContext("ListOfCovNotifications");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ListOfCovNotifications _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (monitoredObjectIdentifier)
    lengthInBits += monitoredObjectIdentifier.getLengthInBits();

    // Simple field (openingTag)
    lengthInBits += openingTag.getLengthInBits();

    // Array field
    if (listOfValues != null) {
      for (Message element : listOfValues) {
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (closingTag)
    lengthInBits += closingTag.getLengthInBits();

    return lengthInBits;
  }

  public static ListOfCovNotifications staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("ListOfCovNotifications");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagObjectIdentifier monitoredObjectIdentifier =
        readSimpleField(
            "monitoredObjectIdentifier",
            readComplex(
                () ->
                    (BACnetContextTagObjectIdentifier)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.BACNET_OBJECT_IDENTIFIER)),
                readBuffer));

    BACnetOpeningTag openingTag =
        readSimpleField(
            "openingTag",
            readComplex(() -> BACnetOpeningTag.staticParse(readBuffer, (short) (1)), readBuffer));

    List<ListOfCovNotificationsValue> listOfValues =
        readTerminatedArrayField(
            "listOfValues",
            readComplex(
                () ->
                    ListOfCovNotificationsValue.staticParse(
                        readBuffer, (BACnetObjectType) (monitoredObjectIdentifier.getObjectType())),
                readBuffer),
            () ->
                ((boolean)
                    (org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper
                        .isBACnetConstructedDataClosingTag(readBuffer, false, 1))));

    BACnetClosingTag closingTag =
        readSimpleField(
            "closingTag",
            readComplex(() -> BACnetClosingTag.staticParse(readBuffer, (short) (1)), readBuffer));

    readBuffer.closeContext("ListOfCovNotifications");
    // Create the instance
    ListOfCovNotifications _listOfCovNotifications;
    _listOfCovNotifications =
        new ListOfCovNotifications(monitoredObjectIdentifier, openingTag, listOfValues, closingTag);
    return _listOfCovNotifications;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ListOfCovNotifications)) {
      return false;
    }
    ListOfCovNotifications that = (ListOfCovNotifications) o;
    return (getMonitoredObjectIdentifier() == that.getMonitoredObjectIdentifier())
        && (getOpeningTag() == that.getOpeningTag())
        && (getListOfValues() == that.getListOfValues())
        && (getClosingTag() == that.getClosingTag())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getMonitoredObjectIdentifier(), getOpeningTag(), getListOfValues(), getClosingTag());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
