/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CALReplyLong extends CALReply implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final int terminatingByte;
  protected final UnitAddress unitAddress;
  protected final BridgeAddress bridgeAddress;
  protected final SerialInterfaceAddress serialInterfaceAddress;
  protected final Byte reservedByte;
  protected final ReplyNetwork replyNetwork;

  // Arguments.
  protected final CBusOptions cBusOptions;
  protected final RequestContext requestContext;
  // Reserved Fields
  private Byte reservedField0;

  public CALReplyLong(
      byte calType,
      CALData calData,
      int terminatingByte,
      UnitAddress unitAddress,
      BridgeAddress bridgeAddress,
      SerialInterfaceAddress serialInterfaceAddress,
      Byte reservedByte,
      ReplyNetwork replyNetwork,
      CBusOptions cBusOptions,
      RequestContext requestContext) {
    super(calType, calData, cBusOptions, requestContext);
    this.terminatingByte = terminatingByte;
    this.unitAddress = unitAddress;
    this.bridgeAddress = bridgeAddress;
    this.serialInterfaceAddress = serialInterfaceAddress;
    this.reservedByte = reservedByte;
    this.replyNetwork = replyNetwork;
    this.cBusOptions = cBusOptions;
    this.requestContext = requestContext;
  }

  public int getTerminatingByte() {
    return terminatingByte;
  }

  public UnitAddress getUnitAddress() {
    return unitAddress;
  }

  public BridgeAddress getBridgeAddress() {
    return bridgeAddress;
  }

  public SerialInterfaceAddress getSerialInterfaceAddress() {
    return serialInterfaceAddress;
  }

  public Byte getReservedByte() {
    return reservedByte;
  }

  public ReplyNetwork getReplyNetwork() {
    return replyNetwork;
  }

  public boolean getIsUnitAddress() {
    return (boolean) ((((getTerminatingByte()) & (0xff))) == (0x00));
  }

  @Override
  protected void serializeCALReplyChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CALReplyLong");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (byte) 0x86,
        writeByte(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isUnitAddress = getIsUnitAddress();
    writeBuffer.writeVirtual("isUnitAddress", isUnitAddress);

    // Optional Field (unitAddress) (Can be skipped, if the value is null)
    writeOptionalField("unitAddress", unitAddress, writeComplex(writeBuffer), getIsUnitAddress());

    // Optional Field (bridgeAddress) (Can be skipped, if the value is null)
    writeOptionalField(
        "bridgeAddress", bridgeAddress, writeComplex(writeBuffer), !(getIsUnitAddress()));

    // Simple Field (serialInterfaceAddress)
    writeSimpleField("serialInterfaceAddress", serialInterfaceAddress, writeComplex(writeBuffer));

    // Optional Field (reservedByte) (Can be skipped, if the value is null)
    writeOptionalField("reservedByte", reservedByte, writeByte(writeBuffer, 8), getIsUnitAddress());

    // Optional Field (replyNetwork) (Can be skipped, if the value is null)
    writeOptionalField(
        "replyNetwork", replyNetwork, writeComplex(writeBuffer), !(getIsUnitAddress()));

    writeBuffer.popContext("CALReplyLong");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CALReplyLong _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Optional Field (unitAddress)
    if (unitAddress != null) {
      lengthInBits += unitAddress.getLengthInBits();
    }

    // Optional Field (bridgeAddress)
    if (bridgeAddress != null) {
      lengthInBits += bridgeAddress.getLengthInBits();
    }

    // Simple field (serialInterfaceAddress)
    lengthInBits += serialInterfaceAddress.getLengthInBits();

    // Optional Field (reservedByte)
    if (reservedByte != null) {
      lengthInBits += 8;
    }

    // Optional Field (replyNetwork)
    if (replyNetwork != null) {
      lengthInBits += replyNetwork.getLengthInBits();
    }

    return lengthInBits;
  }

  public static CALReplyBuilder staticParseCALReplyBuilder(
      ReadBuffer readBuffer, CBusOptions cBusOptions, RequestContext requestContext)
      throws ParseException {
    readBuffer.pullContext("CALReplyLong");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Byte reservedField0 = readReservedField("reserved", readByte(readBuffer, 8), (byte) 0x86);

    int terminatingByte = readPeekField("terminatingByte", readUnsignedInt(readBuffer, 24));
    boolean isUnitAddress =
        readVirtualField("isUnitAddress", boolean.class, (((terminatingByte) & (0xff))) == (0x00));

    UnitAddress unitAddress =
        readOptionalField(
            "unitAddress",
            readComplex(() -> UnitAddress.staticParse(readBuffer), readBuffer),
            isUnitAddress);

    BridgeAddress bridgeAddress =
        readOptionalField(
            "bridgeAddress",
            readComplex(() -> BridgeAddress.staticParse(readBuffer), readBuffer),
            !(isUnitAddress));

    SerialInterfaceAddress serialInterfaceAddress =
        readSimpleField(
            "serialInterfaceAddress",
            readComplex(() -> SerialInterfaceAddress.staticParse(readBuffer), readBuffer));

    Byte reservedByte = readOptionalField("reservedByte", readByte(readBuffer, 8), isUnitAddress);
    // Validation
    if (!(((isUnitAddress) && ((reservedByte) == (0x00))) || (!(isUnitAddress)))) {
      throw new ParseValidationException("wrong reservedByte");
    }

    ReplyNetwork replyNetwork =
        readOptionalField(
            "replyNetwork",
            readComplex(() -> ReplyNetwork.staticParse(readBuffer), readBuffer),
            !(isUnitAddress));

    readBuffer.closeContext("CALReplyLong");
    // Create the instance
    return new CALReplyLongBuilderImpl(
        terminatingByte,
        unitAddress,
        bridgeAddress,
        serialInterfaceAddress,
        reservedByte,
        replyNetwork,
        cBusOptions,
        requestContext,
        reservedField0);
  }

  public static class CALReplyLongBuilderImpl implements CALReply.CALReplyBuilder {
    private final int terminatingByte;
    private final UnitAddress unitAddress;
    private final BridgeAddress bridgeAddress;
    private final SerialInterfaceAddress serialInterfaceAddress;
    private final Byte reservedByte;
    private final ReplyNetwork replyNetwork;
    private final CBusOptions cBusOptions;
    private final RequestContext requestContext;
    private final Byte reservedField0;

    public CALReplyLongBuilderImpl(
        int terminatingByte,
        UnitAddress unitAddress,
        BridgeAddress bridgeAddress,
        SerialInterfaceAddress serialInterfaceAddress,
        Byte reservedByte,
        ReplyNetwork replyNetwork,
        CBusOptions cBusOptions,
        RequestContext requestContext,
        Byte reservedField0) {
      this.terminatingByte = terminatingByte;
      this.unitAddress = unitAddress;
      this.bridgeAddress = bridgeAddress;
      this.serialInterfaceAddress = serialInterfaceAddress;
      this.reservedByte = reservedByte;
      this.replyNetwork = replyNetwork;
      this.cBusOptions = cBusOptions;
      this.requestContext = requestContext;
      this.reservedField0 = reservedField0;
    }

    public CALReplyLong build(
        byte calType, CALData calData, CBusOptions cBusOptions, RequestContext requestContext) {
      CALReplyLong cALReplyLong =
          new CALReplyLong(
              calType,
              calData,
              terminatingByte,
              unitAddress,
              bridgeAddress,
              serialInterfaceAddress,
              reservedByte,
              replyNetwork,
              cBusOptions,
              requestContext);
      cALReplyLong.reservedField0 = reservedField0;
      return cALReplyLong;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CALReplyLong)) {
      return false;
    }
    CALReplyLong that = (CALReplyLong) o;
    return (getTerminatingByte() == that.getTerminatingByte())
        && (getUnitAddress() == that.getUnitAddress())
        && (getBridgeAddress() == that.getBridgeAddress())
        && (getSerialInterfaceAddress() == that.getSerialInterfaceAddress())
        && (getReservedByte() == that.getReservedByte())
        && (getReplyNetwork() == that.getReplyNetwork())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getTerminatingByte(),
        getUnitAddress(),
        getBridgeAddress(),
        getSerialInterfaceAddress(),
        getReservedByte(),
        getReplyNetwork());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
