/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.modbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ModbusPDUReadFifoQueueRequest extends ModbusPDU implements Message {

  // Accessors for discriminator values.
  public Boolean getErrorFlag() {
    return (boolean) false;
  }

  public Byte getFunctionFlag() {
    return (byte) 0x18;
  }

  public Boolean getResponse() {
    return (boolean) false;
  }

  // Properties.
  protected final int fifoPointerAddress;

  public ModbusPDUReadFifoQueueRequest(int fifoPointerAddress) {
    super();
    this.fifoPointerAddress = fifoPointerAddress;
  }

  public int getFifoPointerAddress() {
    return fifoPointerAddress;
  }

  @Override
  protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ModbusPDUReadFifoQueueRequest");

    // Simple Field (fifoPointerAddress)
    writeSimpleField("fifoPointerAddress", fifoPointerAddress, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("ModbusPDUReadFifoQueueRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ModbusPDUReadFifoQueueRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (fifoPointerAddress)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static ModbusPDUBuilder staticParseModbusPDUBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("ModbusPDUReadFifoQueueRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int fifoPointerAddress = readSimpleField("fifoPointerAddress", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("ModbusPDUReadFifoQueueRequest");
    // Create the instance
    return new ModbusPDUReadFifoQueueRequestBuilderImpl(fifoPointerAddress);
  }

  public static class ModbusPDUReadFifoQueueRequestBuilderImpl
      implements ModbusPDU.ModbusPDUBuilder {
    private final int fifoPointerAddress;

    public ModbusPDUReadFifoQueueRequestBuilderImpl(int fifoPointerAddress) {
      this.fifoPointerAddress = fifoPointerAddress;
    }

    public ModbusPDUReadFifoQueueRequest build() {
      ModbusPDUReadFifoQueueRequest modbusPDUReadFifoQueueRequest =
          new ModbusPDUReadFifoQueueRequest(fifoPointerAddress);
      return modbusPDUReadFifoQueueRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ModbusPDUReadFifoQueueRequest)) {
      return false;
    }
    ModbusPDUReadFifoQueueRequest that = (ModbusPDUReadFifoQueueRequest) o;
    return (getFifoPointerAddress() == that.getFifoPointerAddress()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getFifoPointerAddress());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
