/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest extends S7PayloadUserDataItem
    implements Message {

  // Accessors for discriminator values.
  public Byte getCpuFunctionGroup() {
    return (byte) 0x04;
  }

  public Byte getCpuFunctionType() {
    return (byte) 0x04;
  }

  public Short getCpuSubfunction() {
    return (short) 0x02;
  }

  // Properties.
  protected final short subscription;
  protected final String magicKey;
  protected final AlarmStateType alarmtype;
  protected final Short reserve;

  public S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest(
      DataTransportErrorCode returnCode,
      DataTransportSize transportSize,
      int dataLength,
      short subscription,
      String magicKey,
      AlarmStateType alarmtype,
      Short reserve) {
    super(returnCode, transportSize, dataLength);
    this.subscription = subscription;
    this.magicKey = magicKey;
    this.alarmtype = alarmtype;
    this.reserve = reserve;
  }

  public short getSubscription() {
    return subscription;
  }

  public String getMagicKey() {
    return magicKey;
  }

  public AlarmStateType getAlarmtype() {
    return alarmtype;
  }

  public Short getReserve() {
    return reserve;
  }

  @Override
  protected void serializeS7PayloadUserDataItemChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest");

    // Simple Field (subscription)
    writeSimpleField("subscription", subscription, writeUnsignedShort(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (magicKey)
    writeSimpleField("magicKey", magicKey, writeString(writeBuffer, 64));

    // Optional Field (alarmtype) (Can be skipped, if the value is null)
    writeOptionalEnumField(
        "alarmtype",
        "AlarmStateType",
        alarmtype,
        writeEnum(
            AlarmStateType::getValue, AlarmStateType::name, writeUnsignedShort(writeBuffer, 8)),
        (getSubscription()) >= (128));

    // Optional Field (reserve) (Can be skipped, if the value is null)
    writeOptionalField("reserve", reserve, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (subscription)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (magicKey)
    lengthInBits += 64;

    // Optional Field (alarmtype)
    if (alarmtype != null) {
      lengthInBits += 8;
    }

    // Optional Field (reserve)
    if (reserve != null) {
      lengthInBits += 8;
    }

    return lengthInBits;
  }

  public static S7PayloadUserDataItemBuilder staticParseS7PayloadUserDataItemBuilder(
      ReadBuffer readBuffer, Byte cpuFunctionGroup, Byte cpuFunctionType, Short cpuSubfunction)
      throws ParseException {
    readBuffer.pullContext("S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short subscription = readSimpleField("subscription", readUnsignedShort(readBuffer, 8));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

    String magicKey = readSimpleField("magicKey", readString(readBuffer, 64));

    AlarmStateType alarmtype =
        readOptionalField(
            "alarmtype",
            readEnum(AlarmStateType::enumForValue, readUnsignedShort(readBuffer, 8)),
            (subscription) >= (128));

    Short reserve =
        readOptionalField("reserve", readUnsignedShort(readBuffer, 8), (subscription) >= (128));

    readBuffer.closeContext("S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest");
    // Create the instance
    return new S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequestBuilderImpl(
        subscription, magicKey, alarmtype, reserve);
  }

  public static class S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequestBuilderImpl
      implements S7PayloadUserDataItem.S7PayloadUserDataItemBuilder {
    private final short subscription;
    private final String magicKey;
    private final AlarmStateType alarmtype;
    private final Short reserve;

    public S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequestBuilderImpl(
        short subscription, String magicKey, AlarmStateType alarmtype, Short reserve) {
      this.subscription = subscription;
      this.magicKey = magicKey;
      this.alarmtype = alarmtype;
      this.reserve = reserve;
    }

    public S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest build(
        DataTransportErrorCode returnCode, DataTransportSize transportSize, int dataLength) {
      S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest
          s7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest =
              new S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest(
                  returnCode,
                  transportSize,
                  dataLength,
                  subscription,
                  magicKey,
                  alarmtype,
                  reserve);
      return s7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest)) {
      return false;
    }
    S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest that =
        (S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest) o;
    return (getSubscription() == that.getSubscription())
        && (getMagicKey() == that.getMagicKey())
        && (getAlarmtype() == that.getAlarmtype())
        && (getReserve() == that.getReserve())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getSubscription(), getMagicKey(), getAlarmtype(), getReserve());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
