/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.Map;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.agent.impl.AbstractDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgent;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.monitor.impl.MonitoringDistributionQueueProvider;
import org.apache.sling.distribution.monitor.impl.QueueDistributionAgentMBean;
import org.apache.sling.distribution.monitor.impl.QueueDistributionAgentMBeanImpl;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.exporter.LocalDistributionPackageExporter;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.DistributionQueueProviderFactory;
import org.apache.sling.distribution.queue.impl.PriorityQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.SingleQueueDispatchingStrategy;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"webconsole.configurationFactory.nameHint=Agent name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class QueueDistributionAgentFactory
extends AbstractDistributionAgentFactory<QueueDistributionAgentMBean> {
    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String DETAILS = "details";
    private static final String SERVICE_NAME = "serviceName";
    public static final String LOG_LEVEL = "log.level";
    private static final String ALLOWED_ROOTS = "allowed.roots";
    public static final String TRIGGERS_TARGET = "triggers.target";
    private static final String PRIORITY_QUEUES = "priorityQueues";
    @Reference(name="requestAuthorizationStrategy")
    private DistributionRequestAuthorizationStrategy requestAuthorizationStrategy;
    @Reference(name="queueProviderFactory")
    private DistributionQueueProviderFactory queueProviderFactory;
    @Reference(name="packageBuilder")
    private DistributionPackageBuilder packageBuilder;
    @Reference
    private Packaging packaging;
    @Reference
    private DistributionEventFactory distributionEventFactory;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingRepository slingRepository;
    DistributionQueueProvider queueProvider;

    public QueueDistributionAgentFactory() {
        super(QueueDistributionAgentMBean.class);
    }

    @Override
    @Activate
    protected void activate(BundleContext context, Map<String, Object> config) {
        super.activate(context, config);
    }

    @Override
    @Reference(name="triggers", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, bind="bindDistributionTrigger", unbind="unbindDistributionTrigger")
    protected void bindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        super.bindDistributionTrigger(distributionTrigger, config);
    }

    @Override
    protected void unbindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        super.unbindDistributionTrigger(distributionTrigger, config);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext context) {
        super.deactivate(context);
        this.queueProviderFactory.releaseProvider(this.queueProvider);
    }

    @Override
    protected SimpleDistributionAgent createAgent(String agentName, BundleContext context, Map<String, Object> config, DefaultDistributionLog distributionLog) {
        String serviceName = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(SERVICE_NAME), null));
        String[] allowedRoots = PropertiesUtil.toStringArray((Object)config.get(ALLOWED_ROOTS), null);
        allowedRoots = SettingsUtils.removeEmptyEntries(allowedRoots);
        Map<String, String> priorityQueues = PropertiesUtil.toMap((Object)config.get(PRIORITY_QUEUES), (String[])new String[0]);
        priorityQueues = SettingsUtils.removeEmptyEntries(priorityQueues);
        this.queueProvider = this.queueProviderFactory.getProvider(agentName, serviceName);
        MonitoringDistributionQueueProvider monitoringQueueProvider = new MonitoringDistributionQueueProvider(this.queueProvider, context);
        DistributionQueueDispatchingStrategy exportQueueStrategy = null;
        exportQueueStrategy = priorityQueues != null ? new PriorityQueueDispatchingStrategy(priorityQueues, new String[]{"default"}) : new SingleQueueDispatchingStrategy();
        LocalDistributionPackageExporter packageExporter = new LocalDistributionPackageExporter(this.packageBuilder);
        DistributionRequestType[] allowedRequests = new DistributionRequestType[]{DistributionRequestType.ADD, DistributionRequestType.DELETE};
        return new SimpleDistributionAgent(agentName, false, null, serviceName, null, packageExporter, this.requestAuthorizationStrategy, monitoringQueueProvider, exportQueueStrategy, null, this.distributionEventFactory, this.resourceResolverFactory, this.slingRepository, distributionLog, allowedRequests, allowedRoots, 0);
    }

    @Override
    protected QueueDistributionAgentMBean createMBeanAgent(DistributionAgent agent, Map<String, Object> osgiConfiguration) {
        return new QueueDistributionAgentMBeanImpl(agent, osgiConfiguration);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Agent - Queue Agents Factory", description="OSGi configuration factory for queueing agents")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the agent.")
        public String name() default "";

        @AttributeDefinition(name="Title", description="The display friendly title of the agent.")
        public String title() default "";

        @AttributeDefinition(name="Details", description="The display friendly details of the agent.")
        public String details() default "";

        @AttributeDefinition(name="Enabled", description="Whether or not to start the distribution agent.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Service Name", description="The name of the service used to access the repository. If not set, the calling user ResourceResolver will be used")
        public String serviceName() default "";

        @AttributeDefinition(name="Log Level", description="The log level recorded in the transient log accessible via http.", options={@Option(label="debug", value="debug"), @Option(label="info", value="info"), @Option(label="warn", value="warn"), @Option(label="error", value="error")})
        public String log_level() default "info";

        @AttributeDefinition(cardinality=100, name="Allowed roots", description="If set the agent will allow only distribution requests under the specified roots.")
        public String[] allowed_roots();

        @AttributeDefinition(name="Request Authorization Strategy", description="The target reference for the DistributionRequestAuthorizationStrategy used to authorize the access to distribution process,e.g. use target=(name=...) to bind to services by name.")
        public String requestAuthorizationStrategy_target() default "(name=default)";

        @AttributeDefinition(name="Queue Provider Factory", description="The target reference for the DistributionQueueProviderFactory used to build queues,e.g. use target=(name=...) to bind to services by name.")
        public String queueProviderFactory_target() default "(name=jobQueue)";

        @AttributeDefinition(name="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.")
        public String packageBuilder_target() default "(name=default)";

        @AttributeDefinition(name="Triggers", description="The target reference for DistributionTrigger used to trigger distribution, e.g. use target=(name=...) to bind to services by name.")
        public String triggers_target() default "(name=)";

        @AttributeDefinition(cardinality=100, name="Priority queues", description="List of priority queues that should used for specific paths.The selector format is  {queuePrefix}[|{mainQueueMatcher}]={pathMatcher}, e.g. french=/content/fr.*")
        public String[] priorityQueues();
    }
}

