/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.console.core.entity.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="t_app_backup")
public class ApplicationBackUp {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBackUp.class);
    @TableId(type=IdType.AUTO)
    private Long id;
    private Long appId;
    private Long sqlId;
    private Long configId;
    private String path;
    private String description;
    private Integer version;
    private Date createTime;
    private transient boolean backup;

    public ApplicationBackUp() {
    }

    public ApplicationBackUp(Application application) {
        this.appId = application.getId();
        this.sqlId = application.getSqlId();
        this.configId = application.getConfigId();
        this.description = application.getBackUpDescription();
        this.createTime = new Date();
        switch (application.getExecutionModeEnum()) {
            case KUBERNETES_NATIVE_APPLICATION: 
            case KUBERNETES_NATIVE_SESSION: 
            case YARN_PER_JOB: 
            case YARN_SESSION: 
            case REMOTE: 
            case LOCAL: {
                this.path = String.format("%s/%d/%d", Workspace.local().APP_BACKUPS(), application.getId(), this.createTime.getTime());
                break;
            }
            case YARN_APPLICATION: {
                this.path = String.format("%s/%d/%d", Workspace.remote().APP_BACKUPS(), application.getId(), this.createTime.getTime());
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported executionMode ".concat(application.getExecutionModeEnum().getName()));
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getAppId() {
        return this.appId;
    }

    public Long getSqlId() {
        return this.sqlId;
    }

    public Long getConfigId() {
        return this.configId;
    }

    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setSqlId(Long sqlId) {
        this.sqlId = sqlId;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationBackUp)) {
            return false;
        }
        ApplicationBackUp other = (ApplicationBackUp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$appId = this.getAppId();
        Long other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        Long this$sqlId = this.getSqlId();
        Long other$sqlId = other.getSqlId();
        if (this$sqlId == null ? other$sqlId != null : !((Object)this$sqlId).equals(other$sqlId)) {
            return false;
        }
        Long this$configId = this.getConfigId();
        Long other$configId = other.getConfigId();
        if (this$configId == null ? other$configId != null : !((Object)this$configId).equals(other$configId)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationBackUp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        Long $sqlId = this.getSqlId();
        result = result * 59 + ($sqlId == null ? 43 : ((Object)$sqlId).hashCode());
        Long $configId = this.getConfigId();
        result = result * 59 + ($configId == null ? 43 : ((Object)$configId).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "ApplicationBackUp(id=" + this.getId() + ", appId=" + this.getAppId() + ", sqlId=" + this.getSqlId() + ", configId=" + this.getConfigId() + ", path=" + this.getPath() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", createTime=" + this.getCreateTime() + ", backup=" + this.isBackup() + ")";
    }
}

