/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.ingress;

import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.flink.client.program.ClusterClient;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4q\u0001C\u0005\u0011\u0002\u0007\u0005a\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003#\u0001\u0019\u00051\u0005C\u0003K\u0001\u0019\u00051\nC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003W\u0001\u0011\u0005q\u000bC\u0003]\u0001\u0011\u0005Q\fC\u0003`\u0001\u0011\u0005\u0001MA\bJ]\u001e\u0014Xm]:TiJ\fG/Z4z\u0015\tQ1\"A\u0004j]\u001e\u0014Xm]:\u000b\u00051i\u0011AC6vE\u0016\u0014h.\u001a;fg*\u0011abD\u0001\u0006M2Lgn\u001b\u0006\u0003!E\t!b\u001d;sK\u0006l\u0007/\u0019:l\u0015\t\u00112#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005y\u0002C\u0001\r!\u0013\t\t\u0013D\u0001\u0003V]&$\u0018!E5oOJ,7o]+sY\u0006#GM]3tgR!AeL\u00194!\t)CF\u0004\u0002'UA\u0011q%G\u0007\u0002Q)\u0011\u0011&F\u0001\u0007yI|w\u000e\u001e \n\u0005-J\u0012A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!aK\r\t\u000bA\u0012\u0001\u0019\u0001\u0013\u0002\u00139\fW.Z*qC\u000e,\u0007\"\u0002\u001a\u0003\u0001\u0004!\u0013!C2mkN$XM]%e\u0011\u0015!$\u00011\u00016\u00035\u0019G.^:uKJ\u001cE.[3oiB\u0012a'\u0011\t\u0004ouzT\"\u0001\u001d\u000b\u0005eR\u0014a\u00029s_\u001e\u0014\u0018-\u001c\u0006\u0003wq\naa\u00197jK:$(B\u0001\b\u0012\u0013\tq\u0004HA\u0007DYV\u001cH/\u001a:DY&,g\u000e\u001e\t\u0003\u0001\u0006c\u0001\u0001B\u0005Cg\u0005\u0005\t\u0011!B\u0001\u0007\n\u0019q\fJ\u0019\u0012\u0005\u0011;\u0005C\u0001\rF\u0013\t1\u0015DA\u0004O_RD\u0017N\\4\u0011\u0005aA\u0015BA%\u001a\u0005\r\te._\u0001\u0011G>tg-[4ve\u0016Len\u001a:fgN$Ba\b'O\u001f\")Qj\u0001a\u0001I\u0005QAm\\7bS:t\u0015-\\3\t\u000bI\u001a\u0001\u0019\u0001\u0013\t\u000bA\u001a\u0001\u0019\u0001\u0013\u00027A\u0014X\r]1sK&swM]3tgR+W\u000e\u001d7bi\u00164\u0015\u000e\\3t)\r!#\u000b\u0016\u0005\u0006'\u0012\u0001\r\u0001J\u0001\u000fEVLG\u000eZ,pe.\u001c\b/Y2f\u0011\u0015)F\u00011\u0001%\u0003AIgn\u001a:fgN$V-\u001c9mCR,7/A\fck&dG-\u00138he\u0016\u001c8/\u00118o_R\fG/[8ogR\u0011\u0001l\u0017\t\u0005Ke#C%\u0003\u0002[]\t\u0019Q*\u00199\t\u000bI*\u0001\u0019\u0001\u0013\u0002%\t,\u0018\u000e\u001c3J]\u001e\u0014Xm]:MC\n,Gn\u001d\u000b\u00031zCQA\r\u0004A\u0002\u0011\n\u0011cZ3u\u001f^tWM\u001d*fM\u0016\u0014XM\\2f)\u0011\tgn\u001c9\u0011\u0005\tdW\"A2\u000b\u0005\u0011,\u0017!B7pI\u0016d'B\u00014h\u0003\r\t\u0007/\u001b\u0006\u0003\u0019!T!!\u001b6\u0002\u000f\u0019\f'M]5dq)\t1.\u0001\u0002j_&\u0011Qn\u0019\u0002\u000f\u001f^tWM\u001d*fM\u0016\u0014XM\\2f\u0011\u0015\u0001t\u00011\u0001%\u0011\u0015\u0011t\u00011\u0001%\u0011\u0015Yt\u00011\u0001r!\t\u0011H/D\u0001t\u0015\tYt-\u0003\u0002vg\n9B)\u001a4bk2$8*\u001e2fe:,G/Z:DY&,g\u000e\u001e")
public interface IngressStrategy {
    public String ingressUrlAddress(String var1, String var2, ClusterClient<?> var3);

    public void configureIngress(String var1, String var2, String var3);

    public static /* synthetic */ String prepareIngressTemplateFiles$(IngressStrategy $this, String buildWorkspace, String ingressTemplates) {
        return $this.prepareIngressTemplateFiles(buildWorkspace, ingressTemplates);
    }

    default public String prepareIngressTemplateFiles(String buildWorkspace, String ingressTemplates) {
        String string;
        File workspaceDir = new File(buildWorkspace);
        Object object = !workspaceDir.exists() ? BoxesRunTime.boxToBoolean((boolean)workspaceDir.mkdir()) : BoxedUnit.UNIT;
        if (ingressTemplates.isEmpty()) {
            string = null;
        } else {
            String outputPath = new StringBuilder(13).append(buildWorkspace).append("/ingress.yaml").toString();
            File outputFile = new File(outputPath);
            FileUtils.write((File)outputFile, (CharSequence)ingressTemplates, (String)"UTF-8");
            string = outputPath;
        }
        return string;
    }

    public static /* synthetic */ Map buildIngressAnnotations$(IngressStrategy $this, String clusterId) {
        return $this.buildIngressAnnotations(clusterId);
    }

    default public Map<String, String> buildIngressAnnotations(String clusterId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/rewrite-target"), (Object)"/$2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/proxy-body-size"), (Object)"1024m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/configuration-snippet"), (Object)new StringBuilder(28).append("rewrite ^(/").append(clusterId).append(")$ $1/ permanent;").toString())}));
    }

    public static /* synthetic */ Map buildIngressLabels$(IngressStrategy $this, String clusterId) {
        return $this.buildIngressLabels(clusterId);
    }

    default public Map<String, String> buildIngressLabels(String clusterId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"app"), (Object)clusterId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"flink-native-kubernetes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"ingress")}));
    }

    public static /* synthetic */ OwnerReference getOwnerReference$(IngressStrategy $this, String nameSpace, String clusterId, DefaultKubernetesClient client) {
        return $this.getOwnerReference(nameSpace, clusterId, client);
    }

    default public OwnerReference getOwnerReference(String nameSpace, String clusterId, DefaultKubernetesClient client) {
        Deployment deployment = (Deployment)((Gettable)((Nameable)client.apps().deployments().inNamespace(nameSpace)).withName(clusterId)).get();
        Predef$.MODULE$.require(deployment != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Deployment with name ").append(clusterId).append(" not found in namespace ").append(nameSpace).toString());
        return ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withUid(deployment.getMetadata().getUid())).withApiVersion("apps/v1")).withKind("Deployment")).withName(clusterId)).withController(Predef$.MODULE$.boolean2Boolean(true))).withBlockOwnerDeletion(Predef$.MODULE$.boolean2Boolean(true))).build();
    }

    public static void $init$(IngressStrategy $this) {
    }
}

