/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LibMatrixSketch {
    public static MatrixBlock getUniqueValues(MatrixBlock blkIn, Types.Direction dir) {
        int rlen = blkIn.getNumRows();
        int clen = blkIn.getNumColumns();
        MatrixBlock blkOut = null;
        switch (dir) {
            case RowCol: {
                if (clen != 1) {
                    throw new NotImplementedException("Unique only support single-column vectors yet");
                }
                HashSet<Double> hashSet = new HashSet<Double>();
                for (int i = 0; i < rlen; ++i) {
                    hashSet.add(blkIn.quickGetValue(i, 0));
                }
                int rlen2 = hashSet.size();
                blkOut = new MatrixBlock(rlen2, 1, false).allocateBlock();
                Iterator iter = hashSet.iterator();
                for (int i = 0; i < rlen2; ++i) {
                    blkOut.quickSetValue(i, 0, (Double)iter.next());
                }
                break;
            }
            case Row: 
            case Col: {
                throw new NotImplementedException("Unique Row/Col has not been implemented yet");
            }
            default: {
                throw new IllegalArgumentException("Unrecognized direction: " + dir);
            }
        }
        return blkOut;
    }
}

