/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;

final class ConversionKeys
implements ObjectConverter<String, String> {
    private static final String PREFIX = "conversion.";
    private static final ConversionKeys ADD = new ConversionKeys(true);
    private static final ConversionKeys REMOVE = new ConversionKeys(false);
    private final boolean add;

    private ConversionKeys(boolean add) {
        this.add = add;
    }

    static <V> Map<String, V> unprefix(Map<String, V> properties) {
        return ObjectConverters.derivedKeys(properties, REMOVE, Object.class);
    }

    @Override
    public Class<String> getSourceClass() {
        return String.class;
    }

    @Override
    public Class<String> getTargetClass() {
        return String.class;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return EnumSet.of(FunctionProperty.INVERTIBLE, FunctionProperty.ORDER_PRESERVING, this.add ? FunctionProperty.INJECTIVE : FunctionProperty.SURJECTIVE);
    }

    @Override
    public String apply(String key) {
        if (this.add) {
            return PREFIX + key;
        }
        return key.startsWith(PREFIX) ? key.substring(PREFIX.length()) : null;
    }

    @Override
    public ObjectConverter<String, String> inverse() {
        return this.add ? REMOVE : ADD;
    }
}

