/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet.impl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.messagelet.impl.ServletResponseImpl;

public class HttpServletResponseImpl
extends ServletResponseImpl
implements HttpServletResponse {
    protected ArrayList cookies = new ArrayList();
    protected static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected HashMap headers = new HashMap();
    protected String message = this.getStatusMessage(200);
    protected int status = 200;
    protected static final TimeZone zone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie[] getCookies() {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            return this.cookies.toArray(new Cookie[this.cookies.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader(String name) {
        ArrayList values = null;
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            values = (ArrayList)this.headers.get(name);
        }
        if (values != null) {
            return (String)values.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderNames() {
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            String[] results = new String[this.headers.size()];
            return this.headers.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderValues(String name) {
        ArrayList values = null;
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            values = (ArrayList)this.headers.get(name);
        }
        if (values == null) {
            return new String[0];
        }
        String[] results = new String[values.size()];
        return values.toArray(results);
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public void recycle() {
        this.cookies.clear();
        this.headers.clear();
        this.message = this.getStatusMessage(200);
        this.status = 200;
    }

    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    protected String getStatusMessage(int status) {
        switch (status) {
            case 200: {
                return "OK";
            }
            case 202: {
                return "Accepted";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 400: {
                return "Bad Request";
            }
            case 409: {
                return "Conflict";
            }
            case 100: {
                return "Continue";
            }
            case 201: {
                return "Created";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 403: {
                return "Forbidden";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 410: {
                return "Gone";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 411: {
                return "Length Required";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 204: {
                return "No Content";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 404: {
                return "Not Found";
            }
            case 501: {
                return "Not Implemented";
            }
            case 304: {
                return "Not Modified";
            }
            case 206: {
                return "Partial Content";
            }
            case 402: {
                return "Payment Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 408: {
                return "Request Timeout";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 205: {
                return "Reset Content";
            }
            case 303: {
                return "See Other";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 401: {
                return "Unauthorized";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 305: {
                return "Use Proxy";
            }
            case 207: {
                return "Multi-Status";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 507: {
                return "Insufficient Storage";
            }
        }
        return "HTTP Response Status " + status;
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
    }

    public void reset() {
        if (this.included) {
            return;
        }
        super.reset();
        this.cookies.clear();
        this.headers.clear();
        this.message = null;
        this.status = 200;
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setContentLength(length);
    }

    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setContentType(type);
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setLocale(locale);
        String language = locale.getLanguage();
        if (language != null && language.length() > 0) {
            String country = locale.getCountry();
            StringBuffer value = new StringBuffer(language);
            if (country != null && country.length() > 0) {
                value.append('-');
                value.append(country);
            }
            this.setHeader("Content-Language", value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.add(cookie);
        }
    }

    public void addDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, format.format(new Date(value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList<String> values = (ArrayList<String>)this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsHeader(String name) {
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            return this.headers.get(name) != null;
        }
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, this.getStatusMessage(status));
    }

    public void sendError(int status, String message) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot send error, already committed");
        }
        if (this.included) {
            return;
        }
        this.status = status;
        this.message = message;
        this.resetBuffer();
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot send error, already committed");
        }
        if (this.included) {
            return;
        }
        this.resetBuffer();
        String absolute = location;
        this.setStatus(302);
        this.setHeader("Location", absolute);
    }

    public void setDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, format.format(new Date(value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            this.headers.put(name, values);
        }
        String match = name.toLowerCase();
        if (match.equals("content-length")) {
            int contentLength = -1;
            try {
                contentLength = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (contentLength >= 0) {
                this.setContentLength(contentLength);
            }
        } else if (match.equals("content-type")) {
            this.setContentType(value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.setStatus(status, this.getStatusMessage(status));
    }

    public void setStatus(int status, String message) {
        if (this.included) {
            return;
        }
        this.status = status;
        this.message = message;
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        zone = TimeZone.getTimeZone("GMT");
    }
}

