/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet.impl;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public class HttpSessionImpl
implements HttpSession,
Serializable {
    private static final String NOT_SERIALIZED = "___NOT_SERIALIZABLE_EXCEPTION___";
    private HashMap attributes = new HashMap();
    private transient String authType = null;
    private long creationTime = 0L;
    private transient int debug = 0;
    private transient boolean expiring = false;
    private String id = null;
    private long lastAccessedTime = this.creationTime;
    private transient ArrayList listeners = new ArrayList();
    private int maxInactiveInterval = -1;
    private boolean isNew = false;
    private boolean isValid = false;
    private transient HashMap notes = new HashMap();
    private transient Principal principal = null;
    private transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    private long thisAccessedTime = this.creationTime;
    protected ServletContext servletContext;
    private boolean distributable = false;

    public HttpSessionImpl(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        String oldAuthType = this.authType;
        this.authType = authType;
        this.support.firePropertyChange("authType", oldAuthType, this.authType);
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
        this.lastAccessedTime = time;
        this.thisAccessedTime = time;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call getMaxInactiveInterval on an invalidated session");
        }
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void access() {
        this.isNew = false;
        this.lastAccessedTime = this.thisAccessedTime;
        this.thisAccessedTime = System.currentTimeMillis();
    }

    public void expire() {
        if (this.expiring) {
            return;
        }
        this.expiring = true;
        this.setValid(false);
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            this.removeAttribute(keys[i]);
            ++i;
        }
        this.expiring = false;
    }

    public void passivate() {
        HttpSessionEvent event = null;
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            Object attribute = this.getAttribute(keys[i]);
            if (attribute instanceof HttpSessionActivationListener) {
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                ((HttpSessionActivationListener)attribute).sessionWillPassivate(event);
            }
            ++i;
        }
    }

    public void activate() {
        HttpSessionEvent event = null;
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            Object attribute = this.getAttribute(keys[i]);
            if (attribute instanceof HttpSessionActivationListener) {
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                ((HttpSessionActivationListener)attribute).sessionDidActivate(event);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNote(String name) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            return this.notes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getNoteNames() {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            return this.notes.keySet().iterator();
        }
    }

    public void recycle() {
        this.attributes.clear();
        this.setAuthType(null);
        this.creationTime = 0L;
        this.expiring = false;
        this.id = null;
        this.lastAccessedTime = 0L;
        this.maxInactiveInterval = -1;
        this.setPrincipal(null);
        this.isNew = false;
        this.isValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(String name) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String name, Object value) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.put(name, value);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardSession[");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    void readObjectData(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.readObject(stream);
    }

    void writeObjectData(ObjectOutputStream stream) throws IOException {
        this.writeObject(stream);
    }

    public long getCreationTime() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call getCreationTime() on invalidated session");
        }
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call getAttribute() on invalidated session");
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call getAttributeNames() on invalidated session");
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new IteratorEnumeration(this.attributes.keySet().iterator());
        }
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call getValueNames() on invalidated session");
        }
        return this.keys();
    }

    public void invalidate() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call invalidate() on invalidated session");
        }
        this.expire();
    }

    public boolean isNew() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call isNew() on invalidated session");
        }
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (!this.expiring && !this.isValid) {
            throw new IllegalStateException("Cannot call removeAttribute() on an invalidated session");
        }
        Object value = null;
        boolean found = false;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            found = this.attributes.containsKey(name);
            if (!found) {
                return;
            }
            value = this.attributes.get(name);
            this.attributes.remove(name);
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValid) {
            throw new IllegalStateException("You cannot call this method on an invalidated session");
        }
        if (this.distributable && !(value instanceof Serializable)) {
            throw new IllegalArgumentException("Attribute value must be Serializable");
        }
        Object unbound = null;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            unbound = this.attributes.get(name);
            this.attributes.put(name, value);
        }
        if (unbound != null && unbound instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
        HttpSessionBindingEvent event = null;
        event = unbound != null ? new HttpSessionBindingEvent((HttpSession)this, name, unbound) : new HttpSessionBindingEvent((HttpSession)this, name, value);
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.authType = null;
        this.creationTime = (Long)stream.readObject();
        this.lastAccessedTime = (Long)stream.readObject();
        this.maxInactiveInterval = (Integer)stream.readObject();
        this.isNew = (Boolean)stream.readObject();
        this.isValid = (Boolean)stream.readObject();
        this.thisAccessedTime = (Long)stream.readObject();
        this.principal = null;
        this.setId((String)stream.readObject());
        if (this.debug >= 2) {
            this.log("readObject() loading session " + this.id);
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        int n = (Integer)stream.readObject();
        boolean isValidSave = this.isValid;
        this.isValid = true;
        int i = 0;
        while (i < n) {
            String name = (String)stream.readObject();
            Object value = stream.readObject();
            if (!(value instanceof String) || !value.equals(NOT_SERIALIZED)) {
                if (this.debug >= 2) {
                    this.log("  loading attribute '" + name + "' with value '" + value + "'");
                }
                HashMap hashMap = this.attributes;
                synchronized (hashMap) {
                    this.attributes.put(name, value);
                }
            }
            ++i;
        }
        this.isValid = isValidSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(new Long(this.creationTime));
        stream.writeObject(new Long(this.lastAccessedTime));
        stream.writeObject(new Integer(this.maxInactiveInterval));
        stream.writeObject(new Boolean(this.isNew));
        stream.writeObject(new Boolean(this.isValid));
        stream.writeObject(new Long(this.thisAccessedTime));
        stream.writeObject(this.id);
        if (this.debug >= 2) {
            this.log("writeObject() storing session " + this.id);
        }
        String[] keys = this.keys();
        ArrayList<String> saveNames = new ArrayList<String>();
        ArrayList saveValues = new ArrayList();
        ArrayList<String> unbinds = new ArrayList<String>();
        int i = 0;
        while (i < keys.length) {
            Object value = null;
            HashMap hashMap = this.attributes;
            synchronized (hashMap) {
                value = this.attributes.get(keys[i]);
            }
            if (value != null) {
                if (value instanceof Serializable) {
                    saveNames.add(keys[i]);
                    saveValues.add(value);
                } else {
                    unbinds.add(keys[i]);
                }
            }
            ++i;
        }
        int n = saveNames.size();
        stream.writeObject(new Integer(n));
        int i2 = 0;
        while (i2 < n) {
            stream.writeObject((String)saveNames.get(i2));
            try {
                stream.writeObject(saveValues.get(i2));
                if (this.debug >= 2) {
                    this.log("  storing attribute '" + saveNames.get(i2) + "' with value '" + saveValues.get(i2) + "'");
                }
            }
            catch (NotSerializableException e) {
                this.log("Session is not serializable for attribute name: " + saveNames.get(i2) + " and session id: " + this.id, e);
                stream.writeObject(NOT_SERIALIZED);
                if (this.debug >= 2) {
                    this.log("  storing attribute '" + saveNames.get(i2) + "' with value NOT_SERIALIZED");
                }
                unbinds.add((String)saveNames.get(i2));
            }
            ++i2;
        }
        Iterator names = ((AbstractList)unbinds).iterator();
        while (names.hasNext()) {
            this.removeAttribute((String)names.next());
        }
    }

    public void fireSessionEvent(String type, Object data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] keys() {
        String[] results = new String[]{};
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.keySet().toArray(results);
        }
    }

    protected void log(String message) {
        this.servletContext.log(message);
    }

    protected void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }
}

