/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.locking;

import ojb.odmg.TransactionImpl;
import ojb.odmg.locking.AbstractLockStrategy;
import ojb.odmg.locking.LockEntry;

public class ReadCommittedStrategy
extends AbstractLockStrategy {
    public boolean readLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        if (writer == null) {
            this.addReader(tx, obj);
            if (this.getWriter(obj) == null) {
                return true;
            }
            this.removeReader(tx, obj);
            return this.readLock(tx, obj);
        }
        return writer.isOwnedBy(tx);
    }

    public boolean writeLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        if (writer == null) {
            if (this.setWriter(tx, obj)) {
                return true;
            }
            return this.writeLock(tx, obj);
        }
        return writer.isOwnedBy(tx);
    }

    public boolean upgradeLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        if (writer == null) {
            if (this.setWriter(tx, obj)) {
                return true;
            }
            return this.upgradeLock(tx, obj);
        }
        return writer.isOwnedBy(tx);
    }

    public boolean releaseLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        if (writer != null && writer.isOwnedBy(tx)) {
            this.removeWriter(writer);
            return true;
        }
        if (this.hasReadLock(tx, obj)) {
            this.removeReader(tx, obj);
            return true;
        }
        return false;
    }

    public boolean checkRead(TransactionImpl tx, Object obj) {
        if (this.hasReadLock(tx, obj)) {
            return true;
        }
        LockEntry writer = this.getWriter(obj);
        return writer.isOwnedBy(tx);
    }

    public boolean checkWrite(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        if (writer == null) {
            return false;
        }
        return writer.isOwnedBy(tx);
    }
}

