/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltUriResolver
implements URIResolver {
    private static final Logger LOG = LoggerFactory.getLogger(XsltUriResolver.class);
    private final CamelContext context;
    private final String location;
    private final String baseScheme;

    public XsltUriResolver(CamelContext context, String location) {
        this.context = context;
        this.location = location;
        this.baseScheme = ResourceHelper.hasScheme(location) ? ResourceHelper.getScheme(location) : "classpath:";
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        if (ObjectHelper.isEmpty(href)) {
            href = this.location;
        }
        if (ObjectHelper.isEmpty(href)) {
            throw new TransformerException("include href is empty");
        }
        LOG.trace("Resolving URI with href: {} and base: {}", (Object)href, (Object)base);
        String scheme = ResourceHelper.getScheme(href);
        if (scheme != null) {
            InputStream is;
            if ("file:".equals(scheme)) {
                href = FileUtil.compactPath(href);
            } else if ("classpath:".equals(scheme)) {
                href = FileUtil.compactPath(href, '/');
            }
            LOG.debug("Resolving URI from {}: {}", (Object)scheme, (Object)href);
            try {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.context, href);
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
            return new StreamSource(is);
        }
        if (href.equals(this.location)) {
            String path = this.baseScheme + href;
            return this.resolve(path, base);
        }
        String path = FileUtil.onlyPath(this.location);
        if (ObjectHelper.isEmpty(path)) {
            path = this.baseScheme + href;
            return this.resolve(path, base);
        }
        path = ResourceHelper.hasScheme(path) ? path + "/" + href : this.baseScheme + path + "/" + href;
        return this.resolve(path, base);
    }
}

