/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.framework.ServiceStateMBean;

public class ServiceEventData {
    private long serviceId;
    private String[] serviceInterfaces;
    private long bundleId;
    private String bundleLocation;
    private String bundleSymbolicName;
    private int eventType;

    private ServiceEventData() {
    }

    public ServiceEventData(ServiceEvent serviceEvent) {
        ServiceReference serviceReference = serviceEvent.getServiceReference();
        this.serviceId = (Long)serviceReference.getProperty("service.id");
        this.serviceInterfaces = (String[])serviceReference.getProperty("objectClass");
        this.eventType = serviceEvent.getType();
        Bundle bundle = serviceReference.getBundle();
        if (bundle != null) {
            this.bundleId = bundle.getBundleId();
            this.bundleLocation = bundle.getLocation();
            this.bundleSymbolicName = bundle.getSymbolicName();
        }
    }

    public CompositeData toCompositeData() {
        CompositeDataSupport result = null;
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.serviceId);
        items.put("objectClass", this.serviceInterfaces);
        items.put("BundleIdentifier", this.bundleId);
        items.put("BundleLocation", this.bundleLocation);
        items.put("BundleSymbolicName", this.bundleSymbolicName);
        items.put("ServiceEvent", this.eventType);
        try {
            result = new CompositeDataSupport(ServiceStateMBean.SERVICE_EVENT_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Failed to create CompositeData for ServiceEvent for Service [" + this.serviceId + "]", e);
        }
        return result;
    }

    public static ServiceEventData from(CompositeData compositeData) throws IllegalArgumentException {
        ServiceEventData serviceEventData = new ServiceEventData();
        if (compositeData == null) {
            throw new IllegalArgumentException("Argument compositeData cannot be null");
        }
        if (!compositeData.getCompositeType().equals(ServiceStateMBean.SERVICE_EVENT_TYPE)) {
            throw new IllegalArgumentException("Invalid CompositeType [" + compositeData.getCompositeType() + "]");
        }
        serviceEventData.serviceId = (Long)compositeData.get("Identifier");
        serviceEventData.serviceInterfaces = (String[])compositeData.get("objectClass");
        serviceEventData.bundleId = (Long)compositeData.get("BundleIdentifier");
        serviceEventData.bundleLocation = (String)compositeData.get("BundleLocation");
        serviceEventData.bundleSymbolicName = (String)compositeData.get("BundleSymbolicName");
        serviceEventData.eventType = (Integer)compositeData.get("ServiceEvent");
        return serviceEventData;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public String[] getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getBundleLocation() {
        return this.bundleLocation;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public int getEventType() {
        return this.eventType;
    }
}

