/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.rest;

import java.util.List;
import javax.jws.WebMethod;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;

public abstract class AbstractConfigurationServiceEndpoint<T> {
    protected ImportExportConfigurationService<T> configurationService;
    protected ConfigSharingService configSharingService;

    @WebMethod(exclude=true)
    public void setConfigSharingService(ConfigSharingService configSharingService) {
        this.configSharingService = configSharingService;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<T> getConfigurations() {
        return this.configurationService.getAll();
    }

    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public abstract T saveConfiguration(T var1);

    @GET
    @Path(value="/{configId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public T getConfiguration(@PathParam(value="configId") String configId) {
        return (T)this.configurationService.load(configId);
    }

    @DELETE
    @Path(value="/{configId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public abstract void deleteConfiguration(@PathParam(value="configId") String var1);
}

