/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ResourceWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.util.ServicePropertiesUtils;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultResourceMapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTracker
extends AbstractTracker<Object, ResourceWebElement> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceTracker.class);

    private ResourceTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        super(extenderContext, bundleContext);
    }

    public static ServiceTracker<Object, ResourceWebElement> createTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        return new ResourceTracker(extenderContext, bundleContext).create("(osgi.http.whiteboard.resource.prefix=*)");
    }

    @Override
    ResourceWebElement createWebElement(ServiceReference<Object> serviceReference, Object published) {
        String[] resourcePattern = ServicePropertiesUtils.getArrayOfStringProperty(serviceReference, "osgi.http.whiteboard.resource.pattern");
        String prefix = ServicePropertiesUtils.getStringProperty(serviceReference, "osgi.http.whiteboard.resource.prefix");
        if (resourcePattern != null && prefix != null) {
            String httpContextId = ServicePropertiesUtils.extractHttpContextId(serviceReference);
            DefaultResourceMapping mapping = new DefaultResourceMapping();
            mapping.setHttpContextId(httpContextId);
            mapping.setAlias(resourcePattern[0]);
            mapping.setPath(prefix);
            return new ResourceWebElement(serviceReference, mapping);
        }
        return null;
    }
}

