/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.unomi.persistence.elasticsearch.ESCustomObjectMapper;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ElasticsearchClientFactory {
    public static ElasticsearchClient createClient(List<HttpHost> hosts, Integer socketTimeout, SSLContext sslContext, String username, String password) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]));
        if (socketTimeout != null) {
            builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setSocketTimeout(socketTimeout.intValue()));
        }
        if (sslContext != null) {
            builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLContext(sslContext));
        }
        if (username != null && password != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticsearchClientFactory.lambda$createClient$2(sslContext, (CredentialsProvider)credentialsProvider, arg_0));
        }
        RestClient restClient = builder.build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper(ESCustomObjectMapper.getObjectMapper()));
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    public static ClientBuilder builder() {
        return new ClientBuilder();
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createClient$2(SSLContext sslContext, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        if (sslContext != null) {
            return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setSSLContext(sslContext);
        }
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }

    public static class ClientBuilder {
        private List<HttpHost> hosts;
        private Integer socketTimeout;
        private SSLContext sslContext;
        private String username;
        private String password;

        public ClientBuilder hosts(List<HttpHost> hosts) {
            this.hosts = hosts;
            return this;
        }

        public ClientBuilder socketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ClientBuilder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public ClientBuilder usernameAndPassword(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public ElasticsearchClient build() {
            return ElasticsearchClientFactory.createClient(this.hosts, this.socketTimeout, this.sslContext, this.username, this.password);
        }
    }
}

