/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidator;

class PrecisionDecimalDV
extends TypeValidator {
    PrecisionDecimalDV() {
    }

    @Override
    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new XPrecisionDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "precisionDecimal"});
        }
    }

    @Override
    public int compare(Object object, Object object2) {
        return ((XPrecisionDecimal)object).compareTo((XPrecisionDecimal)object2);
    }

    @Override
    public int getTotalDigits(Object object) {
        return ((XPrecisionDecimal)object).totalDigits;
    }

    @Override
    public boolean isIdentical(Object object, Object object2) {
        if (!(object2 instanceof XPrecisionDecimal) || !(object instanceof XPrecisionDecimal)) {
            return false;
        }
        return ((XPrecisionDecimal)object).isIdentical((XPrecisionDecimal)object2);
    }

    @Override
    public int getPrecision(Object object) {
        return ((XPrecisionDecimal)object).precision;
    }

    @Override
    public boolean hasPrecision(Object object) {
        XPrecisionDecimal xPrecisionDecimal = (XPrecisionDecimal)object;
        return xPrecisionDecimal.sign != 0 && xPrecisionDecimal.ivalue != "INF" && xPrecisionDecimal.ivalue != "-INF";
    }

    private static class XPrecisionDecimal {
        int sign = 1;
        int totalDigits = 0;
        int intDigits = 0;
        int fracDigits = 0;
        int precision = 0;
        String ivalue = "";
        String fvalue = "";
        int pvalue = 0;
        private String canonical;

        XPrecisionDecimal(String string) throws NumberFormatException {
            if (string.equals("NaN")) {
                this.ivalue = "NaN";
                this.sign = 0;
                return;
            }
            if (string.equals("+INF") || string.equals("INF")) {
                this.ivalue = "INF";
                return;
            }
            if (string.equals("-INF")) {
                this.ivalue = "-INF";
                return;
            }
            this.initD(string);
        }

        void initD(String string) throws NumberFormatException {
            int n;
            int n2;
            int n3 = string.length();
            if (n3 == 0) {
                throw new NumberFormatException();
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (string.charAt(0) == '+') {
                n4 = 1;
            } else if (string.charAt(0) == '-') {
                n4 = 1;
                this.sign = -1;
            }
            for (n2 = n4; n2 < n3 && string.charAt(n2) == '0'; ++n2) {
            }
            for (n5 = n2; n5 < n3 && TypeValidator.isDigit(string.charAt(n5)); ++n5) {
            }
            if (n5 < n3) {
                if (string.charAt(n5) != '.' && string.charAt(n5) != 'E' && string.charAt(n5) != 'e') {
                    throw new NumberFormatException();
                }
                if (string.charAt(n5) == '.') {
                    for (n7 = n6 = n5 + 1; n7 < n3 && TypeValidator.isDigit(string.charAt(n7)); ++n7) {
                    }
                    this.fracDigits = n7 - n6;
                    if (this.fracDigits > 0) {
                        this.fvalue = string.substring(n6, n7);
                    }
                    if (n7 < n3) {
                        if (string.charAt(n7) != 'E' && string.charAt(n7) != 'e') {
                            throw new NumberFormatException();
                        }
                        if (string.charAt(n7 + 1) == '+') {
                            ++n7;
                        }
                        this.pvalue = Integer.parseInt(string.substring(n7 + 1, n3));
                    }
                } else {
                    n = string.charAt(n5 + 1) == '+' ? 1 : 0;
                    this.pvalue = Integer.parseInt(string.substring(n5 + 1 + n, n3));
                }
            }
            if (n4 == n5 && n6 == n7) {
                throw new NumberFormatException();
            }
            this.intDigits = n5 - n2;
            if (this.intDigits > 0) {
                this.ivalue = string.substring(n2, n5);
                this.totalDigits = this.intDigits + this.fracDigits;
            } else {
                this.totalDigits = this.fracDigits;
                n = 0;
                while (n < this.fracDigits && this.fvalue.charAt(n) == '0') {
                    ++n;
                    --this.totalDigits;
                }
                if (this.totalDigits == 0) {
                    this.totalDigits = 1;
                }
            }
            this.precision = this.fracDigits - this.pvalue;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof XPrecisionDecimal)) {
                return false;
            }
            XPrecisionDecimal xPrecisionDecimal = (XPrecisionDecimal)object;
            if (this.sign == 0 && xPrecisionDecimal.sign == 0) {
                return true;
            }
            return this.compareTo(xPrecisionDecimal) == 0;
        }

        private int compareFractionalPart(XPrecisionDecimal xPrecisionDecimal) {
            if (this.fvalue.equals(xPrecisionDecimal.fvalue)) {
                return 0;
            }
            StringBuffer stringBuffer = new StringBuffer(this.fvalue);
            StringBuffer stringBuffer2 = new StringBuffer(xPrecisionDecimal.fvalue);
            this.truncateTrailingZeros(stringBuffer, stringBuffer2);
            return stringBuffer.toString().compareTo(stringBuffer2.toString());
        }

        private void truncateTrailingZeros(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            int n;
            for (n = stringBuffer.length() - 1; n >= 0 && stringBuffer.charAt(n) == '0'; --n) {
                stringBuffer.deleteCharAt(n);
            }
            for (n = stringBuffer2.length() - 1; n >= 0 && stringBuffer2.charAt(n) == '0'; --n) {
                stringBuffer2.deleteCharAt(n);
            }
        }

        public int compareTo(XPrecisionDecimal xPrecisionDecimal) {
            if (this.sign == 0 || xPrecisionDecimal.sign == 0) {
                return 2;
            }
            if (this.ivalue.equals("INF") || xPrecisionDecimal.ivalue.equals("INF")) {
                if (this.ivalue.equals(xPrecisionDecimal.ivalue)) {
                    return 0;
                }
                if (this.ivalue.equals("INF")) {
                    return 1;
                }
                return -1;
            }
            if (this.ivalue.equals("-INF") || xPrecisionDecimal.ivalue.equals("-INF")) {
                if (this.ivalue.equals(xPrecisionDecimal.ivalue)) {
                    return 0;
                }
                if (this.ivalue.equals("-INF")) {
                    return -1;
                }
                return 1;
            }
            if (this.sign != xPrecisionDecimal.sign) {
                if (this.isZero() && xPrecisionDecimal.isZero()) {
                    return 0;
                }
                return this.sign > xPrecisionDecimal.sign ? 1 : -1;
            }
            return this.sign * this.compare(xPrecisionDecimal);
        }

        private boolean isZero() {
            return this.totalDigits == 1 && this.intDigits == 0 && (this.fracDigits == 0 || this.fvalue.charAt(this.fracDigits - 1) == '0');
        }

        private int compare(XPrecisionDecimal xPrecisionDecimal) {
            if (this.pvalue == xPrecisionDecimal.pvalue) {
                return this.intComp(xPrecisionDecimal);
            }
            if (this.pvalue > xPrecisionDecimal.pvalue) {
                int n = this.pvalue - xPrecisionDecimal.pvalue;
                StringBuffer stringBuffer = new StringBuffer(this.ivalue);
                StringBuffer stringBuffer2 = new StringBuffer(this.fvalue);
                for (int i = 0; i < n; ++i) {
                    if (i < this.fracDigits) {
                        stringBuffer.append(this.fvalue.charAt(i));
                        stringBuffer2.deleteCharAt(0);
                        continue;
                    }
                    stringBuffer.append('0');
                }
                while (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '0') {
                    stringBuffer.deleteCharAt(0);
                }
                return this.compareDecimal(stringBuffer.toString(), stringBuffer2.toString(), xPrecisionDecimal.ivalue, xPrecisionDecimal.fvalue);
            }
            int n = xPrecisionDecimal.pvalue - this.pvalue;
            StringBuffer stringBuffer = new StringBuffer(xPrecisionDecimal.ivalue);
            StringBuffer stringBuffer3 = new StringBuffer(xPrecisionDecimal.fvalue);
            for (int i = 0; i < n; ++i) {
                if (i < xPrecisionDecimal.fracDigits) {
                    stringBuffer.append(xPrecisionDecimal.fvalue.charAt(i));
                    stringBuffer3.deleteCharAt(0);
                    continue;
                }
                stringBuffer.append('0');
            }
            while (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '0') {
                stringBuffer.deleteCharAt(0);
            }
            return this.compareDecimal(this.ivalue, this.fvalue, stringBuffer.toString(), stringBuffer3.toString());
        }

        private int intComp(XPrecisionDecimal xPrecisionDecimal) {
            if (this.intDigits != xPrecisionDecimal.intDigits) {
                return this.intDigits > xPrecisionDecimal.intDigits ? 1 : -1;
            }
            return this.compareDecimal(this.ivalue, this.fvalue, xPrecisionDecimal.ivalue, xPrecisionDecimal.fvalue);
        }

        private int compareDecimal(String string, String string2, String string3, String string4) {
            if (string.length() != string3.length()) {
                return string.length() > string3.length() ? 1 : -1;
            }
            int n = string.compareTo(string3);
            if (n != 0) {
                return n > 0 ? 1 : -1;
            }
            if (string2.equals(string4)) {
                return 0;
            }
            StringBuffer stringBuffer = new StringBuffer(string2);
            StringBuffer stringBuffer2 = new StringBuffer(string4);
            this.truncateTrailingZeros(stringBuffer, stringBuffer2);
            n = stringBuffer.toString().compareTo(stringBuffer2.toString());
            return n == 0 ? 0 : (n > 0 ? 1 : -1);
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.makeCanonical();
            }
            return this.canonical;
        }

        private void makeCanonical() {
            if (this.ivalue.equals("INF") || this.ivalue.equals("-INF") || this.ivalue.equals("NaN")) {
                this.canonical = this.ivalue;
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.intDigits > 0) {
                    stringBuffer.append(this.ivalue);
                }
                if (this.fracDigits > 0) {
                    stringBuffer.append('.');
                    stringBuffer.append(this.fvalue);
                }
                if (this.pvalue != 0) {
                    stringBuffer.append('E');
                    stringBuffer.append(this.pvalue);
                }
                this.canonical = stringBuffer.toString();
            }
        }

        public boolean isIdentical(XPrecisionDecimal xPrecisionDecimal) {
            if (this.ivalue.equals(xPrecisionDecimal.ivalue) && (this.ivalue.equals("INF") || this.ivalue.equals("-INF") || this.ivalue.equals("NaN"))) {
                return true;
            }
            return this.sign == xPrecisionDecimal.sign && this.intDigits == xPrecisionDecimal.intDigits && this.fracDigits == xPrecisionDecimal.fracDigits && this.pvalue == xPrecisionDecimal.pvalue && this.ivalue.equals(xPrecisionDecimal.ivalue) && this.fvalue.equals(xPrecisionDecimal.fvalue);
        }
    }
}

