/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.impl.locale.LocaleObjectCache;

public final class BaseLocale {
    private String _language = "";
    private String _script = "";
    private String _region = "";
    private String _variant = "";
    private transient String _id = "";
    private transient String _java6string = "";
    private transient BaseLocale _parent;
    private static final char SEPCHAR = '_';
    private static final LocaleObjectCache BASELOCALECACHE = new LocaleObjectCache();
    public static final BaseLocale ROOT = new BaseLocale("", "", "", "");

    private BaseLocale(String language, String script, String region, String variant) {
        if (language != null) {
            this._language = language;
        }
        if (script != null) {
            this._script = script;
        }
        if (region != null) {
            this._region = region;
        }
        if (variant != null) {
            this._variant = variant;
        }
    }

    public static BaseLocale getInstance(String language, String script, String region, String variant) {
        BaseLocaleKey key = new BaseLocaleKey(language, script, region, variant);
        BaseLocale baseLocale = (BaseLocale)BASELOCALECACHE.get(key);
        if (baseLocale == null) {
            baseLocale = new BaseLocale(language, script, region, variant).canonicalize();
            BASELOCALECACHE.put(baseLocale.createKey(), baseLocale);
        }
        return baseLocale;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof BaseLocale && this._id == ((BaseLocale)obj)._id;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public String getJava6String() {
        return this._java6string;
    }

    public String getLanguage() {
        return this._language;
    }

    public String getScript() {
        return this._script;
    }

    public String getRegion() {
        return this._region;
    }

    public String getVariant() {
        return this._variant;
    }

    public BaseLocale getParent() {
        return this._parent;
    }

    public String getID() {
        return this._id;
    }

    public String toString() {
        return this._id;
    }

    private BaseLocale canonicalize() {
        int lastSep;
        StringBuffer buf;
        StringBuffer id = new StringBuffer();
        int languageLen = this._language.length();
        int scriptLen = this._script.length();
        int regionLen = this._region.length();
        int variantLen = this._variant.length();
        if (languageLen > 0) {
            this._language = AsciiUtil.toLowerString(this._language).intern();
            id.append(this._language);
        }
        if (scriptLen > 0) {
            buf = new StringBuffer();
            buf.append(AsciiUtil.toUpper(this._script.charAt(0)));
            int i = 1;
            while (i < this._script.length()) {
                buf.append(AsciiUtil.toLower(this._script.charAt(i)));
                ++i;
            }
            this._script = buf.toString().intern();
            id.append('_');
            id.append(this._script);
        }
        if (regionLen > 0) {
            this._region = AsciiUtil.toUpperString(this._region).intern();
            id.append('_');
            id.append(this._region);
        }
        if (variantLen > 0) {
            this._variant = this._variant.intern();
            if (regionLen == 0) {
                id.append('_');
            }
            id.append('_');
            id.append(this._variant);
        }
        this._id = id.toString().intern();
        if (languageLen == 0 && regionLen == 0 && variantLen > 0) {
            this._java6string = "";
        } else if (scriptLen > 0 || regionLen == 0 && variantLen > 0) {
            buf = new StringBuffer(this._language);
            if (regionLen > 0) {
                buf.append('_');
                buf.append(this._region);
            } else if (variantLen > 0) {
                buf.append('_');
            }
            if (variantLen > 0) {
                buf.append('_');
                buf.append(this._variant);
            }
            this._java6string = buf.toString().intern();
        } else {
            this._java6string = this._id;
        }
        this._parent = variantLen > 0 ? ((lastSep = this._variant.lastIndexOf(95)) == -1 ? BaseLocale.getInstance(this._language, this._script, this._region, "") : BaseLocale.getInstance(this._language, this._script, this._region, this._variant.substring(0, lastSep))) : (regionLen > 0 ? BaseLocale.getInstance(this._language, this._script, "", "") : (scriptLen > 0 ? BaseLocale.getInstance(this._language, "", "", "") : (languageLen > 0 ? ROOT : null)));
        return this;
    }

    private BaseLocaleKey createKey() {
        return new BaseLocaleKey(this._language, this._script, this._region, this._variant);
    }

    public static class BaseLocaleKey
    implements Comparable {
        private String _lang = "";
        private String _scrt = "";
        private String _regn = "";
        private String _vart = "";
        private int _hash;

        public BaseLocaleKey(String language, String script, String region, String variant) {
            if (language != null) {
                this._lang = language;
            }
            if (script != null) {
                this._scrt = script;
            }
            if (region != null) {
                this._regn = region;
            }
            if (variant != null) {
                this._vart = variant;
            }
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof BaseLocaleKey && AsciiUtil.caseIgnoreMatch(((BaseLocaleKey)obj)._lang, this._lang) && AsciiUtil.caseIgnoreMatch(((BaseLocaleKey)obj)._scrt, this._scrt) && AsciiUtil.caseIgnoreMatch(((BaseLocaleKey)obj)._regn, this._regn) && ((BaseLocaleKey)obj)._vart.equals(this._vart);
        }

        public int compareTo(BaseLocaleKey other) {
            int res = AsciiUtil.caseIgnoreCompare(this._lang, other._lang);
            if (res == 0 && (res = AsciiUtil.caseIgnoreCompare(this._scrt, other._scrt)) == 0 && (res = AsciiUtil.caseIgnoreCompare(this._regn, other._regn)) == 0) {
                res = AsciiUtil.caseIgnoreCompare(this._vart, other._vart);
            }
            return res;
        }

        public int compareTo(Object obj) {
            return this.compareTo((BaseLocaleKey)obj);
        }

        public int hashCode() {
            int h = this._hash;
            if (h == 0) {
                int i = 0;
                while (i < this._lang.length()) {
                    h = 31 * h + AsciiUtil.toLower(this._lang.charAt(i));
                    ++i;
                }
                int i2 = 0;
                while (i2 < this._scrt.length()) {
                    h = 31 * h + AsciiUtil.toLower(this._scrt.charAt(i2));
                    ++i2;
                }
                int i3 = 0;
                while (i3 < this._regn.length()) {
                    h = 31 * h + AsciiUtil.toLower(this._regn.charAt(i3));
                    ++i3;
                }
                int i4 = 0;
                while (i4 < this._vart.length()) {
                    h = 31 * h + AsciiUtil.toLower(this._vart.charAt(i4));
                    ++i4;
                }
                this._hash = h;
            }
            return h;
        }
    }
}

