/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnData;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.utils.TypePromoter;

public abstract class Function {
    protected QName _name;
    protected int _min_arity;
    protected int _max_arity;
    protected FunctionLibrary _fl;

    public Function(QName name, int arity) {
        this._name = name;
        if (arity < 0) {
            throw new RuntimeException("We want to avoid this!");
        }
        this._min_arity = arity;
        this._max_arity = arity;
        this._fl = null;
    }

    public Function(QName name, int min_arity, int max_arity) {
        this._name = name;
        if (min_arity < 0 || max_arity < 0 || max_arity < min_arity) {
            throw new RuntimeException("We want to avoid this!");
        }
        this._min_arity = min_arity;
        this._max_arity = max_arity;
        this._fl = null;
    }

    public QName name() {
        return this._name;
    }

    public int min_arity() {
        return this._min_arity;
    }

    public int max_arity() {
        return this._max_arity;
    }

    public boolean matches_arity(int actual_arity) {
        if (actual_arity < this.min_arity()) {
            return false;
        }
        return actual_arity <= this.max_arity();
    }

    public String signature() {
        return Function.signature(this);
    }

    public static String signature(Function f) {
        return Function.signature(f.name(), f.is_vararg() ? -1 : f.min_arity());
    }

    public static String signature(QName name, int arity) {
        String n = name.expanded_name();
        if (n == null) {
            return null;
        }
        n = String.valueOf(n) + "_";
        n = arity < 0 ? String.valueOf(n) + "x" : String.valueOf(n) + arity;
        return n;
    }

    public abstract ResultSequence evaluate(Collection var1) throws DynamicError;

    public static ResultSequence convert_argument(ResultSequence arg, SeqType expected) throws DynamicError {
        ResultSequence result = arg;
        AnyType expected_type = expected.type();
        if (expected_type instanceof AnyAtomicType) {
            AnyAtomicType expected_aat = (AnyAtomicType)expected_type;
            ResultSequence rs = FnData.atomize(arg);
            result = ResultSequenceFactory.create_new();
            ListIterator i = rs.iterator();
            while (i.hasNext()) {
                AnyType item = (AnyType)i.next();
                if (item instanceof XSUntypedAtomic) {
                    ResultSequence converted = null;
                    if (expected_aat instanceof XSString) {
                        XSString strType = new XSString(item.string_value());
                        converted = ResultSequenceFactory.create_new(strType);
                    } else {
                        converted = ResultSequenceFactory.create_new(item);
                    }
                    result.concat(converted);
                    continue;
                }
                if (item instanceof XSAnyURI && expected_aat instanceof XSString) {
                    result.add(new XSString(item.string_value()));
                    continue;
                }
                if (item instanceof NumericType) {
                    if (expected_aat instanceof XSDouble) {
                        XSDouble doubleType = new XSDouble(item.string_value());
                        result.add(doubleType);
                        continue;
                    }
                    result.add(item);
                    continue;
                }
                result.add(item);
            }
        }
        return expected.match(result);
    }

    public static Collection convert_arguments(Collection args, Collection expected) throws DynamicError {
        ArrayList<ResultSequence> result = new ArrayList<ResultSequence>();
        assert (args.size() <= expected.size());
        Iterator argi = args.iterator();
        Iterator expi = expected.iterator();
        while (argi.hasNext()) {
            result.add(Function.convert_argument((ResultSequence)argi.next(), (SeqType)expi.next()));
        }
        return result;
    }

    protected static ResultSequence getResultSetForArityZero(DynamicContext d_context) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        AnyType contextItem = d_context.context_item();
        if (contextItem == null) {
            throw DynamicError.contextUndefined();
        }
        rs.add(new XSString(contextItem.string_value()));
        return rs;
    }

    public void set_function_library(FunctionLibrary fl) {
        this._fl = fl;
    }

    protected StaticContext static_context() {
        if (this._fl == null) {
            return null;
        }
        return this._fl.static_context();
    }

    protected DynamicContext dynamic_context() {
        if (this._fl == null) {
            return null;
        }
        return this._fl.dynamic_context();
    }

    public boolean is_vararg() {
        return this._min_arity != this._max_arity;
    }

    protected static AnyAtomicType convertInputItem(TypePromoter tp, AnyType seqItem) throws DynamicError {
        AnyAtomicType convertedItem = null;
        if (seqItem instanceof ElementType || seqItem instanceof AttrType) {
            seqItem = FnData.atomize(seqItem);
        }
        if (seqItem instanceof NumericType) {
            convertedItem = tp.promote(seqItem);
        } else if (seqItem instanceof XSUntypedAtomic) {
            convertedItem = new XSDouble(seqItem.string_value());
        } else if (seqItem instanceof XSAnyURI) {
            convertedItem = new XSString(seqItem.string_value());
        } else if (seqItem instanceof AnyAtomicType) {
            convertedItem = (AnyAtomicType)seqItem;
        }
        return convertedItem;
    }
}

