/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.xml;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.DefaultTestSuite;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.TestSuiteReport;
import org.apache.batik.test.xml.XMLTestSuiteRunner;
import org.w3c.dom.Document;

public class XMLTestSuiteRunnerValidator
extends DefaultTestSuite {
    public static final String ERROR_TEST_NOT_RUN = "error.test.not.run";
    public static final String ERROR_EXTRA_TEST_RUN = "error.extra.test.run";
    public static final String ENTRY_KEY_CONFIGURATION = "entry.key.configuration";
    public static final String ENTRY_KEY_EXPECTED_RESULT = "entry.key.expected.result";
    public static final String ENTRY_KEY_ACTUAL_RESULT = "entry.key.actual.result";
    public static final String ENTRY_KEY_TEST_IDS_NOT_RUN = "entry.key.test.ids.not.run";
    public static final String ENTRY_KEY_TEST_ID_NOT_EXPECTED = "entry.key.test.id.not.expected";
    static final String dummyTestRun = "test-resources/org/apache/batik/test/xml/dummyTestRun.xml";

    public XMLTestSuiteRunnerValidator() {
        Object[][] config;
        for (Object[] aConfig : config = new Object[][]{{"", new String[]{"all", "all.A", "all.A.A1", "all.A.A2", "all.A.duplicatedId", "all.A.duplicatedId.1", "all.A.duplicatedId.2", "all.A.AG", "all.A.AG.AG1", "all.A.AG.AG2", "all.B", "all.B.B1", "all.B.B2", "all.B.B3", "all.B.duplicatedId"}}, {"all.B.B3", new String[]{"all", "all.B", "all.B.B3"}}, {"all.A", new String[]{"all", "all.A", "all.A.A1", "all.A.A2", "all.A.duplicatedId", "all.A.duplicatedId.1", "all.A.duplicatedId.2", "all.A.AG", "all.A.AG.AG1", "all.A.AG.AG2"}}, {"all.B all.A.A1 all.A.A2", new String[]{"all", "all.B", "all.B.B1", "all.B.B2", "all.B.B3", "all.B.duplicatedId", "all.A", "all.A.A1", "all.A.A2"}}, {"duplicatedId", new String[]{"all", "all.A", "all.A.duplicatedId", "all.A.duplicatedId.1", "all.A.duplicatedId.2", "all.B", "all.B.duplicatedId"}}, {"AG", new String[]{"all", "all.A", "all.A.AG", "all.A.AG.AG1", "all.A.AG.AG2"}}}) {
            this.addTest(new XMLTestSuiteRunnerTest(aConfig));
        }
    }

    static class XMLTestSuiteRunnerTest
    extends AbstractTest {
        protected String[] args;
        protected HashSet ids;
        protected String[] idsArray;

        public XMLTestSuiteRunnerTest(Object[] config) {
            int i;
            StringTokenizer st = new StringTokenizer((String)config[0], " ");
            int nArgs = st.countTokens();
            this.args = new String[nArgs];
            for (i = 0; i < nArgs; ++i) {
                this.args[i] = st.nextToken();
            }
            this.ids = new HashSet();
            for (i = 0; i < (config[1] != null ? ((Object[])config[1]).length : 0); ++i) {
                this.ids.add(((Object[])config[1])[i]);
            }
            this.idsArray = (String[])config[1];
        }

        @Override
        public TestReport runImpl() throws Exception {
            Set idSet;
            XMLTestSuiteRunner runner = new XMLTestSuiteRunner();
            Document doc = this.loadDummyTestRun();
            TestReport runReport = runner.run(doc, this.args);
            String idNotExpected = this.checkTestReport(runReport, idSet = (Set)this.ids.clone());
            if (idNotExpected == null) {
                if (idSet.isEmpty()) {
                    return this.reportSuccess();
                }
                DefaultTestReport report = new DefaultTestReport(this);
                report.setErrorCode(XMLTestSuiteRunnerValidator.ERROR_TEST_NOT_RUN);
                report.addDescriptionEntry(XMLTestSuiteRunnerValidator.ENTRY_KEY_CONFIGURATION, this.arrayToString(this.args));
                report.addDescriptionEntry(XMLTestSuiteRunnerValidator.ENTRY_KEY_EXPECTED_RESULT, this.arrayToString(this.idsArray));
                report.addDescriptionEntry(XMLTestSuiteRunnerValidator.ENTRY_KEY_ACTUAL_RESULT, this.reportIdsToString(runReport));
                report.addDescriptionEntry(XMLTestSuiteRunnerValidator.ENTRY_KEY_TEST_IDS_NOT_RUN, this.arrayToString(idSet.toArray()));
                report.setPassed(false);
                return report;
            }
            DefaultTestReport report = new DefaultTestReport(this);
            report.setErrorCode(XMLTestSuiteRunnerValidator.ERROR_EXTRA_TEST_RUN);
            report.addDescriptionEntry(XMLTestSuiteRunnerValidator.ENTRY_KEY_CONFIGURATION, this.arrayToString(this.args));
            report.addDescriptionEntry(XMLTestSuiteRunnerValidator.ENTRY_KEY_EXPECTED_RESULT, this.arrayToString(this.idsArray));
            report.addDescriptionEntry(XMLTestSuiteRunnerValidator.ENTRY_KEY_ACTUAL_RESULT, this.reportIdsToString(runReport));
            report.addDescriptionEntry(XMLTestSuiteRunnerValidator.ENTRY_KEY_TEST_ID_NOT_EXPECTED, idNotExpected);
            report.setPassed(false);
            return report;
        }

        protected String arrayToString(Object[] array) {
            StringBuffer sb = new StringBuffer();
            if (array != null) {
                if (array.length > 0) {
                    sb.append(array[0]);
                }
                for (int i = 1; i < array.length; ++i) {
                    sb.append(", ");
                    sb.append(array[i].toString());
                }
            }
            return sb.toString();
        }

        protected String reportIdsToString(TestReport r) {
            StringBuffer sb = new StringBuffer();
            if (r != null) {
                TestReport[] c;
                sb.append(r.getTest().getQualifiedId());
                if (r instanceof TestSuiteReport && (c = ((TestSuiteReport)r).getChildrenReports()) != null) {
                    for (TestReport aC : c) {
                        this.appendReportIds(aC, sb);
                    }
                }
            } else {
                sb.append("null");
            }
            return sb.toString();
        }

        protected void appendReportIds(TestReport r, StringBuffer sb) {
            if (r != null) {
                TestReport[] c;
                sb.append(", ");
                sb.append(r.getTest().getQualifiedId());
                if (r instanceof TestSuiteReport && (c = ((TestSuiteReport)r).getChildrenReports()) != null) {
                    for (TestReport aC : c) {
                        this.appendReportIds(aC, sb);
                    }
                }
            }
        }

        protected Document loadDummyTestRun() throws Exception {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            URL url = new File(XMLTestSuiteRunnerValidator.dummyTestRun).toURI().toURL();
            return docBuilder.parse(url.toString());
        }

        protected String checkTestReport(TestReport report, Set idSet) {
            TestReport[] childReports;
            String id = report.getTest().getQualifiedId();
            if (!idSet.contains(id)) {
                return id;
            }
            idSet.remove(id);
            if (report instanceof TestSuiteReport && (childReports = ((TestSuiteReport)report).getChildrenReports()) != null) {
                for (TestReport childReport : childReports) {
                    String idNotExpected = this.checkTestReport(childReport, idSet);
                    if (idNotExpected == null) continue;
                    return idNotExpected;
                }
            }
            return null;
        }
    }
}

