/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.Glyph;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;

public final class SVGGVTGlyphVector
implements GVTGlyphVector {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    private GVTFont font;
    private Glyph[] glyphs;
    private FontRenderContext frc;
    private GeneralPath outline;
    private Rectangle2D logicalBounds;
    private Rectangle2D bounds2D;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private Point2D endPos;
    private TextPaintInfo cacheTPI;

    public SVGGVTGlyphVector(GVTFont gVTFont, Glyph[] glyphArray, FontRenderContext fontRenderContext) {
        this.font = gVTFont;
        this.glyphs = glyphArray;
        this.frc = fontRenderContext;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds = new Shape[glyphArray.length];
        this.glyphVisible = new boolean[glyphArray.length];
        for (int i = 0; i < glyphArray.length; ++i) {
            this.glyphVisible[i] = true;
        }
        this.endPos = glyphArray[glyphArray.length - 1].getPosition();
        this.endPos = new Point2D.Float((float)(this.endPos.getX() + (double)glyphArray[glyphArray.length - 1].getHorizAdvX()), (float)this.endPos.getY());
    }

    public GVTFont getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public int getGlyphCode(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        return this.glyphs[n].getGlyphCode();
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + n2 + ", is illegal. It must be > 0.");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (n + n2 > this.glyphs.length) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + n + "+" + n2 + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (nArray == null) {
            nArray = new int[n2];
        }
        for (int i = n; i < n + n2; ++i) {
            nArray[i - n] = this.glyphs[i].getGlyphCode();
        }
        return nArray;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return null;
    }

    public Shape getGlyphLogicalBounds(int n) {
        if (this.glyphLogicalBounds[n] == null && this.glyphVisible[n]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[n];
    }

    private void computeGlyphLogicalBounds() {
        Cloneable cloneable;
        Rectangle2D rectangle2D;
        Shape[] shapeArray;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.font != null) {
            shapeArray = this.font.getLineMetrics("By", this.frc);
            f = shapeArray.getAscent();
            f2 = shapeArray.getDescent();
            if (f2 < 0.0f) {
                f2 = -f2;
            }
        }
        if (f == 0.0f) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                if (!this.glyphVisible[i]) continue;
                GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(i);
                Rectangle2D rectangle2D2 = gVTGlyphMetrics.getBounds2D();
                f = (float)(-rectangle2D2.getMinY());
                f2 = (float)(rectangle2D2.getHeight() - (double)f);
                if (f > f3) {
                    f3 = f;
                }
                if (!(f2 > f4)) continue;
                f4 = f2;
            }
            f = f3;
            f2 = f4;
        }
        shapeArray = new Shape[this.getNumGlyphs()];
        boolean[] blArray = new boolean[this.getNumGlyphs()];
        double d = -1.0;
        double d2 = -1.0;
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            if (!this.glyphVisible[i]) {
                shapeArray[i] = null;
                continue;
            }
            AffineTransform affineTransform = this.getGlyphTransform(i);
            GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(i);
            rectangle2D = new Rectangle2D.Double(0.0, -f, gVTGlyphMetrics.getHorizontalAdvance(), f + f2);
            if (rectangle2D.isEmpty()) {
                if (i > 0) {
                    blArray[i] = blArray[i - 1];
                    continue;
                }
                blArray[i] = true;
                continue;
            }
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
            Point2D.Double double_2 = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMinY());
            Point2D.Double double_3 = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMaxY());
            Point2D point2D = this.getGlyphPosition(i);
            cloneable = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
            if (affineTransform != null) {
                ((AffineTransform)cloneable).concatenate(affineTransform);
            }
            shapeArray[i] = ((AffineTransform)cloneable).createTransformedShape(rectangle2D);
            Point2D.Double double_4 = new Point2D.Double();
            Point2D.Double double_5 = new Point2D.Double();
            Point2D.Double double_6 = new Point2D.Double();
            ((AffineTransform)cloneable).transform(double_, double_4);
            ((AffineTransform)cloneable).transform(double_2, double_5);
            ((AffineTransform)cloneable).transform(double_3, double_6);
            double d3 = ((Point2D)double_4).getX() - ((Point2D)double_5).getX();
            double d4 = ((Point2D)double_4).getX() - ((Point2D)double_6).getX();
            double d5 = ((Point2D)double_4).getY() - ((Point2D)double_5).getY();
            double d6 = ((Point2D)double_4).getY() - ((Point2D)double_6).getY();
            blArray[i] = Math.abs(d3) < 0.001 && Math.abs(d6) < 0.001 ? false : !(Math.abs(d4) < 0.001) || !(Math.abs(d5) < 0.001);
            Rectangle2D rectangle2D3 = shapeArray[i].getBounds2D();
            if (rectangle2D3.getWidth() > d) {
                d = rectangle2D3.getWidth();
            }
            if (!(rectangle2D3.getHeight() > d2)) continue;
            d2 = rectangle2D3.getHeight();
        }
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            if (shapeArray[i] == null) continue;
            generalPath.append(shapeArray[i], false);
        }
        Rectangle2D rectangle2D4 = generalPath.getBounds2D();
        if (rectangle2D4.getHeight() < d2 * 1.5) {
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                double d7;
                if (blArray[i] || shapeArray[i] == null) continue;
                rectangle2D = shapeArray[i].getBounds2D();
                double d8 = rectangle2D.getMinX();
                double d9 = rectangle2D.getWidth();
                if (i < this.getNumGlyphs() - 1 && shapeArray[i + 1] != null && ((RectangularShape)(cloneable = shapeArray[i + 1].getBounds2D())).getX() > d8 && (d7 = ((RectangularShape)cloneable).getX() - d8) < d9 * 1.15 && d7 > d9 * 0.85) {
                    double d10 = (d7 - d9) * 0.5;
                    d9 += d10;
                    ((Rectangle2D)cloneable).setRect(((RectangularShape)cloneable).getX() - d10, ((RectangularShape)cloneable).getY(), ((RectangularShape)cloneable).getWidth() + d10, ((RectangularShape)cloneable).getHeight());
                }
                shapeArray[i] = new Rectangle2D.Double(d8, rectangle2D4.getMinY(), d9, rectangle2D4.getHeight());
            }
        } else if (rectangle2D4.getWidth() < d * 1.5) {
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                double d11;
                if (blArray[i] || shapeArray[i] == null) continue;
                rectangle2D = shapeArray[i].getBounds2D();
                double d12 = rectangle2D.getMinY();
                double d13 = rectangle2D.getHeight();
                if (i < this.getNumGlyphs() - 1 && shapeArray[i + 1] != null && ((RectangularShape)(cloneable = shapeArray[i + 1].getBounds2D())).getY() > d12 && (d11 = ((RectangularShape)cloneable).getY() - d12) < d13 * 1.15 && d11 > d13 * 0.85) {
                    double d14 = (d11 - d13) * 0.5;
                    d13 += d14;
                    ((Rectangle2D)cloneable).setRect(((RectangularShape)cloneable).getX(), ((RectangularShape)cloneable).getY() - d14, ((RectangularShape)cloneable).getWidth(), ((RectangularShape)cloneable).getHeight() + d14);
                }
                shapeArray[i] = new Rectangle2D.Double(rectangle2D4.getMinX(), d12, rectangle2D4.getWidth(), d13);
            }
        }
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            this.glyphLogicalBounds[i] = shapeArray[i];
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("idx: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        if (n < this.glyphs.length - 1 && this.font != null) {
            float f = this.font.getHKern(this.glyphs[n].getGlyphCode(), this.glyphs[n + 1].getGlyphCode());
            float f2 = this.font.getVKern(this.glyphs[n].getGlyphCode(), this.glyphs[n + 1].getGlyphCode());
            return this.glyphs[n].getGlyphMetrics(f, f2);
        }
        return this.glyphs[n].getGlyphMetrics();
    }

    public Shape getGlyphOutline(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getOutline();
    }

    public Rectangle2D getGlyphCellBounds(int n) {
        return this.getGlyphLogicalBounds(n).getBounds2D();
    }

    public Point2D getGlyphPosition(int n) {
        if (n == this.glyphs.length) {
            return this.endPos;
        }
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getPosition();
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + n2 + ", is illegal. It must be > 0.");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (n + n2 > this.glyphs.length + 1) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + n + "+" + n2 + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (fArray == null) {
            fArray = new float[n2 * 2];
        }
        if (n + n2 == this.glyphs.length + 1) {
            fArray[--n2 * 2] = (float)this.endPos.getX();
            fArray[n2 * 2 + 1] = (float)this.endPos.getY();
        }
        for (int i = n; i < n + n2; ++i) {
            Point2D point2D = this.glyphs[i].getPosition();
            fArray[(i - n) * 2] = (float)point2D.getX();
            fArray[(i - n) * 2 + 1] = (float)point2D.getY();
        }
        return fArray;
    }

    public AffineTransform getGlyphTransform(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getTransform();
    }

    public Shape getGlyphVisualBounds(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getOutline();
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (this.bounds2D != null && TextPaintInfo.equivilent(textPaintInfo, this.cacheTPI)) {
            return this.bounds2D;
        }
        Rectangle2D rectangle2D = null;
        if (textPaintInfo.visible) {
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                Rectangle2D rectangle2D2;
                if (!this.glyphVisible[i] || (rectangle2D2 = this.glyphs[i].getBounds2D()) == null) continue;
                rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D2.createUnion(rectangle2D);
            }
        }
        this.bounds2D = rectangle2D;
        if (this.bounds2D == null) {
            this.bounds2D = new Rectangle2D.Float();
        }
        this.cacheTPI = new TextPaintInfo(textPaintInfo);
        return this.bounds2D;
    }

    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                Shape shape = this.getGlyphLogicalBounds(i);
                if (shape == null) continue;
                generalPath.append(shape, false);
            }
            this.logicalBounds = generalPath.getBounds2D();
        }
        return this.logicalBounds;
    }

    public int getNumGlyphs() {
        if (this.glyphs != null) {
            return this.glyphs.length;
        }
        return 0;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            this.outline = new GeneralPath();
            for (int i = 0; i < this.glyphs.length; ++i) {
                Shape shape;
                if (!this.glyphVisible[i] || (shape = this.glyphs[i].getOutline()) == null) continue;
                this.outline.append(shape, false);
            }
        }
        return this.outline;
    }

    public Shape getOutline(float f, float f2) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public Rectangle2D getGeometricBounds() {
        return this.getOutline().getBounds2D();
    }

    public void performDefaultLayout() {
        this.logicalBounds = null;
        this.outline = null;
        this.bounds2D = null;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.glyphs.length; ++i) {
            Glyph glyph = this.glyphs[i];
            glyph.setTransform(null);
            this.glyphLogicalBounds[i] = null;
            String string = glyph.getUnicode();
            if (string != null && string.length() != 0 && ArabicTextHandler.arabicCharTransparent(string.charAt(0))) {
                char c;
                int n;
                for (n = i + 1; n < this.glyphs.length && (string = this.glyphs[n].getUnicode()) != null && string.length() != 0 && ArabicTextHandler.arabicCharTransparent(c = string.charAt(0)); ++n) {
                }
                if (n != this.glyphs.length) {
                    Glyph glyph2 = this.glyphs[n];
                    float f3 = f + glyph2.getHorizAdvX();
                    for (int j = i; j < n; ++j) {
                        glyph = this.glyphs[j];
                        glyph.setTransform(null);
                        this.glyphLogicalBounds[i] = null;
                        glyph.setPosition(new Point2D.Float(f3 - glyph.getHorizAdvX(), f2));
                    }
                    i = n;
                    glyph = glyph2;
                }
            }
            glyph.setPosition(new Point2D.Float(f, f2));
            f += glyph.getHorizAdvX();
        }
        this.endPos = new Point2D.Float(f, f2);
    }

    public void setGlyphPosition(int n, Point2D point2D) throws IndexOutOfBoundsException {
        if (n == this.glyphs.length) {
            this.endPos = (Point2D)point2D.clone();
            return;
        }
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        this.glyphs[n].setPosition(point2D);
        this.glyphLogicalBounds[n] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        this.glyphs[n].setTransform(affineTransform);
        this.glyphLogicalBounds[n] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphVisible(int n, boolean bl) {
        if (bl == this.glyphVisible[n]) {
            return;
        }
        this.glyphVisible[n] = bl;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds[n] = null;
    }

    public boolean isGlyphVisible(int n) {
        return this.glyphVisible[n];
    }

    public int getCharacterCount(int n, int n2) {
        int n3 = 0;
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.glyphs.length - 1) {
            n2 = this.glyphs.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            Glyph glyph = this.glyphs[i];
            if (glyph.getGlyphCode() == -1) {
                ++n3;
                continue;
            }
            String string = glyph.getUnicode();
            n3 += string.length();
        }
        return n3;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (!textPaintInfo.visible) {
            return;
        }
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (!this.glyphVisible[i]) continue;
            this.glyphs[i].draw(graphics2D);
        }
    }
}

