/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.kafka.server.util.json.JsonValue;

public class JsonArray
implements JsonValue {
    protected final ArrayNode node;

    JsonArray(ArrayNode node) {
        this.node = node;
    }

    @Override
    public JsonNode node() {
        return this.node;
    }

    public Iterator<JsonValue> iterator() {
        Stream<JsonNode> nodeStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.node.elements(), 16), false);
        Stream<JsonValue> results = nodeStream.map(JsonValue::apply);
        return results.collect(Collectors.toList()).iterator();
    }

    public int hashCode() {
        return this.node().hashCode();
    }

    public boolean equals(Object a) {
        if (a instanceof JsonArray) {
            return this.node().equals((Object)((JsonArray)a).node());
        }
        return false;
    }

    public String toString() {
        return this.node().toString();
    }
}

