/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.AllocTableView;
import org.netbeans.lib.profiler.ui.memory.AllocTreeTableView;
import org.netbeans.lib.profiler.ui.memory.LivenessTableView;
import org.netbeans.lib.profiler.ui.memory.LivenessTreeTableView;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.memory.SampledTableView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;

public abstract class LiveMemoryView
extends JPanel {
    private MemoryView dataView;
    private long lastupdate;
    private volatile boolean refreshIsRunning;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private MemoryResultsSnapshot snapshot;
    private MemoryResultsSnapshot refSnapshot;
    private GenericFilter filter;

    public LiveMemoryView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.selection = selection;
        this.initUI();
    }

    public boolean isRefreshRunning() {
        return this.refreshIsRunning;
    }

    public long getLastUpdate() {
        return this.lastupdate;
    }

    public void setData(final MemoryResultsSnapshot snapshotData, final GenericFilter ifilter) {
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        UIUtils.runInEventDispatchThread(new Runnable(){
            final /* synthetic */ LiveMemoryView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.updateDataView(snapshotData);
                    this.this$0.snapshot = snapshotData;
                    this.this$0.filter = ifilter;
                    if (this.this$0.dataView != null && this.this$0.snapshot != null) {
                        if (this.this$0.refSnapshot == null) {
                            this.this$0.dataView.setData(this.this$0.snapshot, this.this$0.filter, 1);
                        } else {
                            this.this$0.dataView.setData(this.this$0.refSnapshot.createDiff(this.this$0.snapshot), this.this$0.filter, 1);
                        }
                    }
                }
                finally {
                    this.this$0.refreshIsRunning = false;
                    this.this$0.lastupdate = System.currentTimeMillis();
                }
            }
        });
    }

    public boolean setDiffView(boolean diff) {
        if (this.snapshot == null) {
            return false;
        }
        this.refSnapshot = diff ? this.snapshot : null;
        this.setData(this.snapshot, this.filter);
        return true;
    }

    public void resetData() {
        if (this.dataView != null) {
            this.dataView.resetData();
        }
        this.snapshot = null;
        this.refSnapshot = null;
        this.filter = null;
    }

    public void showSelectionColumn() {
        if (this.dataView != null) {
            this.dataView.showSelectionColumn();
        }
    }

    public void refreshSelection() {
        if (this.dataView != null) {
            this.dataView.showSelectionColumn();
        }
    }

    protected boolean profileClassSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void updateDataView(MemoryResultsSnapshot snapshot) {
        if (snapshot == null || snapshot instanceof SampledMemoryResultsSnapshot) {
            if (this.dataView instanceof SampledTableView) {
                return;
            }
            this.dataView = new SampledTableView(this.selection){

                @Override
                protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                    if (LiveMemoryView.this.showSourceSupported()) {
                        LiveMemoryView.this.showSource(userValue);
                    }
                }

                @Override
                protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                    LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                }

                @Override
                protected void popupShowing() {
                    LiveMemoryView.this.popupShowing();
                }

                @Override
                protected void popupHidden() {
                    LiveMemoryView.this.popupHidden();
                }

                @Override
                protected boolean hasBottomFilterFindMargin() {
                    return true;
                }
            };
        } else if (snapshot instanceof AllocMemoryResultsSnapshot) {
            if (snapshot.containsStacks()) {
                if (this.dataView instanceof AllocTreeTableView) {
                    return;
                }
                this.dataView = new AllocTreeTableView(this.selection){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            } else {
                if (this.dataView instanceof AllocTableView) {
                    return;
                }
                this.dataView = new AllocTableView(this.selection){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            }
        } else if (snapshot instanceof LivenessMemoryResultsSnapshot) {
            if (snapshot.containsStacks()) {
                if (this.dataView instanceof LivenessTreeTableView) {
                    return;
                }
                this.dataView = new LivenessTreeTableView(this.selection, false){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            } else {
                if (this.dataView instanceof LivenessTableView) {
                    return;
                }
                this.dataView = new LivenessTableView(this.selection, false){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            }
        } else {
            this.dataView = null;
        }
        this.removeAll();
        this.resetData();
        if (this.dataView != null) {
            this.add((Component)this.dataView, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, Object value, final ClientUtils.SourceCodeSelection userValue) {
        JMenuItem[] customItems;
        if (this.showSourceSupported()) {
            popup.add(new JMenuItem(this, MemoryView.ACTION_GOTOSOURCE){
                final /* synthetic */ LiveMemoryView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    this.this$0.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        if (this.profileClassSupported()) {
            popup.add(new JMenuItem(this, MemoryView.ACTION_PROFILE_CLASS){
                final /* synthetic */ LiveMemoryView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    this.this$0.selectForProfiling(userValue);
                }
            });
        }
        if (this.profileClassSupported()) {
            popup.addSeparator();
        }
        if ((customItems = invoker.createCustomMenuItems(this, value, userValue)) != null) {
            for (JMenuItem customItem : customItems) {
                popup.add(customItem);
            }
            popup.addSeparator();
        }
        this.customizeNodePopup(invoker, popup, value, userValue);
        if (this.snapshot.containsStacks()) {
            final ProfilerTreeTable ttable = (ProfilerTreeTable)this.dataView.getResultsComponent();
            JMenu expand = new JMenu(MemoryView.EXPAND_MENU);
            popup.add(expand);
            expand.add(new JMenuItem(this, MemoryView.EXPAND_PLAIN_ITEM){
                final /* synthetic */ LiveMemoryView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandPlainPath(ttable.getSelectedRow(), 1);
                }
            });
            expand.add(new JMenuItem(this, MemoryView.EXPAND_TOPMOST_ITEM){
                final /* synthetic */ LiveMemoryView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandFirstPath(ttable.getSelectedRow());
                }
            });
            expand.addSeparator();
            expand.add(new JMenuItem(this, MemoryView.COLLAPSE_CHILDREN_ITEM){
                final /* synthetic */ LiveMemoryView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseChildren(ttable.getSelectedRow());
                }
            });
            expand.add(new JMenuItem(this, MemoryView.COLLAPSE_ALL_ITEM){
                final /* synthetic */ LiveMemoryView this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseAll();
                }
            });
            popup.addSeparator();
        }
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(this, FilterUtils.ACTION_FILTER){
            final /* synthetic */ LiveMemoryView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(this, SearchUtils.ACTION_FIND){
            final /* synthetic */ LiveMemoryView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    protected void customizeNodePopup(DataView invoker, JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
    }

    private void initUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.updateDataView(null);
        this.registerActions();
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveMemoryView.this.dataView.activateFilter();
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveMemoryView.this.dataView.activateSearch();
            }
        });
    }
}

