/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMark;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.snaptracer.impl.swing.EnhancedLabelRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderLabel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderPanel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LegendFont;
import org.netbeans.modules.profiler.snaptracer.impl.swing.TimelineMarksPainter;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;

final class TimelineAxis
extends JPanel {
    private final HeaderRenderer painter = new HeaderRenderer();
    private final AxisComponent axis;
    private final MarksComponent marks;
    private int preferredHeight;
    private int pointerX;

    TimelineAxis(final TimelineChart chart, TimelineSupport support) {
        super(null);
        Timeline timeline = ((SynchronousXYItemsModel)chart.getItemsModel()).getTimeline();
        this.axis = new Axis(chart, new MarksComputer(timeline, chart.getChartContext()));
        this.marks = new MarksComponent(support);
        this.preferredHeight = HeaderLabel.DEFAULT_HEIGHT;
        this.add(this.marks);
        this.add((Component)this.axis);
        this.add(this.painter);
        chart.addConfigurationListener((ChartConfigurationListener)new ChartConfigurationListener.Adapter(){
            private final Runnable updater = new Runnable(){

                @Override
                public void run() {
                    if (!TimelineAxis.this.axis.isVisible()) {
                        TimelineAxis.this.marks.setupTicks();
                        TimelineAxis.this.marks.refreshHoverMark(TimelineAxis.this.pointerX);
                        TimelineAxis.this.marks.repaint();
                    }
                }
            };

            public void contentsUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY, int shiftX, int shiftY) {
                if (lastOffsetX != offsetX || lastScaleX != scaleX) {
                    TimelineAxis.this.marks.refreshMarks();
                }
                SwingUtilities.invokeLater(this.updater);
            }
        });
        support.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void intervalsSelectionChanged() {
                TimelineAxis.this.marks.refreshMarks();
                TimelineAxis.this.marks.repaint();
            }

            @Override
            public void indexSelectionChanged() {
            }

            @Override
            public void timeSelectionChanged(boolean timestampsSelected, boolean justHovering) {
                TimelineAxis.this.marks.refreshMarks();
                TimelineAxis.this.marks.repaint();
            }
        });
        this.marks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TimelineAxis.this.pointerX = e.getX();
                TimelineAxis.this.marks.setupTicks();
                TimelineAxis.this.marks.refreshHoverMark(TimelineAxis.this.pointerX);
                TimelineAxis.this.axis.setVisible(false);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimelineAxis.this.axis.setVisible(true);
                TimelineAxis.this.marks.clearTicks();
                TimelineAxis.this.marks.refreshHoverMark(-10);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TimelineAxis.this.marks.handleAction();
                TimelineAxis.this.marks.repaint();
            }
        });
        this.marks.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TimelineAxis.this.pointerX = e.getX();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                TimelineAxis.this.pointerX = e.getX();
                if (!TimelineAxis.this.axis.isVisible()) {
                    TimelineAxis.this.marks.refreshHoverMark(TimelineAxis.this.pointerX);
                }
            }
        });
        this.marks.addMouseWheelListener(new MouseWheelListener(){
            final /* synthetic */ TimelineAxis this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                e.setSource((Object)chart);
                chart.processMouseWheelEvent(e);
            }
        });
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = this.preferredHeight;
        return size;
    }

    @Override
    public void validate() {
    }

    @Override
    public void doLayout() {
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.painter.reshape(0, 0, width, height);
        this.axis.reshape(1, 1, width - 2, height - 2);
        this.marks.reshape(0, 0, width, height);
    }

    private static class MarksComponent
    extends JComponent {
        private static final Image MARK = Icons.getImage((String)"TracerIcons.Mark");
        private static final Image MARK_HIGHL = Icons.getImage((String)"TracerIcons.MarkHiglight");
        private static final int MARK_EXTENT = MARK.getWidth(null) / 2;
        private static final int MARK_HEIGHT = MARK.getHeight(null);
        private final TimelineSupport support;
        private final Timeline timeline;
        private final SynchronousXYChartContext context;
        private final EnhancedLabelRenderer timeRenderer;
        private final Format timeFormat;
        private int[] ticks;
        private int hoverIndex = -1;
        private int hoverX = -10;
        private boolean wasSelected;
        private long hoverTime;
        private final List<Integer> selections = new ArrayList<Integer>();
        private final List<Integer> intervals = new ArrayList<Integer>();
        private final int markExtent = 2;
        private final Color systemSelection = Utils.getSystemSelection();
        private final Color selection = new Color(this.systemSelection.getRed(), this.systemSelection.getGreen(), this.systemSelection.getBlue(), 150);

        MarksComponent(TimelineSupport support) {
            this.support = support;
            TimelineChart chart = support.getChart();
            SynchronousXYItemsModel model = (SynchronousXYItemsModel)chart.getItemsModel();
            this.context = (SynchronousXYChartContext)chart.getChartContext();
            this.timeline = model.getTimeline();
            this.timeRenderer = new EnhancedLabelRenderer();
            if (UIUtils.isAquaLookAndFeel()) {
                LegendFont f = new LegendFont();
                this.timeRenderer.setFont(f.deriveFont(f.getSize2D() - 1.0f));
                this.timeRenderer.setMargin(new Insets(0, 2, 0, 2));
            } else {
                this.timeRenderer.setFont(new LegendFont());
                this.timeRenderer.setMargin(new Insets(1, 2, 1, 2));
            }
            this.timeRenderer.setBackground(Color.WHITE);
            this.timeRenderer.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.timeFormat = new SimpleDateFormat(TimeAxisUtils.getFormatString((long)1L, (long)1L, (long)1L));
            this.setOpaque(false);
        }

        @Override
        public void validate() {
        }

        @Override
        public void doLayout() {
        }

        void refreshMarks() {
            List<Integer> selectedIntervals;
            Set<Integer> selectedIndexes = this.support.getSelectedTimestamps();
            if (!selectedIndexes.isEmpty() || !this.selections.isEmpty()) {
                this.selections.clear();
                for (int selectedIndex : selectedIndexes) {
                    long time = this.timeline.getTimestamp(selectedIndex);
                    int x = Utils.checkedInt((double)this.context.getViewX((double)time));
                    if (x <= -2 || x >= this.getWidth() + 2) continue;
                    this.selections.add(x + 1);
                }
            }
            if (!(selectedIntervals = this.support.getSelectedIntervals()).isEmpty() || !this.intervals.isEmpty()) {
                this.intervals.clear();
                Iterator<Integer> iter = selectedIntervals.iterator();
                while (iter.hasNext()) {
                    int start = iter.next();
                    long time = this.timeline.getTimestamp(start);
                    int startX = Utils.checkedInt((double)this.context.getViewX((double)time)) + 1;
                    int stop = iter.hasNext() ? iter.next().intValue() : this.getWidth();
                    time = this.timeline.getTimestamp(stop);
                    int stopX = Utils.checkedInt((double)this.context.getViewX((double)time)) + 1;
                    if (startX >= this.getWidth() || stopX <= 0) continue;
                    this.intervals.add(startX);
                    this.intervals.add(stopX);
                }
            }
        }

        void setupTicks() {
            int[][] idxs = this.support.getPointsComputer().getVisible(this.getBounds(), this.timeline.getTimestampsCount(), this.context, 1, 0);
            int[] nArray = this.ticks = idxs == null ? null : idxs[0];
            if (this.ticks != null) {
                for (int i = 0; i < idxs[1][0]; ++i) {
                    this.ticks[i] = Utils.checkedInt((double)this.context.getViewX((double)this.timeline.getTimestamp(this.ticks[i]))) + 1;
                }
            }
        }

        void refreshHoverMark(int pointerX) {
            int lastHoverIndex = this.hoverIndex;
            this.hoverIndex = this.context.getNearestTimestampIndex(pointerX - 1, 0);
            int n = this.hoverX = this.hoverIndex == -1 ? -10 : Utils.checkedInt((double)this.context.getViewX((double)this.timeline.getTimestamp(this.hoverIndex))) + 1;
            if (Math.abs(this.hoverX - pointerX + 1) > MARK_EXTENT) {
                this.hoverIndex = -1;
                this.hoverX = -10;
            }
            if (lastHoverIndex != this.hoverIndex) {
                if (!this.wasSelected) {
                    this.support.unselectTimestamp(lastHoverIndex);
                }
                this.wasSelected = this.hoverIndex != -1 && this.support.isTimestampSelected(this.hoverIndex);
                this.support.setTimestampHovering(this.hoverIndex != -1, this.wasSelected);
                if (this.hoverIndex != -1) {
                    this.support.selectTimestamp(this.hoverIndex, false);
                    this.hoverTime = this.timeline.getTimestamp(this.hoverIndex);
                    if (this.wasSelected) {
                        this.repaint();
                    }
                } else if (!this.wasSelected) {
                    this.repaint();
                }
                if (this.hoverIndex == -1) {
                    this.setCursor(Cursor.getDefaultCursor());
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }

        void clearTicks() {
            this.ticks = null;
        }

        void handleAction() {
            this.wasSelected = !this.wasSelected;
            this.support.setTimestampHovering(this.hoverIndex != -1, this.wasSelected);
        }

        @Override
        public void paint(Graphics g) {
            int height = this.getHeight();
            int width = this.getWidth();
            int top = height / 2 - 1;
            int bottom = top + 2;
            g.setColor(this.selection);
            if (this.intervals != null && !this.intervals.isEmpty()) {
                Iterator<Integer> iter = this.intervals.iterator();
                while (iter.hasNext()) {
                    int start = iter.next();
                    int wdth = iter.next() - start + 1;
                    g.fillRect(start, height - 6, Math.min(wdth, width - start - 3), 3);
                }
            }
            g.setColor(this.getForeground());
            if (this.ticks != null) {
                for (int i = 0; i < this.ticks.length; ++i) {
                    g.drawLine(this.ticks[i], top, this.ticks[i], bottom);
                }
            }
            if (this.selections != null && !this.selections.isEmpty()) {
                int y = height - 5 - MARK_HEIGHT;
                for (int x : this.selections) {
                    g.drawImage(x == this.hoverX && this.wasSelected ? MARK_HIGHL : MARK, x - MARK_EXTENT + 1, y, null);
                }
                if (this.hoverIndex != -1) {
                    this.timeRenderer.setText(this.timeFormat.format(this.hoverTime));
                    Dimension timeSize = this.timeRenderer.getPreferredSize();
                    int timeWidth = timeSize.width;
                    int extraWidth = MARK_EXTENT + 15;
                    int timeX = this.hoverX + extraWidth;
                    if (timeX > width - timeWidth - 10) {
                        timeX = this.hoverX - timeWidth - extraWidth;
                    }
                    this.timeRenderer.setLocation(timeX, top - timeSize.height / 2);
                    this.timeRenderer.paint(g);
                }
            }
        }
    }

    private static class HeaderRenderer
    extends HeaderPanel {
        private Image offscreen;
        long total = 0L;
        int count = 0;

        private HeaderRenderer() {
        }

        @Override
        public void reshape(int x, int y, int width, int height) {
            if (this.getWidth() != width || this.getHeight() != height) {
                this.offscreen = null;
            }
            super.reshape(x, y, width, height);
        }

        @Override
        public void validate() {
        }

        @Override
        public void paint(Graphics g) {
            if (this.offscreen == null) {
                this.offscreen = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                super.paint(this.offscreen.getGraphics());
            }
            g.drawImage(this.offscreen, 0, 0, null);
        }
    }

    private static class Axis
    extends AxisComponent {
        private static final int LAF_OFFSET = Axis.resolveOffset();
        private final Paint meshPaint = Utils.checkedColor((Color)new Color(180, 180, 180, 50));
        private final Stroke meshStroke = new BasicStroke(1.0f);
        private final TimelineChart chart;
        private final MarksComputer marksComputer;
        private final TimelineMarksPainter marksPainter;
        private boolean hadTicks = false;
        private final Runnable repainter;

        Axis(TimelineChart chart, MarksComputer marksComputer) {
            super((ChartComponent)chart, (AxisMarksComputer)marksComputer, null, 1, 2);
            this.chart = chart;
            this.marksComputer = marksComputer;
            this.marksPainter = new TimelineMarksPainter();
            this.repainter = new Runnable(){

                @Override
                public void run() {
                    chart.invalidateRepaint();
                }
            };
        }

        public void validate() {
        }

        public void doLayout() {
        }

        public void paint(Graphics g) {
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clip = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            }
            this.marksComputer.refresh();
            this.paintHorizontalAxis(g, clip);
        }

        protected void paintHorizontalMesh(Graphics2D g, Rectangle clip, Rectangle chartMask) {
            Iterator marks = this.marksComputer.marksIterator(chartMask.x, chartMask.x + chartMask.width);
            boolean hasTicks = false;
            while (marks.hasNext()) {
                hasTicks = true;
                AxisMark mark = (AxisMark)marks.next();
                int x = mark.getPosition();
                g.setPaint(this.meshPaint);
                g.setStroke(this.meshStroke);
                g.drawLine(x, chartMask.y, x, chartMask.y + chartMask.height);
            }
            if (!this.hadTicks && hasTicks) {
                SwingUtilities.invokeLater(this.repainter);
            }
            this.hadTicks = hasTicks;
        }

        protected void paintHorizontalAxis(Graphics g, Rectangle clip) {
            int rZeroOffset;
            int viewStart = -1;
            int viewEnd = viewStart + this.chart.getWidth() + 2;
            Iterator marks = this.marksComputer.marksIterator(viewStart, viewEnd);
            int lZeroOffset = this.chart.isRightBased() ? 0 : 1;
            int n = rZeroOffset = this.chart.isRightBased() ? 1 : 0;
            while (marks.hasNext()) {
                AxisMark mark = (AxisMark)marks.next();
                int x = mark.getPosition() - 1;
                if (x < -1 - lZeroOffset || x >= -1 + this.chart.getWidth() + rZeroOffset) continue;
                TimelineMarksPainter painter = (TimelineMarksPainter)this.marksPainter.getPainter(mark);
                Dimension painterSize = painter.getPreferredSize();
                int markOffsetX = painterSize.width / 2;
                if (x + markOffsetX < clip.x || x - markOffsetX >= clip.x + clip.width) continue;
                g.setColor(this.getForeground());
                g.drawLine(x, 1, x, 3);
                int markOffsetY = (this.getHeight() - painterSize.height) / 2 + LAF_OFFSET;
                painter.setLocation(x - markOffsetX, markOffsetY);
                painter.paint(g);
            }
        }

        private static int resolveOffset() {
            if (UIUtils.isWindowsLookAndFeel() || UIUtils.isMetalLookAndFeel() || UIUtils.isGTKLookAndFeel()) {
                return 1;
            }
            return 0;
        }
    }

    private static class MarksComputer
    extends TimelineMarksComputer {
        MarksComputer(Timeline timeline, ChartContext context) {
            super(timeline, context, 0);
        }

        void refresh() {
            this.refreshConfiguration();
        }
    }
}

