/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DatabaseUpgradeSourceBase;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="source")
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseUpgradeWithDbVersionDetails
extends DatabaseUpgradeSourceBase {
    @JsonProperty(value="dbVersion")
    private final String dbVersion;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DatabaseUpgradeWithDbVersionDetails(String options, String dbVersion) {
        super(options);
        this.dbVersion = dbVersion;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseUpgradeWithDbVersionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseUpgradeWithDbVersionDetails)) {
            return false;
        }
        DatabaseUpgradeWithDbVersionDetails other = (DatabaseUpgradeWithDbVersionDetails)((Object)o);
        return Objects.equals(this.dbVersion, other.dbVersion) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="options")
        private String options;
        @JsonProperty(value="dbVersion")
        private String dbVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder options(String options) {
            this.options = options;
            this.__explicitlySet__.add("options");
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            this.__explicitlySet__.add("dbVersion");
            return this;
        }

        public DatabaseUpgradeWithDbVersionDetails build() {
            DatabaseUpgradeWithDbVersionDetails model = new DatabaseUpgradeWithDbVersionDetails(this.options, this.dbVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseUpgradeWithDbVersionDetails model) {
            if (model.wasPropertyExplicitlySet("options")) {
                this.options(model.getOptions());
            }
            if (model.wasPropertyExplicitlySet("dbVersion")) {
                this.dbVersion(model.getDbVersion());
            }
            return this;
        }
    }
}

