/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.RestoreAutonomousDatabaseDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RestoreAutonomousDatabaseRequest
extends BmcRequest<RestoreAutonomousDatabaseDetails> {
    private String autonomousDatabaseId;
    private RestoreAutonomousDatabaseDetails restoreAutonomousDatabaseDetails;
    private String ifMatch;

    public String getAutonomousDatabaseId() {
        return this.autonomousDatabaseId;
    }

    public RestoreAutonomousDatabaseDetails getRestoreAutonomousDatabaseDetails() {
        return this.restoreAutonomousDatabaseDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public RestoreAutonomousDatabaseDetails getBody$() {
        return this.restoreAutonomousDatabaseDetails;
    }

    public Builder toBuilder() {
        return new Builder().autonomousDatabaseId(this.autonomousDatabaseId).restoreAutonomousDatabaseDetails(this.restoreAutonomousDatabaseDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autonomousDatabaseId=").append(String.valueOf(this.autonomousDatabaseId));
        sb.append(",restoreAutonomousDatabaseDetails=").append(String.valueOf((Object)this.restoreAutonomousDatabaseDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestoreAutonomousDatabaseRequest)) {
            return false;
        }
        RestoreAutonomousDatabaseRequest other = (RestoreAutonomousDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autonomousDatabaseId, other.autonomousDatabaseId) && Objects.equals((Object)this.restoreAutonomousDatabaseDetails, (Object)other.restoreAutonomousDatabaseDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autonomousDatabaseId == null ? 43 : this.autonomousDatabaseId.hashCode());
        result = result * 59 + (this.restoreAutonomousDatabaseDetails == null ? 43 : this.restoreAutonomousDatabaseDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autonomousDatabaseId = null;
        private RestoreAutonomousDatabaseDetails restoreAutonomousDatabaseDetails = null;
        private String ifMatch = null;

        public Builder autonomousDatabaseId(String autonomousDatabaseId) {
            this.autonomousDatabaseId = autonomousDatabaseId;
            return this;
        }

        public Builder restoreAutonomousDatabaseDetails(RestoreAutonomousDatabaseDetails restoreAutonomousDatabaseDetails) {
            this.restoreAutonomousDatabaseDetails = restoreAutonomousDatabaseDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestoreAutonomousDatabaseRequest o) {
            this.autonomousDatabaseId(o.getAutonomousDatabaseId());
            this.restoreAutonomousDatabaseDetails(o.getRestoreAutonomousDatabaseDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestoreAutonomousDatabaseRequest build() {
            RestoreAutonomousDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RestoreAutonomousDatabaseDetails body) {
            this.restoreAutonomousDatabaseDetails(body);
            return this;
        }

        public RestoreAutonomousDatabaseRequest buildWithoutInvocationCallback() {
            RestoreAutonomousDatabaseRequest request = new RestoreAutonomousDatabaseRequest();
            request.autonomousDatabaseId = this.autonomousDatabaseId;
            request.restoreAutonomousDatabaseDetails = this.restoreAutonomousDatabaseDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

