/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpdateDbSystemDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDbSystemRequest
extends BmcRequest<UpdateDbSystemDetails> {
    private String dbSystemId;
    private UpdateDbSystemDetails updateDbSystemDetails;
    private String ifMatch;

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public UpdateDbSystemDetails getUpdateDbSystemDetails() {
        return this.updateDbSystemDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateDbSystemDetails getBody$() {
        return this.updateDbSystemDetails;
    }

    public Builder toBuilder() {
        return new Builder().dbSystemId(this.dbSystemId).updateDbSystemDetails(this.updateDbSystemDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(",updateDbSystemDetails=").append(String.valueOf((Object)this.updateDbSystemDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDbSystemRequest)) {
            return false;
        }
        UpdateDbSystemRequest other = (UpdateDbSystemRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals((Object)this.updateDbSystemDetails, (Object)other.updateDbSystemDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.updateDbSystemDetails == null ? 43 : this.updateDbSystemDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDbSystemRequest, UpdateDbSystemDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbSystemId = null;
        private UpdateDbSystemDetails updateDbSystemDetails = null;
        private String ifMatch = null;

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder updateDbSystemDetails(UpdateDbSystemDetails updateDbSystemDetails) {
            this.updateDbSystemDetails = updateDbSystemDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDbSystemRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.updateDbSystemDetails(o.getUpdateDbSystemDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDbSystemRequest build() {
            UpdateDbSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDbSystemDetails body) {
            this.updateDbSystemDetails(body);
            return this;
        }

        public UpdateDbSystemRequest buildWithoutInvocationCallback() {
            UpdateDbSystemRequest request = new UpdateDbSystemRequest();
            request.dbSystemId = this.dbSystemId;
            request.updateDbSystemDetails = this.updateDbSystemDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

