/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.debug;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.compiler.TruffleCompilerListener;
import com.oracle.truffle.runtime.AbstractCompilationTask;
import com.oracle.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import com.oracle.truffle.runtime.CompilationTask;
import com.oracle.truffle.runtime.FixedPointMath;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedDirectCallNode;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;

public final class TraceCompilationListener
extends AbstractGraalTruffleRuntimeListener {
    private final ThreadLocal<Times> currentCompilation = new ThreadLocal();
    public static final String TIER_FORMAT = "Tier %d";
    private static final String QUEUE_FORMAT = "Queue: Size %4d Change %c%-2d Load %5.2f Time %5dus                    ";
    private static final String TARGET_FORMAT = "id=%-5d %-50s ";
    public static final String COUNT_THRESHOLD_FORMAT = "Count/Thres  %9d/%9d";
    private static final String QUEUED_FORMAT = "opt queued id=%-5d %-50s |Tier %d|Count/Thres  %9d/%9d|Queue: Size %4d Change %c%-2d Load %5.2f Time %5dus                    |Timestamp %d|Src %s";
    private static final String UNQUEUED_FORMAT = "opt unque. id=%-5d %-50s |Tier %d|Count/Thres  %9d/%9d|Queue: Size %4d Change %c%-2d Load %5.2f Time %5dus                    |Timestamp %d|Src %s|Reason %s";
    private static final String START_FORMAT = "opt start  id=%-5d %-50s |Tier %d|Priority %9d|Rate %.6f|Queue: Size %4d Change %c%-2d Load %5.2f Time %5dus                    |Timestamp %d|Src %s";
    private static final String DONE_FORMAT = "opt done   id=%-5d %-50s |Tier %d|Time %18s|AST %4d|Inlined %3dY %3dN|IR %6d/%6d|CodeSize %7d|Addr %7s|Timestamp %d|Src %s";
    private static final String FAILED_FORMAT = "opt failed id=%-5d %-50s |Tier %d|Time %18s|Reason: %s|Timestamp %d|Src %s";
    private static final String INV_FORMAT = "opt inval. id=%-5d %-50s                                                                                                                 |Timestamp %d|Src %s|Reason %s";
    private static final String DEOPT_FORMAT = "opt deopt  id=%-5d %-50s |                                                                                                               |Timestamp %d|Src %s";

    private TraceCompilationListener(OptimizedTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(OptimizedTruffleRuntime runtime) {
        runtime.addListener(new TraceCompilationListener(runtime));
    }

    @Override
    public void onCompilationQueued(OptimizedCallTarget target, int tier) {
        if (target.engine.traceCompilationDetails) {
            int callAndLoopThreshold = target.engine.multiTier && tier == 2 ? target.engine.callAndLoopThresholdInFirstTier : target.engine.callAndLoopThresholdInInterpreter;
            int scale = this.runtime.compilationThresholdScale();
            this.log(target, String.format(QUEUED_FORMAT, target.id, this.safeTargetName(target), tier, target.getCallAndLoopCount(), OptimizedCallTarget.scaledThreshold(callAndLoopThreshold), this.runtime.getCompilationQueueSize(), Character.valueOf('+'), 1, FixedPointMath.toDouble(scale), 0, System.nanoTime(), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target))));
        }
    }

    @Override
    public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason, int tier) {
        if (target.engine.traceCompilationDetails) {
            int callAndLoopThreshold = tier == 1 ? target.engine.callAndLoopThresholdInInterpreter : target.engine.callAndLoopThresholdInFirstTier;
            int scale = this.runtime.compilationThresholdScale();
            this.log(target, String.format(UNQUEUED_FORMAT, target.id, this.safeTargetName(target), tier, target.getCallAndLoopCount(), FixedPointMath.multiply(scale, callAndLoopThreshold), this.runtime.getCompilationQueueSize(), Character.valueOf(' '), 0, FixedPointMath.toDouble(scale), 0, System.nanoTime(), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target)), reason));
        }
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout, int tier) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            if (!TraceCompilationListener.isPermanentFailure(bailout, permanentBailout)) {
                this.onCompilationDequeued(target, null, "Non permanent bailout: " + reason, tier);
            } else {
                this.log(target, String.format(FAILED_FORMAT, target.id, this.safeTargetName(target), tier, this.compilationTime(), reason, System.nanoTime(), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target))));
            }
            this.currentCompilation.remove();
        }
    }

    @Override
    public void onCompilationStarted(OptimizedCallTarget target, AbstractCompilationTask task) {
        if (target.engine.traceCompilationDetails) {
            int queueChange;
            double rate;
            long time;
            double weight;
            if (task instanceof CompilationTask) {
                CompilationTask t = (CompilationTask)task;
                weight = t.weight();
                time = t.time();
                rate = t.rate();
                queueChange = t.queueChange();
            } else {
                weight = 0.0;
                time = 0L;
                rate = Double.NaN;
                queueChange = 0;
            }
            this.log(target, String.format(START_FORMAT, target.id, this.safeTargetName(target), task.tier(), (int)weight, rate, this.runtime.getCompilationQueueSize(), Character.valueOf(queueChange >= 0 ? (char)'+' : '-'), Math.abs(queueChange), FixedPointMath.toDouble(this.runtime.compilationThresholdScale()), time / 1000L, System.nanoTime(), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target))));
        }
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            this.currentCompilation.set(new Times());
        }
    }

    private void log(OptimizedCallTarget target, String message) {
        this.runtime.log(target, message);
    }

    @Override
    public void onCompilationDeoptimized(OptimizedCallTarget target, Frame frame) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            this.log(target, String.format(DEOPT_FORMAT, target.id, this.safeTargetName(target), System.nanoTime(), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target))));
        }
    }

    @Override
    public void onCompilationTruffleTierFinished(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            Times current = this.currentCompilation.get();
            current.timePartialEvaluationFinished = System.nanoTime();
            current.nodeCountPartialEval = graph.getNodeCount();
        }
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        if (!target.engine.traceCompilation && !target.engine.traceCompilationDetails) {
            return;
        }
        Times compilation = this.currentCompilation.get();
        int[] inlinedAndDispatched = this.inlinedAndDispatched(target, task);
        this.log(target, String.format(DONE_FORMAT, target.id, this.safeTargetName(target), task.tier(), this.compilationTime(), target.getNonTrivialNodeCount(), inlinedAndDispatched[0], inlinedAndDispatched[1], compilation.nodeCountPartialEval, graph == null ? 0 : graph.getNodeCount(), result == null ? 0 : result.getTargetCodeSize(), "0x" + Long.toHexString(target.getCodeAddress()), System.nanoTime(), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target))));
        this.currentCompilation.remove();
    }

    private SourceSection safeSourceSection(OptimizedCallTarget target) {
        try {
            return target.getRootNode().getSourceSection();
        }
        catch (Throwable throwable) {
            this.log(target, "Failed to call RootNode.getSourceSection(): " + String.valueOf(throwable));
            return null;
        }
    }

    private String safeTargetName(OptimizedCallTarget target) {
        try {
            return target.getName();
        }
        catch (Throwable throwable) {
            this.log(target, "Failed to call RootNode.getName(): " + String.valueOf(throwable));
            return null;
        }
    }

    private int[] inlinedAndDispatched(OptimizedCallTarget target, AbstractCompilationTask task) {
        try {
            int inlinedCalls;
            int calls = 0;
            if (task == null) {
                CallCountVisitor visitor = new CallCountVisitor();
                target.accept(visitor);
                calls = visitor.calls;
                inlinedCalls = 0;
            } else {
                calls = task.countCalls();
                inlinedCalls = task.countInlinedCalls();
            }
            int dispatchedCalls = calls - inlinedCalls;
            int[] inlinedAndDispatched = new int[]{inlinedCalls, dispatchedCalls};
            return inlinedAndDispatched;
        }
        catch (Throwable throwable) {
            this.log(target, "Failed to inlined and dispatched counts: " + String.valueOf(throwable));
            return null;
        }
    }

    private String compilationTime() {
        long timeCompilationFinished = System.nanoTime();
        Times compilation = this.currentCompilation.get();
        return String.format("%4.0f(%4.0f+%-4.0f)ms", (double)(timeCompilationFinished - compilation.timeCompilationStarted) / 1000000.0, (double)(compilation.timePartialEvaluationFinished - compilation.timeCompilationStarted) / 1000000.0, (double)(timeCompilationFinished - compilation.timePartialEvaluationFinished) / 1000000.0);
    }

    private static String formatSourceSection(SourceSection sourceSection) {
        if (sourceSection == null || sourceSection.getSource() == null) {
            return "n/a";
        }
        return String.format("%s:%d", sourceSection.getSource().getName(), sourceSection.getStartLine());
    }

    @Override
    public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            this.log(target, String.format(INV_FORMAT, target.id, this.safeTargetName(target), System.nanoTime(), TraceCompilationListener.formatSourceSection(this.safeSourceSection(target)), reason));
        }
    }

    private static boolean isPermanentFailure(boolean bailout, boolean permanentBailout) {
        return !bailout || permanentBailout;
    }

    private static final class Times {
        final long timeCompilationStarted = System.nanoTime();
        long timePartialEvaluationFinished;
        long nodeCountPartialEval;

        private Times() {
        }
    }

    static final class CallCountVisitor
    implements NodeVisitor {
        int calls = 0;

        CallCountVisitor() {
        }

        public boolean visit(Node node) {
            if (node instanceof OptimizedDirectCallNode) {
                ++this.calls;
            }
            return true;
        }
    }
}

