/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.nativeexecution.spi.support.NativeExecutionUserNotification;
import org.openide.util.NbBundle;

public class MiscUtils {
    private static boolean wasShown = false;

    public static boolean isJSCHTooLongException(Exception ex) {
        String message = "Received message is too long: ";
        boolean jschEx = ex instanceof JSchException || ex.getCause() instanceof JSchException;
        boolean longMessage = ex.getMessage().contains("Received message is too long: ") || ex.getCause() != null && ex.getCause().getMessage().contains("Received message is too long: ");
        return jschEx && longMessage;
    }

    public static void showJSCHTooLongNotification(String envName) {
        String title = NbBundle.getMessage(MiscUtils.class, (String)"JSCHReceivedMessageIsTooLong.error.title", (Object)envName);
        String shortText = NbBundle.getMessage(MiscUtils.class, (String)"JSCHReceivedMessageIsTooLong.error.shorttext");
        String details = NbBundle.getMessage(MiscUtils.class, (String)"JSCHReceivedMessageIsTooLong.error.text");
        MiscUtils.showNotification(title, shortText, details);
    }

    public static void showNotification(String title, String shortText, String longText) {
        if (wasShown) {
            return;
        }
        wasShown = true;
        NativeExecutionUserNotification.getDefault().showErrorNotification(title, shortText, longText);
    }

    public static boolean mightBrokeSftpChannel(SftpException e) {
        return e.id != 2 && e.id != 3;
    }

    public static List<String> getMessageAsList(Throwable ex) {
        String msg = ex.getMessage();
        if (msg == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(msg.split("\n"));
    }

    public static boolean isDebugged() {
        return DebugChecker.DEBUGGED;
    }

    private static class DebugChecker {
        public static final boolean DEBUGGED = DebugChecker.checkIfDebugged();

        private DebugChecker() {
        }

        private static boolean checkIfDebugged() {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                List<String> args = runtime.getInputArguments();
                for (String arg : args) {
                    if ("-Xdebug".equals(arg)) {
                        return true;
                    }
                    if ("-agentlib:jdwp".equals(arg)) {
                        return true;
                    }
                    if (!arg.startsWith("-agentlib:jdwp=")) continue;
                    return true;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return false;
        }
    }
}

