/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.maven.indexer.Bundle;
import org.netbeans.modules.maven.indexer.Cancellation;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.util.Cancellable;

public class RemoteIndexTransferListener
implements TransferListener,
Cancellable,
AutoCloseable {
    private static final Logger LOG = Logger.getLogger(RemoteIndexTransferListener.class.getName());
    @NonNull
    private final ProgressHandle handle;
    private final RepositoryInfo info;
    private long lastunit;
    private long units;
    private ResourceFetcher fetcher;
    private final AtomicBoolean canceled = new AtomicBoolean();
    private final AtomicBoolean unpacking = new AtomicBoolean();
    private static final Map<Thread, Integer> transfers = new HashMap<Thread, Integer>();
    private static final Object TRANSFERS_LOCK = new Object();

    public RemoteIndexTransferListener(RepositoryInfo info) {
        this.info = info;
        Cancellation.register(this);
        this.handle = ProgressHandle.createHandle((String)Bundle.LBL_Transfer(info.getName()), (Cancellable)this);
        this.handle.start();
    }

    void setFetcher(ResourceFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public void transferInitiated(TransferEvent e) {
        String u = e.getWagon().getRepository().getUrl() + String.valueOf(e.getResource());
        LOG.log(Level.FINE, "initiated transfer: {0}", u);
        this.handle.progress(u);
        this.checkCancel();
    }

    public void transferStarted(TransferEvent e) {
        this.checkCancel();
        long contentLength = e.getResource().getContentLength();
        LOG.log(Level.FINE, "contentLength: {0}", contentLength);
        this.units = contentLength / 1024L;
        this.handle.switchToDeterminate(100);
    }

    public boolean cancel() {
        this.handle.finish();
        if (this.fetcher != null) {
            try {
                this.fetcher.disconnect();
            }
            catch (IOException x) {
                LOG.log(Level.INFO, "closing " + this.info.getId(), x);
            }
        }
        return this.canceled.compareAndSet(false, true);
    }

    private void checkCancel() throws Cancellation {
        if (this.canceled.get()) {
            throw new Cancellation();
        }
    }

    public void transferProgress(TransferEvent e, byte[] buffer, int length) {
        this.checkCancel();
        LOG.log(Level.FINER, "progress: {0}", length);
        int work = length / 1024;
        if (this.units > 0L) {
            this.lastunit += (long)work;
            this.handle.progress(Math.min(100, (int)((double)this.lastunit / (double)this.units * 100.0)));
        }
    }

    public void transferCompleted(TransferEvent e) {
        LOG.fine("completed");
        this.handle.switchToIndeterminate();
    }

    public void transferError(TransferEvent e) {
        LOG.log(Level.FINE, "error transferring", e.getException());
        this.handle.switchToIndeterminate();
    }

    public void debug(String message) {
        this.checkCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToActive(Thread t) {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            Integer count = transfers.get(t);
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                count = count + 1;
            }
            transfers.put(t, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromActive(Thread t) {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            Integer count = transfers.get(t);
            if (count == null) {
                return;
            }
            if (count <= 1) {
                transfers.remove(t);
            } else {
                Integer n = count;
                count = count - 1;
                transfers.put(t, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Thread> getActiveTransfersOrScans() {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            return transfers.keySet();
        }
    }

    void unpackingProgress(String label) {
        this.checkCancel();
        if (this.unpacking.compareAndSet(false, true)) {
            this.handle.setDisplayName(Bundle.LBL_unpacking(this.info.getName()));
        }
        this.handle.progress(label);
    }

    @Override
    public void close() {
        this.handle.finish();
    }

    long getUnits() {
        return this.units;
    }
}

