/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionHandler2;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.api.elements.AliasedElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.EnumCaseElement;
import org.netbeans.modules.php.editor.api.elements.EnumElement;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TraitElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.api.elements.VariableElement;
import org.netbeans.modules.php.editor.completion.CompletionContextFinder;
import org.netbeans.modules.php.editor.completion.DocRenderer;
import org.netbeans.modules.php.editor.completion.PHPCompletionItem;
import org.netbeans.modules.php.editor.completion.PHPCompletionResult;
import org.netbeans.modules.php.editor.completion.PHPDOCCodeCompletion;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.elements.VariableElementImpl;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ArrowFunctionScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.ParameterInfoSupport;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.options.CodeCompletionPanel;
import org.netbeans.modules.php.editor.options.OptionsUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class PHPCodeCompletion
implements CodeCompletionHandler2 {
    static volatile PhpVersion PHP_VERSION = null;
    private static final Logger LOGGER = Logger.getLogger(PHPCodeCompletion.class.getName());
    static final Map<String, CompletionContextFinder.KeywordCompletionType> PHP_KEYWORDS = new HashMap<String, CompletionContextFinder.KeywordCompletionType>();
    private static final String[] PHP_LANGUAGE_CONSTRUCTS_WITH_QUOTES;
    private static final String[] PHP_LANGUAGE_CONSTRUCTS_WITH_PARENTHESES;
    private static final String[] PHP_LANGUAGE_CONSTRUCTS_WITH_SEMICOLON;
    static final String PHP_CLASS_KEYWORD_THIS = "$this->";
    static final String[] PHP_CLASS_KEYWORDS;
    static final String[] PHP_STATIC_CLASS_KEYWORDS;
    static final List<String> PHP_GLOBAL_CONST_KEYWORDS;
    static final List<String> PHP_CLASS_CONST_KEYWORDS;
    static final List<String> PHP_ATTRIBUTE_EXPRESSION_KEYWORDS;
    private static final List<String> PHP_MATCH_EXPRESSION_KEYWORDS;
    private static final List<String> PHP_VISIBILITY_KEYWORDS;
    private static final List<String> PHP_SET_VISIBILITY_KEYWORDS;
    private static final List<String> PHP_ASYMMETRIC_VISIBILITY_KEYWORDS;
    private static final Collection<Character> AUTOPOPUP_STOP_CHARS;
    private static final Collection<PHPTokenId> TOKENS_TRIGGERING_AUTOPUP_TYPES_WS;
    private static final List<String> INVALID_PROPOSALS_FOR_CLS_MEMBERS;
    private static final List<String> CLASS_CONTEXT_KEYWORD_PROPOSAL;
    private static final List<String> INTERFACE_CONTEXT_KEYWORD_PROPOSAL;
    private static final List<String> INHERITANCE_KEYWORDS;
    private static final String EXCEPTION_CLASS_NAME = "\\Exception";
    private static final String ERROR_CLASS_NAME = "\\Error";
    private static final String THROWABLE_INTERFACE_NAME = "\\Throwable";
    private static final List<PHPTokenId> VALID_UNION_TYPE_TOKENS;
    private static final List<PHPTokenId> VALID_INTERSECTION_TYPE_TOKENS;
    private static final List<PHPTokenId> TYPE_TOKENS;
    private boolean caseSensitive;
    private QuerySupport.Kind nameKind;

    public CodeCompletionResult complete(CodeCompletionContext completionContext) {
        String searchPrefix;
        String prefixUntilCaret;
        BaseDocument doc;
        long startTime = 0L;
        if (LOGGER.isLoggable(Level.FINE)) {
            startTime = System.currentTimeMillis();
        }
        if ((doc = (BaseDocument)completionContext.getParserResult().getSnapshot().getSource().getDocument(false)) == null) {
            return CodeCompletionResult.NONE;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return CodeCompletionResult.NONE;
        }
        PHPCompletionResult completionResult = new PHPCompletionResult(completionContext);
        ParserResult info = completionContext.getParserResult();
        int caretOffset = completionContext.getCaretOffset();
        this.caseSensitive = completionContext.isCaseSensitive();
        this.nameKind = this.caseSensitive ? QuerySupport.Kind.PREFIX : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX;
        PHPParseResult result = (PHPParseResult)info;
        if (result.getProgram() == null) {
            return CodeCompletionResult.NONE;
        }
        FileObject fileObject = result.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return CodeCompletionResult.NONE;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return CodeCompletionResult.NONE;
        }
        CompletionContextFinder.CompletionContext context = CompletionContextFinder.findCompletionContext(info, caretOffset);
        LOGGER.log(Level.FINE, "CC context: {0}", (Object)context);
        if (context == CompletionContextFinder.CompletionContext.NONE) {
            return CodeCompletionResult.NONE;
        }
        PHPCompletionItem.CompletionRequest request = new PHPCompletionItem.CompletionRequest();
        request.context = context;
        CodeCompletionHandler.QueryType queryType = completionContext.getQueryType();
        boolean upToOffset = queryType != CodeCompletionHandler.QueryType.DOCUMENTATION;
        String prefix = this.getPrefix(info, caretOffset, upToOffset, PrefixBreaker.WITH_NS_PARTS);
        String string = prefixUntilCaret = upToOffset ? prefix : this.getPrefix(info, caretOffset, true, PrefixBreaker.WITH_NS_PARTS);
        if (prefix == null || prefixUntilCaret == null || queryType == CodeCompletionHandler.QueryType.DOCUMENTATION && prefix.isEmpty()) {
            return CodeCompletionResult.NONE;
        }
        prefix = prefix.trim().isEmpty() ? completionContext.getPrefix() : prefix;
        switch (context) {
            case GROUP_USE_KEYWORD: 
            case GROUP_USE_CONST_KEYWORD: 
            case GROUP_USE_FUNCTION_KEYWORD: {
                searchPrefix = this.getPrefix(info, this.findBaseNamespaceEnd(info, caretOffset), true, PrefixBreaker.WITH_NS_PARTS);
                break;
            }
            case EXPRESSION: {
                if (prefix.startsWith("@")) {
                    prefix = prefix.substring(1);
                }
            }
            default: {
                searchPrefix = null;
            }
        }
        request.extraPrefix = searchPrefix;
        int prefixLengthForAnchor = upToOffset ? prefix.length() : prefixUntilCaret.length();
        request.anchor = caretOffset - prefixLengthForAnchor;
        request.result = result;
        request.info = info;
        request.prefix = prefix;
        request.index = ElementQueryFactory.getIndexQuery(info);
        request.currentlyEditedFileURL = fileObject.toURL().toString();
        if (CancelSupport.getDefault().isCancelled()) {
            return CodeCompletionResult.NONE;
        }
        switch (context) {
            case DEFAULT_PARAMETER_VALUE: {
                NameKind.CaseInsensitivePrefix nameKindPrefix = NameKind.caseInsensitivePrefix(request.prefix);
                this.autoCompleteKeywords(completionResult, request, Arrays.asList("array", "new"));
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteTypeNames(completionResult, request, null, true);
                if (CancelSupport.getDefault().isCancelled()) {
                    return CodeCompletionResult.NONE;
                }
                ElementFilter forName = ElementFilter.forName(nameKindPrefix);
                Model model = request.result.getModel();
                Set<AliasedName> aliasedNames = ModelUtils.getAliasedNames(model, request.anchor);
                Set<ConstantElement> constants = request.index.getConstants(nameKindPrefix, aliasedNames, AliasedElement.Trait.ALIAS);
                for (ConstantElement constant : forName.filter(constants)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return CodeCompletionResult.NONE;
                    }
                    completionResult.add(new PHPCompletionItem.ConstantItem(constant, request));
                }
                EnclosingClass enclosingClass = PHPCodeCompletion.findEnclosingClass(request.info, CompletionContextFinder.lexerToASTOffset(request.result, request.anchor));
                if (enclosingClass == null) break;
                String clsName = enclosingClass.getClassName();
                for (String classKeyword : PHP_STATIC_CLASS_KEYWORDS) {
                    if (!classKeyword.toLowerCase().startsWith(request.prefix)) continue;
                    completionResult.add(new PHPCompletionItem.ClassScopeKeywordItem(clsName, classKeyword, request));
                }
                break;
            }
            case NAMESPACE_KEYWORD: {
                if (CancelSupport.getDefault().isCancelled()) {
                    return CodeCompletionResult.NONE;
                }
                Set<NamespaceElement> namespaces = request.index.getNamespaces(NameKind.caseInsensitivePrefix(QualifiedName.create(request.prefix).toNotFullyQualified()));
                for (NamespaceElement namespace : namespaces) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return CodeCompletionResult.NONE;
                    }
                    completionResult.add(new PHPCompletionItem.NamespaceItem(namespace, request, QualifiedNameKind.QUALIFIED));
                }
                break;
            }
            case GLOBAL: {
                this.autoCompleteGlobals(completionResult, request);
                break;
            }
            case MATCH_EXPRESSION: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteExpression(completionResult, request, PHP_MATCH_EXPRESSION_KEYWORDS);
                break;
            }
            case ATTRIBUTE: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteAttribute(completionResult, request);
                break;
            }
            case ATTRIBUTE_EXPRESSION: {
                this.autoCompleteAttributeExpression(completionResult, request);
                break;
            }
            case EXPRESSION: {
                this.autoCompleteExpression(completionResult, request);
                break;
            }
            case CONSTRUCTOR_PARAMETER_NAME: {
                this.autoCompleteConstructorParameterName(completionResult, request);
                break;
            }
            case CLASS_MEMBER_PARAMETER_NAME: {
                this.autoCompleteExpression(completionResult, request);
                this.autoCompleteClassMethodParameterName(completionResult, request, false);
                break;
            }
            case STATIC_CLASS_MEMBER_PARAMETER_NAME: {
                this.autoCompleteExpression(completionResult, request);
                this.autoCompleteClassMethodParameterName(completionResult, request, true);
                break;
            }
            case FUNCTION_PARAMETER_NAME: {
                this.autoCompleteExpression(completionResult, request);
                this.autoCompleteFunctionParameterName(completionResult, request);
                break;
            }
            case GLOBAL_CONST_EXPRESSION: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteTypeNames(completionResult, request, null, true);
                this.autoCompleteConstants(completionResult, request);
                this.autoCompleteKeywords(completionResult, request, PHP_GLOBAL_CONST_KEYWORDS);
                break;
            }
            case CLASS_CONST_EXPRESSION: 
            case ENUM_CASE_EXPRESSION: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteTypeNames(completionResult, request, null, true);
                this.autoCompleteConstants(completionResult, request);
                this.autoCompleteKeywords(completionResult, request, PHP_CLASS_CONST_KEYWORDS);
                if (request.prefix.contains("\\")) break;
                this.autoCompleteClassConstants(completionResult, request);
                break;
            }
            case HTML: 
            case OPEN_TAG: {
                completionResult.add(new PHPCompletionItem.TagItem("<?php", 1, request));
                completionResult.add(new PHPCompletionItem.TagItem("<?=", 2, request));
                break;
            }
            case NEW_CLASS: {
                this.autoCompleteKeywords(completionResult, request, Arrays.asList("class"));
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteNewClass(completionResult, request);
                break;
            }
            case CLASS_NAME: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteClassNames(completionResult, request, false);
                break;
            }
            case INTERFACE_NAME: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteInterfaceNames(completionResult, request);
                break;
            }
            case BACKING_TYPE: {
                List<String> backingTypes = Type.getTypesForBackingType();
                for (String keyword : backingTypes) {
                    if (!this.startsWith(keyword, request.prefix)) continue;
                    completionResult.add(new PHPCompletionItem.KeywordItem(keyword, request));
                }
                break;
            }
            case GROUP_USE_KEYWORD: {
                this.autoCompleteGroupUse(UseType.TYPE, completionResult, request);
                List<String> keywords = Arrays.asList("const", "function");
                for (String keyword : keywords) {
                    if (!this.startsWith(keyword, request.prefix)) continue;
                    completionResult.add(new PHPCompletionItem.KeywordItem(keyword, request));
                }
                break;
            }
            case GROUP_USE_CONST_KEYWORD: {
                this.autoCompleteGroupUse(UseType.CONST, completionResult, request);
                break;
            }
            case GROUP_USE_FUNCTION_KEYWORD: {
                this.autoCompleteGroupUse(UseType.FUNCTION, completionResult, request);
                break;
            }
            case USE_KEYWORD: {
                CodeStyle codeStyle = CodeStyle.get(request.result.getSnapshot().getSource().getDocument(this.caseSensitive));
                this.autoCompleteAfterUse(UseType.TYPE, completionResult, request, codeStyle.startUseWithNamespaceSeparator() ? QualifiedNameKind.FULLYQUALIFIED : QualifiedNameKind.QUALIFIED);
                break;
            }
            case USE_CONST_KEYWORD: {
                CodeStyle codeStyle = CodeStyle.get(request.result.getSnapshot().getSource().getDocument(this.caseSensitive));
                this.autoCompleteAfterUse(UseType.CONST, completionResult, request, codeStyle.startUseWithNamespaceSeparator() ? QualifiedNameKind.FULLYQUALIFIED : QualifiedNameKind.QUALIFIED);
                break;
            }
            case USE_FUNCTION_KEYWORD: {
                CodeStyle codeStyle = CodeStyle.get(request.result.getSnapshot().getSource().getDocument(this.caseSensitive));
                this.autoCompleteAfterUse(UseType.FUNCTION, completionResult, request, codeStyle.startUseWithNamespaceSeparator() ? QualifiedNameKind.FULLYQUALIFIED : QualifiedNameKind.QUALIFIED);
                break;
            }
            case USE_TRAITS: {
                CodeStyle codeStyle = CodeStyle.get(request.result.getSnapshot().getSource().getDocument(this.caseSensitive));
                this.autoCompleteAfterUseTrait(completionResult, request, codeStyle.startUseWithNamespaceSeparator() ? QualifiedNameKind.FULLYQUALIFIED : QualifiedNameKind.QUALIFIED);
                break;
            }
            case VISIBILITY_MODIFIER_OR_TYPE_NAME: {
                this.autoCompleteKeywords(completionResult, request, PHP_VISIBILITY_KEYWORDS);
                this.autoCompleteKeywords(completionResult, request, PHP_SET_VISIBILITY_KEYWORDS);
                this.autoCompleteKeywords(completionResult, request, Arrays.asList("readonly"));
            }
            case TYPE_NAME: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteTypeNames(completionResult, request);
                if (PHPCodeCompletion.isIntersectionType(info, caretOffset)) break;
                ArrayList<String> typesForTypeName = new ArrayList<String>(Type.getTypesForEditor());
                if (PHPCodeCompletion.isInType(request)) {
                    typesForTypeName.addAll(Type.getSpecialTypesForType());
                }
                if (PHPCodeCompletion.isNullableType(info, caretOffset)) {
                    typesForTypeName.remove("null");
                }
                if (PHPCodeCompletion.isUnionType(info, caretOffset)) {
                    typesForTypeName.remove("mixed");
                }
                this.autoCompleteKeywords(completionResult, request, typesForTypeName);
                break;
            }
            case RETURN_UNION_OR_INTERSECTION_TYPE_NAME: 
            case RETURN_TYPE_NAME: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteTypeNames(completionResult, request);
                if (PHPCodeCompletion.isIntersectionType(info, caretOffset)) break;
                ArrayList<String> typesForReturnTypeName = new ArrayList<String>(Type.getTypesForReturnType());
                if (PHPCodeCompletion.isInType(request)) {
                    typesForReturnTypeName.addAll(Type.getSpecialTypesForType());
                    typesForReturnTypeName.add("static");
                }
                if (PHPCodeCompletion.isNullableType(info, caretOffset)) {
                    typesForReturnTypeName.remove("null");
                    typesForReturnTypeName.remove("void");
                    typesForReturnTypeName.remove("never");
                } else if (context == CompletionContextFinder.CompletionContext.RETURN_UNION_OR_INTERSECTION_TYPE_NAME) {
                    typesForReturnTypeName.remove("void");
                    typesForReturnTypeName.remove("never");
                    typesForReturnTypeName.remove("mixed");
                }
                this.autoCompleteKeywords(completionResult, request, typesForReturnTypeName);
                break;
            }
            case FIELD_TYPE_NAME: {
                this.autoCompleteFieldType(info, caretOffset, completionResult, request, false);
                break;
            }
            case CONST_TYPE_NAME: {
                if (!PHPCodeCompletion.isInType(request)) break;
                this.autoCompleteConstType(info, caretOffset, completionResult, request);
                break;
            }
            case STRING: {
                String className;
                EnclosingClass enclosingCls;
                completionResult.addAll(this.getVariableProposals(request, null));
                if (request.prefix.length() != 0 && !this.startsWith(PHP_CLASS_KEYWORD_THIS, request.prefix) || (enclosingCls = PHPCodeCompletion.findEnclosingClass(info, caretOffset)) == null || (className = enclosingCls.extractClassName()) == null) break;
                completionResult.add(new PHPCompletionItem.ClassScopeKeywordItem(className, PHP_CLASS_KEYWORD_THIS, request));
                break;
            }
            case CLASS_MEMBER: {
                this.autoCompleteClassMembers(completionResult, request, false);
                break;
            }
            case STATIC_CLASS_MEMBER: {
                this.autoCompleteClassMembers(completionResult, request, true);
                break;
            }
            case PHPDOC: {
                PHPDOCCodeCompletion.complete(completionResult, request);
                if (!PHPDOCCodeCompletion.isTypeCtx(request)) break;
                this.autoCompleteTypeNames(completionResult, request);
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteKeywordsInPHPDoc(completionResult, request);
                break;
            }
            case CLASS_CONTEXT_KEYWORDS: {
                this.autoCompleteInClassContext(info, caretOffset, completionResult, request);
                break;
            }
            case INTERFACE_CONTEXT_KEYWORDS: {
                this.autoCompleteInInterfaceContext(completionResult, request);
                break;
            }
            case METHOD_NAME: {
                this.autoCompleteMethodName(info, caretOffset, completionResult, request);
                break;
            }
            case IMPLEMENTS: {
                this.autoCompleteKeywords(completionResult, request, Collections.singletonList("implements"));
                break;
            }
            case EXTENDS: {
                this.autoCompleteKeywords(completionResult, request, Collections.singletonList("extends"));
                break;
            }
            case INHERITANCE: {
                this.autoCompleteKeywords(completionResult, request, INHERITANCE_KEYWORDS);
                break;
            }
            case THROW_NEW: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteExceptions(completionResult, request, true);
                break;
            }
            case THROW: {
                this.autoCompleteKeywords(completionResult, request, Collections.singletonList("new"));
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteExceptions(completionResult, request, false);
                break;
            }
            case CATCH: {
                this.autoCompleteNamespaces(completionResult, request);
                this.autoCompleteExceptions(completionResult, request, false);
                break;
            }
            case CLASS_MEMBER_IN_STRING: {
                this.autoCompleteClassFields(completionResult, request);
                break;
            }
            case SERVER_ENTRY_CONSTANTS: {
                for (String keyword : PredefinedSymbols.SERVER_ENTRY_CONSTANTS) {
                    if (!keyword.startsWith(request.prefix)) continue;
                    completionResult.add(new PHPCompletionItem.KeywordItem(keyword, request){

                        @Override
                        public ImageIcon getIcon() {
                            return null;
                        }
                    });
                }
                break;
            }
            default: {
                assert (false) : context;
                break;
            }
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return CodeCompletionResult.NONE;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            long time = System.currentTimeMillis() - startTime;
            LOGGER.fine(String.format("complete() took %d ms, result contains %d items", time, completionResult.getItems().size()));
        }
        return completionResult;
    }

    private List<ElementFilter> createTypeFilter(EnclosingClass enclosingClass) {
        ArrayList<ElementFilter> superTypeIndices = new ArrayList<ElementFilter>();
        Expression superClass = enclosingClass.getSuperClass();
        if (superClass != null) {
            String superClsName = enclosingClass.extractUnqualifiedSuperClassName();
            superTypeIndices.add(ElementFilter.forSuperClassName(QualifiedName.create(superClsName)));
        }
        List<Expression> interfaces = enclosingClass.getInterfaces();
        HashSet<QualifiedName> superIfaceNames = new HashSet<QualifiedName>();
        for (Expression identifier : interfaces) {
            String ifaceName = CodeUtils.extractUnqualifiedName(identifier);
            if (ifaceName == null) continue;
            superIfaceNames.add(QualifiedName.create(ifaceName));
        }
        if (!superIfaceNames.isEmpty()) {
            superTypeIndices.add(ElementFilter.forSuperInterfaceNames(superIfaceNames));
        }
        return superTypeIndices;
    }

    private void autoCompleteMethodName(ParserResult info, int caretOffset, PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        EnclosingClass enclosingClass = PHPCodeCompletion.findEnclosingClass(info, CompletionContextFinder.lexerToASTOffset(info, caretOffset));
        if (enclosingClass != null) {
            NamespaceScope namespaceScope;
            List<ElementFilter> superTypeIndices = this.createTypeFilter(enclosingClass);
            String clsName = enclosingClass.getClassName();
            String fullyQualifiedClassName = VariousUtils.qualifyTypeNames(clsName, request.anchor, namespaceScope = ModelUtils.getNamespaceScope(request.result.getModel().getFileScope(), request.anchor));
            if (fullyQualifiedClassName != null) {
                FileObject fileObject = request.result.getSnapshot().getSource().getFileObject();
                ElementFilter typeFilter = ElementFilter.allOf(ElementFilter.forFiles(fileObject), ElementFilter.allOf(superTypeIndices));
                Set<TypeElement> types = typeFilter.filter(request.index.getTypes(NameKind.exact(fullyQualifiedClassName)));
                Iterator<TypeElement> iterator = types.iterator();
                if (iterator.hasNext()) {
                    TypeElement typeElement = iterator.next();
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    ElementFilter methodFilter = ElementFilter.allOf(ElementFilter.forExcludedNames(PHPCodeCompletion.toNames(request.index.getDeclaredMethods(typeElement)), PhpElementKind.METHOD), ElementFilter.forName(NameKind.caseInsensitivePrefix(QualifiedName.create(request.prefix))));
                    Set<MethodElement> accessibleMethods = methodFilter.filter(request.index.getAccessibleMethods(typeElement, typeElement));
                    for (MethodElement method : accessibleMethods) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (method.isFinal()) continue;
                        completionResult.add(PHPCompletionItem.MethodDeclarationItem.forMethodName(method, request));
                    }
                    Set<MethodElement> magicMethods = methodFilter.filter(request.index.getAccessibleMagicMethods(typeElement));
                    for (MethodElement magicMethod : magicMethods) {
                        if (magicMethod == null) continue;
                        completionResult.add(PHPCompletionItem.MethodDeclarationItem.forMethodName(magicMethod, request));
                    }
                }
            }
        }
    }

    private void autoCompleteNewClass(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        Model model;
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        QualifiedName prefix = QualifiedName.create(request.prefix).toNotFullyQualified();
        NameKind nameQuery = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        Set<ClassElement> classes = request.index.getClasses(nameQuery, ModelUtils.getAliasedNames(model = request.result.getModel(), request.anchor), AliasedElement.Trait.ALIAS);
        if (!classes.isEmpty()) {
            completionResult.setFilterable(false);
        }
        boolean addedExact = false;
        if (classes.size() == 1) {
            ClassElement clazz = (ClassElement)classes.toArray()[0];
            if (!clazz.isAbstract() && !clazz.isAnonymous()) {
                NameKind.CaseInsensitivePrefix query = isCamelCase ? NameKind.create(prefix.toString(), QuerySupport.Kind.CAMEL_CASE) : NameKind.caseInsensitivePrefix(prefix);
                this.autoCompleteConstructors(completionResult, request, model, query);
            }
        } else {
            for (ClassElement clazz : classes) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (clazz.isAbstract() || clazz.isAnonymous()) continue;
                NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(request.result.getModel().getFileScope(), request.anchor);
                String fqPrefixName = VariousUtils.qualifyTypeNames(request.prefix, request.anchor, namespaceScope);
                if (clazz.getFullyQualifiedName().toString().equals(fqPrefixName)) {
                    if (addedExact) continue;
                    this.autoCompleteConstructors(completionResult, request, model, NameKind.exact(fqPrefixName));
                    addedExact = true;
                    continue;
                }
                completionResult.add(new PHPCompletionItem.ClassItem(clazz, request, false, null));
            }
        }
    }

    private void autoCompleteAttribute(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        Model model;
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind nameQuery = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        Set<ClassElement> attributeClasses = request.index.getAttributeClasses(nameQuery, ModelUtils.getAliasedNames(model = request.result.getModel(), request.anchor), AliasedElement.Trait.ALIAS);
        if (!attributeClasses.isEmpty()) {
            completionResult.setFilterable(false);
        }
        for (ClassElement attributeClass : attributeClasses) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (attributeClass.isAbstract() || attributeClass.isAnonymous()) continue;
            completionResult.add(new PHPCompletionItem.ClassItem(attributeClass, request, false, null));
            NameKind exactQuery = NameKind.create(attributeClass.getFullyQualifiedName(), QuerySupport.Kind.EXACT);
            this.autoCompleteConstructors(completionResult, request, model, exactQuery, true);
        }
    }

    private void autoCompleteConstructors(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, Model model, NameKind query) {
        this.autoCompleteConstructors(completionResult, request, model, query, false);
    }

    private void autoCompleteConstructors(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, Model model, NameKind query, boolean isAttributeClass) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Set<AliasedName> aliasedNames = ModelUtils.getAliasedNames(model, request.anchor);
        Set<MethodElement> constructors = isAttributeClass ? request.index.getAttributeClassConstructors(query, aliasedNames, AliasedElement.Trait.ALIAS) : request.index.getConstructors(query, aliasedNames, AliasedElement.Trait.ALIAS);
        for (MethodElement constructor : constructors) {
            for (PHPCompletionItem.NewClassItem newClassItem : PHPCompletionItem.NewClassItem.getNewClassItems(constructor, request)) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                completionResult.add(newClassItem);
            }
        }
    }

    private void autoCompleteExceptions(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean withConstructors) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind nameQuery = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        Set<ClassElement> classes = request.index.getClasses(nameQuery);
        Model model = request.result.getModel();
        HashSet<QualifiedName> constructorClassNames = new HashSet<QualifiedName>();
        block0: for (ClassElement classElement : classes) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.isExceptionClass(classElement) || this.isErrorClass(classElement)) {
                completionResult.add(new PHPCompletionItem.ClassItem(classElement, request, false, null));
                if (!withConstructors) continue;
                constructorClassNames.add(classElement.getFullyQualifiedName());
                continue;
            }
            if (classElement.getSuperClassName() == null) continue;
            Set<ClassElement> inheritedClasses = request.index.getInheritedClasses(classElement);
            for (ClassElement inheritedClass : inheritedClasses) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (!this.isExceptionClass(inheritedClass) && !this.isErrorClass(inheritedClass)) continue;
                completionResult.add(new PHPCompletionItem.ClassItem(classElement, request, false, null));
                if (!withConstructors) continue block0;
                constructorClassNames.add(classElement.getFullyQualifiedName());
                continue block0;
            }
        }
        Set<InterfaceElement> interfaces = request.index.getInterfaces(nameQuery);
        for (InterfaceElement interfaceElement : interfaces) {
            if (!this.isThrowableInterface(interfaceElement)) continue;
            completionResult.add(new PHPCompletionItem.InterfaceItem(interfaceElement, request, false));
            break;
        }
        for (QualifiedName qualifiedName : constructorClassNames) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.autoCompleteConstructors(completionResult, request, model, NameKind.exact(qualifiedName));
        }
    }

    private boolean isExceptionClass(ClassElement classElement) {
        return classElement.getFullyQualifiedName().toString().equals(EXCEPTION_CLASS_NAME);
    }

    private boolean isErrorClass(ClassElement classElement) {
        return classElement.getFullyQualifiedName().toString().equals(ERROR_CLASS_NAME);
    }

    private boolean isThrowableInterface(InterfaceElement interfaceElement) {
        return interfaceElement.getFullyQualifiedName().toString().equals(THROWABLE_INTERFACE_NAME);
    }

    private void autoCompleteClassNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean endWithDoubleColon) {
        this.autoCompleteClassNames(completionResult, request, endWithDoubleColon, null);
    }

    private void autoCompleteClassNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean endWithDoubleColon, QualifiedNameKind kind) {
        Model model;
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind nameQuery = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        Set<ClassElement> classes = request.index.getClasses(nameQuery, ModelUtils.getAliasedNames(model = request.result.getModel(), request.anchor), AliasedElement.Trait.ALIAS);
        if (!classes.isEmpty()) {
            completionResult.setFilterable(false);
        }
        for (ClassElement clazz : classes) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (clazz.isAnonymous()) continue;
            completionResult.add(new PHPCompletionItem.ClassItem(clazz, request, endWithDoubleColon, kind));
        }
    }

    private void autoCompleteEnumNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean endWithDoubleColon) {
        this.autoCompleteEnumNames(completionResult, request, endWithDoubleColon, null);
    }

    private void autoCompleteEnumNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean endWithDoubleColon, QualifiedNameKind kind) {
        Model model;
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind nameQuery = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        Set<EnumElement> enums = request.index.getEnums(nameQuery, ModelUtils.getAliasedNames(model = request.result.getModel(), request.anchor), AliasedElement.Trait.ALIAS);
        if (!enums.isEmpty()) {
            completionResult.setFilterable(false);
        }
        for (EnumElement enumElement : enums) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            completionResult.add(new PHPCompletionItem.EnumItem(enumElement, request, endWithDoubleColon, kind));
        }
    }

    private void autoCompleteInterfaceNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        this.autoCompleteInterfaceNames(completionResult, request, null);
    }

    private void autoCompleteInterfaceNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, QualifiedNameKind kind) {
        Model model;
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind nameQuery = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        Set<InterfaceElement> interfaces = request.index.getInterfaces(nameQuery, ModelUtils.getAliasedNames(model = request.result.getModel(), request.anchor), AliasedElement.Trait.ALIAS);
        if (!interfaces.isEmpty()) {
            completionResult.setFilterable(false);
        }
        for (InterfaceElement iface : interfaces) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            completionResult.add(new PHPCompletionItem.InterfaceItem(iface, request, kind, false));
        }
    }

    private void autoCompleteTypeNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        this.autoCompleteTypeNames(completionResult, request, null, false);
    }

    private void autoCompleteAfterUseTrait(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, QualifiedNameKind kind) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Set<NamespaceElement> namespaces = request.index.getNamespaces(NameKind.caseInsensitivePrefix(QualifiedName.create(request.prefix).toNotFullyQualified()));
        for (NamespaceElement namespace : namespaces) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            completionResult.add(new PHPCompletionItem.NamespaceItem(namespace, request, QualifiedNameKind.FULLYQUALIFIED));
        }
        NameKind.CaseInsensitivePrefix nameQuery = NameKind.caseInsensitivePrefix(request.prefix);
        Model model = request.result.getModel();
        Set<TraitElement> traits = request.index.getTraits(nameQuery, ModelUtils.getAliasedNames(model, request.anchor), AliasedElement.Trait.ALIAS);
        for (TraitElement trait : traits) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            completionResult.add(new PHPCompletionItem.TraitItem(trait, request));
        }
    }

    private void autoCompleteGroupUse(UseType useType, PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        assert (request.extraPrefix != null);
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        request.insertOnlyMethodsName = true;
        if (!request.extraPrefix.startsWith("\\")) {
            request.extraPrefix = "\\" + request.extraPrefix;
        }
        String prefix = request.extraPrefix + request.prefix;
        Set<NamespaceElement> namespaces = request.index.getNamespaces(NameKind.caseInsensitivePrefix(QualifiedName.create(prefix).toNotFullyQualified()));
        for (NamespaceElement namespace : namespaces) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            completionResult.add(new PHPCompletionItem.NamespaceItem(namespace, request, QualifiedNameKind.FULLYQUALIFIED));
        }
        NameKind.CaseInsensitivePrefix nameQuery = NameKind.caseInsensitivePrefix(prefix);
        switch (useType.ordinal()) {
            case 0: {
                for (ClassElement clazz : request.index.getClasses(nameQuery)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    completionResult.add(new PHPCompletionItem.ClassItem(clazz, request, false, QualifiedNameKind.FULLYQUALIFIED));
                }
                for (InterfaceElement iface : request.index.getInterfaces(nameQuery)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    completionResult.add(new PHPCompletionItem.InterfaceItem(iface, request, QualifiedNameKind.FULLYQUALIFIED, false));
                }
                for (TraitElement trait : request.index.getTraits(nameQuery)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    completionResult.add(new PHPCompletionItem.TraitItem(trait, request));
                }
                break;
            }
            case 1: {
                for (ConstantElement constant : request.index.getConstants(nameQuery)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    completionResult.add(new PHPCompletionItem.ConstantItem(constant, request, QualifiedNameKind.FULLYQUALIFIED));
                }
                break;
            }
            case 2: {
                for (FunctionElement function : request.index.getFunctions(nameQuery)) {
                    for (PHPCompletionItem.FunctionElementItem item : PHPCompletionItem.FunctionElementItem.getItems(function, request, QualifiedNameKind.FULLYQUALIFIED)) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        completionResult.add(item);
                    }
                }
                break;
            }
            default: {
                assert (false) : "Unknown use type: " + String.valueOf((Object)useType);
                break;
            }
        }
    }

    private void autoCompleteAfterUse(UseType useType, PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, QualifiedNameKind kind) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Set<NamespaceElement> namespaces = request.index.getNamespaces(NameKind.caseInsensitivePrefix(QualifiedName.create(request.prefix).toNotFullyQualified()));
        for (NamespaceElement namespace : namespaces) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            completionResult.add(new PHPCompletionItem.NamespaceItem(namespace, request, kind));
        }
        NameKind.CaseInsensitivePrefix nameQuery = NameKind.caseInsensitivePrefix(request.prefix);
        switch (useType.ordinal()) {
            case 0: {
                for (ClassElement clazz : request.index.getClasses(nameQuery)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    completionResult.add(new PHPCompletionItem.ClassItem(clazz, request, false, kind));
                }
                for (InterfaceElement iface : request.index.getInterfaces(nameQuery)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    completionResult.add(new PHPCompletionItem.InterfaceItem(iface, request, kind, false));
                }
                for (TraitElement trait : request.index.getTraits(nameQuery)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    completionResult.add(new PHPCompletionItem.TraitItem(trait, request));
                }
                for (EnumElement enumElement : request.index.getEnums(nameQuery)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    completionResult.add(new PHPCompletionItem.EnumItem(enumElement, request, false, kind));
                }
                break;
            }
            case 1: {
                for (ConstantElement constant : request.index.getConstants(nameQuery)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    completionResult.add(new PHPCompletionItem.ConstantItem(constant, request));
                }
                break;
            }
            case 2: {
                for (FunctionElement function : request.index.getFunctions(nameQuery)) {
                    List<PHPCompletionItem.FunctionElementItem> items = PHPCompletionItem.FunctionElementItem.getItems(function, request);
                    for (PHPCompletionItem.FunctionElementItem item : items) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        completionResult.add(item);
                    }
                }
                break;
            }
            default: {
                assert (false) : "Unknown use type: " + String.valueOf((Object)useType);
                break;
            }
        }
    }

    private void autoCompleteTypeNames(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, QualifiedNameKind kind, boolean endWithDoubleColon) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        if (request.prefix.trim().length() > 0) {
            this.autoCompleteClassNames(completionResult, request, endWithDoubleColon, kind);
            this.autoCompleteEnumNames(completionResult, request, endWithDoubleColon, kind);
            this.autoCompleteInterfaceNames(completionResult, request, kind);
        } else {
            Model model = request.result.getModel();
            Set<AliasedName> aliasedNames = ModelUtils.getAliasedNames(model, request.anchor);
            Set<PhpElement> allTopLevel = request.index.getTopLevelElements(NameKind.empty(), aliasedNames, AliasedElement.Trait.ALIAS);
            for (PhpElement element : allTopLevel) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (element instanceof ClassElement) {
                    ClassElement classElement = (ClassElement)element;
                    if (classElement.isAnonymous()) continue;
                    completionResult.add(new PHPCompletionItem.ClassItem(classElement, request, endWithDoubleColon, kind));
                    continue;
                }
                if (element instanceof InterfaceElement) {
                    completionResult.add(new PHPCompletionItem.InterfaceItem((InterfaceElement)element, request, kind, endWithDoubleColon));
                    continue;
                }
                if (!(element instanceof EnumElement)) continue;
                EnumElement enumElement = (EnumElement)element;
                completionResult.add(new PHPCompletionItem.EnumItem(enumElement, request, endWithDoubleColon, kind));
            }
        }
    }

    private void autoCompleteKeywords(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, List<String> keywordList) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        for (String keyword : keywordList) {
            if (!keyword.startsWith(request.prefix)) continue;
            completionResult.add(new PHPCompletionItem.KeywordItem(keyword, request));
        }
    }

    private void autoCompleteKeywordsInPHPDoc(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        BaseDocument doc = (BaseDocument)request.info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return;
        }
        try {
            int start = request.anchor - 1;
            if (start >= 0) {
                String prefix = doc.getText(start, 1);
                if ("?".equals(prefix)) {
                    ArrayList<String> keywords = new ArrayList<String>(Type.getTypesForEditor());
                    keywords.remove("null");
                    this.autoCompleteKeywords(completionResult, request, keywords);
                } else {
                    this.autoCompleteKeywords(completionResult, request, Type.getTypesForPhpDoc());
                }
            }
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, "Incorrect offset for the nullable type prefix: {0}", ex.offsetRequested());
        }
    }

    private void autoCompleteNamespaces(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        this.autoCompleteNamespaces(completionResult, request, null);
    }

    private void autoCompleteNamespaces(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, QualifiedNameKind kind) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        QualifiedName prefix = QualifiedName.create(request.prefix).toNotFullyQualified();
        Model model = request.result.getModel();
        Set<NamespaceElement> namespaces = request.index.getNamespaces(NameKind.caseInsensitivePrefix(prefix), ModelUtils.getAliasedNames(model, request.anchor), AliasedElement.Trait.ALIAS);
        for (NamespaceElement namespace : namespaces) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            completionResult.add(new PHPCompletionItem.NamespaceItem(namespace, request, kind));
        }
    }

    private void autoCompleteInInterfaceContext(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        this.autoCompleteKeywords(completionResult, request, INTERFACE_CONTEXT_KEYWORD_PROPOSAL);
    }

    private void autoCompleteInClassContext(ParserResult info, int caretOffset, PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        Token token;
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        TokenSequence tokenSequence = th.tokenSequence(PHPTokenId.language());
        assert (tokenSequence != null);
        boolean foundFunction = false;
        boolean foundConst = false;
        tokenSequence.move(caretOffset);
        while (tokenSequence.moveNext() && (token = tokenSequence.token()).id() != PHPTokenId.PHP_LINE_COMMENT && TokenUtilities.indexOf((CharSequence)token.text(), (int)10) == -1) {
            if (token.id() == PHPTokenId.PHP_FUNCTION) {
                foundFunction = true;
                break;
            }
            if (token.id() != PHPTokenId.PHP_CONST) continue;
            foundConst = true;
            break;
        }
        this.autoCompleteKeywords(completionResult, request, CLASS_CONTEXT_KEYWORD_PROPOSAL);
        if (!foundConst && !foundFunction) {
            this.autoCompleteKeywords(completionResult, request, PHP_SET_VISIBILITY_KEYWORDS);
            this.autoCompleteKeywords(completionResult, request, PHP_ASYMMETRIC_VISIBILITY_KEYWORDS);
        }
        if (this.offerMagicAndInherited((TokenSequence<PHPTokenId>)tokenSequence, caretOffset, th)) {
            EnclosingClass enclosingClass = PHPCodeCompletion.findEnclosingClass(info, CompletionContextFinder.lexerToASTOffset(info, caretOffset));
            if (enclosingClass != null) {
                FileObject fileObject;
                ElementFilter typeFilter;
                Set<TypeElement> types;
                Iterator<TypeElement> iterator;
                NamespaceScope namespaceScope;
                List<ElementFilter> superTypeIndices = this.createTypeFilter(enclosingClass);
                String clsName = enclosingClass.getClassName();
                String fullyQualifiedClassName = VariousUtils.qualifyTypeNames(clsName, request.anchor, namespaceScope = ModelUtils.getNamespaceScope(request.result.getModel().getFileScope(), request.anchor));
                if (fullyQualifiedClassName != null && (iterator = (types = (typeFilter = ElementFilter.allOf(ElementFilter.forFiles(fileObject = request.result.getSnapshot().getSource().getFileObject()), ElementFilter.allOf(superTypeIndices))).filter(request.index.getTypes(NameKind.exact(fullyQualifiedClassName)))).iterator()).hasNext()) {
                    TypeElement typeElement = iterator.next();
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    ElementFilter methodFilter = ElementFilter.allOf(ElementFilter.forExcludedNames(PHPCodeCompletion.toNames(request.index.getDeclaredMethods(typeElement)), PhpElementKind.METHOD), ElementFilter.forName(NameKind.caseInsensitivePrefix(QualifiedName.create(request.prefix))));
                    Set<MethodElement> accessibleMethods = methodFilter.filter(request.index.getAccessibleMethods(typeElement, typeElement));
                    for (MethodElement method : accessibleMethods) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (method.isFinal()) continue;
                        completionResult.add(PHPCompletionItem.MethodDeclarationItem.getDeclarationItem(method, request));
                    }
                    Set<MethodElement> magicMethods = methodFilter.filter(request.index.getAccessibleMagicMethods(typeElement));
                    for (MethodElement magicMethod : magicMethods) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (magicMethod == null) continue;
                        completionResult.add(PHPCompletionItem.MethodDeclarationItem.getDeclarationItem(magicMethod, request));
                    }
                }
            }
        } else if (this.completeFieldTypes((TokenSequence<PHPTokenId>)tokenSequence, caretOffset, th, info.getSnapshot().getSource().getFileObject())) {
            request.context = CompletionContextFinder.CompletionContext.FIELD_TYPE_NAME;
            this.autoCompleteFieldType(info, caretOffset, completionResult, request, true);
        }
    }

    private void autoCompleteConstType(ParserResult info, int caretOffset, PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        this.autoCompleteNamespaces(completionResult, request);
        this.autoCompleteTypeNames(completionResult, request);
        if (PHPCodeCompletion.isIntersectionType(info, caretOffset)) {
            return;
        }
        ArrayList<String> keywords = new ArrayList<String>(Type.getTypesForConstType());
        boolean isNullableType = PHPCodeCompletion.isNullableType(info, caretOffset);
        if (isNullableType) {
            keywords.remove("null");
        }
        if (PHPCodeCompletion.isUnionType(info, caretOffset)) {
            keywords.remove("mixed");
        }
        this.autoCompleteKeywords(completionResult, request, keywords);
    }

    private void autoCompleteFieldType(ParserResult info, int caretOffset, PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean isInClassContext) {
        if (!PHPCodeCompletion.isPhp74OrNewer(info.getSnapshot().getSource().getFileObject())) {
            return;
        }
        this.autoCompleteNamespaces(completionResult, request);
        this.autoCompleteTypeNames(completionResult, request);
        if (PHPCodeCompletion.isIntersectionType(info, caretOffset)) {
            return;
        }
        ArrayList<String> keywords = new ArrayList<String>(Type.getTypesForFieldType());
        boolean isNullableType = PHPCodeCompletion.isNullableType(info, caretOffset);
        if (!isInClassContext && !isNullableType) {
            TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
            TokenSequence tokenSequence = th.tokenSequence(PHPTokenId.language());
            assert (tokenSequence != null);
            tokenSequence.move(caretOffset);
            boolean addFinalKeyword = false;
            boolean addStaticKeyword = false;
            boolean addReadonlyKeyword = false;
            boolean addVisibilityKeyword = false;
            boolean addSetVisibilityKeyword = false;
            if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
                Token token = tokenSequence.token();
                int tokenIdOffset = tokenSequence.token().offset(th);
                addFinalKeyword = !CompletionContextFinder.lineContainsAny((Token<PHPTokenId>)token, caretOffset - tokenIdOffset, (TokenSequence<PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.PHP_FINAL, PHPTokenId.PHP_OPERATOR));
                addStaticKeyword = !CompletionContextFinder.lineContainsAny((Token<PHPTokenId>)token, caretOffset - tokenIdOffset, (TokenSequence<PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.PHP_STATIC, PHPTokenId.PHP_READONLY, PHPTokenId.PHP_PUBLIC_SET, PHPTokenId.PHP_PRIVATE_SET, PHPTokenId.PHP_PROTECTED_SET, PHPTokenId.PHP_OPERATOR));
                addReadonlyKeyword = !CompletionContextFinder.lineContainsAny((Token<PHPTokenId>)token, caretOffset - tokenIdOffset, (TokenSequence<PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.PHP_READONLY, PHPTokenId.PHP_OPERATOR));
                addVisibilityKeyword = !CompletionContextFinder.lineContainsAny((Token<PHPTokenId>)token, caretOffset - tokenIdOffset, (TokenSequence<PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.PHP_PUBLIC, PHPTokenId.PHP_PRIVATE, PHPTokenId.PHP_PROTECTED, PHPTokenId.PHP_OPERATOR));
                boolean bl = addSetVisibilityKeyword = !CompletionContextFinder.lineContainsAny((Token<PHPTokenId>)token, caretOffset - tokenIdOffset, (TokenSequence<PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.PHP_PUBLIC_SET, PHPTokenId.PHP_PRIVATE_SET, PHPTokenId.PHP_PROTECTED_SET, PHPTokenId.PHP_STATIC, PHPTokenId.PHP_OPERATOR));
            }
            if (addFinalKeyword) {
                keywords.add("final");
            }
            if (addStaticKeyword) {
                keywords.add("static");
            }
            if (addReadonlyKeyword) {
                keywords.add("readonly");
            }
            if (addVisibilityKeyword) {
                keywords.addAll(PHP_VISIBILITY_KEYWORDS);
            }
            if (addSetVisibilityKeyword) {
                keywords.addAll(PHP_SET_VISIBILITY_KEYWORDS);
            }
            if (addVisibilityKeyword && addSetVisibilityKeyword) {
                keywords.addAll(PHP_ASYMMETRIC_VISIBILITY_KEYWORDS);
            }
        }
        if (isNullableType) {
            keywords.remove("null");
        }
        if (PHPCodeCompletion.isUnionType(info, caretOffset)) {
            keywords.remove("mixed");
        }
        this.autoCompleteKeywords(completionResult, request, keywords);
    }

    private boolean offerMagicAndInherited(TokenSequence<PHPTokenId> tokenSequence, int caretOffset, TokenHierarchy<?> th) {
        boolean offerMagicAndInherited = true;
        tokenSequence.move(caretOffset);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            int tokenIdOffset = tokenSequence.token().offset(th);
            offerMagicAndInherited = !CompletionContextFinder.lineContainsAny((Token<PHPTokenId>)token, caretOffset - tokenIdOffset, tokenSequence, Arrays.asList(PHPTokenId.PHP_PRIVATE, PHPTokenId.PHP_PUBLIC, PHPTokenId.PHP_PROTECTED, PHPTokenId.PHP_PRIVATE_SET, PHPTokenId.PHP_PUBLIC_SET, PHPTokenId.PHP_PROTECTED_SET, PHPTokenId.PHP_FINAL, PHPTokenId.PHP_ABSTRACT, PHPTokenId.PHP_VAR, PHPTokenId.PHP_STATIC, PHPTokenId.PHP_CONST, PHPTokenId.PHP_READONLY));
        }
        return offerMagicAndInherited;
    }

    private boolean completeFieldTypes(TokenSequence<PHPTokenId> tokenSequence, int caretOffset, TokenHierarchy<?> th, FileObject fileObject) {
        if (!PHPCodeCompletion.isPhp74OrNewer(fileObject)) {
            return false;
        }
        boolean completeTypes = false;
        tokenSequence.move(caretOffset);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            int tokenIdOffset = tokenSequence.token().offset(th);
            completeTypes = !CompletionContextFinder.lineContainsAny((Token<PHPTokenId>)token, caretOffset - tokenIdOffset, tokenSequence, Arrays.asList(PHPTokenId.PHP_TYPE_BOOL, PHPTokenId.PHP_TYPE_INT, PHPTokenId.PHP_TYPE_FLOAT, PHPTokenId.PHP_TYPE_STRING, PHPTokenId.PHP_ARRAY, PHPTokenId.PHP_TYPE_OBJECT, PHPTokenId.PHP_ITERABLE, PHPTokenId.PHP_SELF, PHPTokenId.PHP_PARENT, PHPTokenId.PHP_TRUE, PHPTokenId.PHP_FALSE, PHPTokenId.PHP_NULL, PHPTokenId.PHP_STRING, PHPTokenId.PHP_CONST));
        }
        return completeTypes;
    }

    private static Set<String> toNames(Set<? extends PhpElement> elements) {
        HashSet<String> names = new HashSet<String>();
        for (PhpElement phpElement : elements) {
            names.add(phpElement.getName());
        }
        return names;
    }

    private void autoCompleteClassMembers(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean staticContext) {
        this.autoCompleteClassMembers(completionResult, request, staticContext, false);
    }

    private void autoCompleteClassMembers(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean staticContext, boolean completeAccessPrefix) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(th, request.anchor);
        if (tokenSequence == null) {
            return;
        }
        tokenSequence.move(request.anchor);
        if (tokenSequence.movePrevious()) {
            boolean instanceContext;
            boolean bl = instanceContext = !staticContext;
            if (tokenSequence.token().id() != PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM && tokenSequence.token().id() != PHPTokenId.PHP_OBJECT_OPERATOR && tokenSequence.token().id() != PHPTokenId.PHP_NULLSAFE_OBJECT_OPERATOR) {
                tokenSequence.movePrevious();
            }
            tokenSequence.movePrevious();
            if (tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                tokenSequence.movePrevious();
            }
            CharSequence varName = tokenSequence.token().text();
            tokenSequence.moveNext();
            List<String> invalidProposalsForClsMembers = INVALID_PROPOSALS_FOR_CLS_MEMBERS;
            Model model = request.result.getModel();
            boolean parentContext = false;
            boolean selfContext = false;
            boolean staticLateBindingContext = false;
            boolean specialVariable = false;
            if (TokenUtilities.textEquals((CharSequence)varName, (CharSequence)"$this")) {
                specialVariable = true;
            } else if (TokenUtilities.textEquals((CharSequence)varName, (CharSequence)"self")) {
                staticContext = true;
                selfContext = true;
                specialVariable = true;
            } else if (TokenUtilities.textEquals((CharSequence)varName, (CharSequence)"parent")) {
                invalidProposalsForClsMembers = Collections.emptyList();
                staticContext = true;
                instanceContext = true;
                specialVariable = true;
                parentContext = true;
            } else if (TokenUtilities.textEquals((CharSequence)varName, (CharSequence)"static")) {
                staticContext = true;
                instanceContext = false;
                staticLateBindingContext = true;
                specialVariable = true;
            }
            Collection<? extends TypeScope> types = ModelUtils.resolveTypeAfterReferenceToken(model, tokenSequence, request.anchor, specialVariable);
            if (types != null) {
                TypeElement enclosingType = this.getEnclosingType(request, types);
                if (completeAccessPrefix) {
                    types = ModelUtils.resolveType(model, request.anchor);
                }
                HashSet<PhpElement> duplicateElementCheck = new HashSet<PhpElement>();
                for (TypeScope typeScope : types) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    ElementFilter staticFlagFilter = !completeAccessPrefix ? new StaticOrInstanceMembersFilter(staticContext, instanceContext, selfContext, staticLateBindingContext, parentContext) : new ElementFilter(){

                        @Override
                        public boolean isAccepted(PhpElement element) {
                            return true;
                        }
                    };
                    ElementFilter methodsFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.METHOD), ElementFilter.forName(NameKind.caseInsensitivePrefix(request.prefix)), staticFlagFilter, ElementFilter.forExcludedNames(invalidProposalsForClsMembers, PhpElementKind.METHOD), ElementFilter.forInstanceOf(MethodElement.class));
                    ElementFilter fieldsFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.FIELD), ElementFilter.forName(NameKind.caseInsensitivePrefix(request.prefix)), staticFlagFilter, ElementFilter.forInstanceOf(FieldElement.class));
                    ElementFilter constantsFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.TYPE_CONSTANT), ElementFilter.forName(NameKind.caseInsensitivePrefix(request.prefix)), ElementFilter.forInstanceOf(TypeConstantElement.class));
                    ElementFilter enumCasesFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.ENUM_CASE), ElementFilter.forName(NameKind.caseInsensitivePrefix(request.prefix)), ElementFilter.forInstanceOf(EnumCaseElement.class));
                    HashSet<TypeMemberElement> accessibleTypeMembers = new HashSet<TypeMemberElement>();
                    accessibleTypeMembers.addAll(request.index.getAccessibleTypeMembers(typeScope, enclosingType));
                    if (typeScope instanceof ClassElement) {
                        ClassElement classElement = (ClassElement)((Object)typeScope);
                        if (!classElement.getFQMixinClassNames().isEmpty()) {
                            accessibleTypeMembers.addAll(request.index.getAccessibleMixinTypeMembers(typeScope, enclosingType));
                        }
                    } else if (typeScope instanceof EnumElement) {
                        EnumElement enumElement = (EnumElement)((Object)typeScope);
                        String string = enumElement.getBackingType() != null ? enumElement.getBackingType().toString() : "";
                        String enumInterfaceName = !string.isEmpty() ? "\\BackedEnum" : "\\UnitEnum";
                        NameKind.Exact nameQuery = NameKind.exact(QualifiedName.create(enumInterfaceName));
                        Set<InterfaceElement> enums = request.index.getInterfaces(nameQuery);
                        for (InterfaceElement backedEnum : enums) {
                            accessibleTypeMembers.addAll(request.index.getAccessibleTypeMembers(backedEnum, backedEnum));
                        }
                        if (!staticContext && "name".startsWith(request.prefix)) {
                            completionResult.add(PHPCompletionItem.AdditionalFieldItem.getItem("name", "string", enumElement.getFullyQualifiedName().toString(), request));
                        }
                        if (!staticContext && !string.isEmpty() && "value".startsWith(request.prefix)) {
                            completionResult.add(PHPCompletionItem.AdditionalFieldItem.getItem("value", string, enumElement.getFullyQualifiedName().toString(), request));
                        }
                    }
                    for (PhpElement phpElement : accessibleTypeMembers) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (typeScope instanceof TraitScope && !specialVariable && phpElement instanceof TypeConstantElement || !duplicateElementCheck.add(phpElement)) continue;
                        if (methodsFilter.isAccepted(phpElement)) {
                            MethodElement method = (MethodElement)phpElement;
                            List<PHPCompletionItem.MethodElementItem> items = PHPCompletionItem.MethodElementItem.getItems(method, request, completeAccessPrefix);
                            for (PHPCompletionItem.MethodElementItem methodItem : items) {
                                if (CancelSupport.getDefault().isCancelled()) {
                                    return;
                                }
                                completionResult.add(methodItem);
                            }
                            continue;
                        }
                        if (fieldsFilter.isAccepted(phpElement)) {
                            FieldElement field = (FieldElement)phpElement;
                            PHPCompletionItem.FieldItem fieldItem = PHPCompletionItem.FieldItem.getItem(field, request, false, completeAccessPrefix);
                            completionResult.add(fieldItem);
                            continue;
                        }
                        if ((staticContext || completeAccessPrefix) && constantsFilter.isAccepted(phpElement)) {
                            TypeConstantElement constant = (TypeConstantElement)phpElement;
                            PHPCompletionItem.TypeConstantItem constantItem = PHPCompletionItem.TypeConstantItem.getItem(constant, request, completeAccessPrefix);
                            completionResult.add(constantItem);
                            continue;
                        }
                        if (!staticContext && !completeAccessPrefix || !enumCasesFilter.isAccepted(phpElement)) continue;
                        EnumCaseElement enumCase = (EnumCaseElement)phpElement;
                        PHPCompletionItem.EnumCaseItem enumCaseItem = PHPCompletionItem.EnumCaseItem.getItem(enumCase, request, completeAccessPrefix);
                        completionResult.add(enumCaseItem);
                    }
                    if (!staticContext) continue;
                    Set<TypeConstantElement> magicConstants = constantsFilter.filter(request.index.getAccessibleMagicConstants(typeScope));
                    for (TypeConstantElement magicConstant : magicConstants) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (magicConstant == null) continue;
                        completionResult.add(PHPCompletionItem.TypeConstantItem.getItem(magicConstant, request));
                    }
                }
            }
        }
    }

    private void autoCompleteConstructorParameterName(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(th, request.anchor);
        if (tokenSequence == null) {
            return;
        }
        if (!tokenSequence.moveNext()) {
            return;
        }
        if (CompletionContextFinder.isInAttribute(request.anchor, tokenSequence, true)) {
            this.autoCompleteAttributeExpression(completionResult, request);
        } else {
            this.autoCompleteExpression(completionResult, request);
        }
        Token<? extends PHPTokenId> constructorTypeName = CompletionContextFinder.findFunctionInvocationName(tokenSequence, request.anchor);
        if (constructorTypeName != null) {
            NamespaceName namespaceName = PHPCodeCompletion.findNamespaceName(request.info, tokenSequence.offset());
            String fqTypeName = namespaceName != null ? CodeUtils.extractQualifiedName(namespaceName) : constructorTypeName.text().toString();
            Model model = request.result.getModel();
            NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(model.getFileScope(), request.anchor);
            fqTypeName = VariousUtils.qualifyTypeNames(fqTypeName, request.anchor, namespaceScope);
            Set<AliasedName> aliasedNames = ModelUtils.getAliasedNames(model, request.anchor);
            Set<MethodElement> constructors = request.index.getConstructors(NameKind.exact(fqTypeName), aliasedNames, AliasedElement.Trait.ALIAS);
            HashSet<String> duplicateCheck = new HashSet<String>();
            for (MethodElement constructor : constructors) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addParameterNameItems(completionResult, request, constructor.getParameters(), duplicateCheck);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoCompleteClassMethodParameterName(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, boolean staticContext) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(th, request.anchor);
        if (tokenSequence == null) {
            return;
        }
        Token<? extends PHPTokenId> functionName = CompletionContextFinder.findFunctionInvocationName(tokenSequence, request.anchor);
        if (functionName != null) {
            int originalAnchor = request.anchor;
            try {
                request.anchor = tokenSequence.offset();
                boolean isInstanceContext = !staticContext;
                boolean isStaticContext = staticContext;
                if (tokenSequence.token().id() != PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM && tokenSequence.token().id() != PHPTokenId.PHP_OBJECT_OPERATOR && tokenSequence.token().id() != PHPTokenId.PHP_NULLSAFE_OBJECT_OPERATOR) {
                    tokenSequence.movePrevious();
                }
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                    tokenSequence.movePrevious();
                }
                CharSequence varName = tokenSequence.token().text();
                tokenSequence.moveNext();
                List<String> invalidProposalsForClsMembers = INVALID_PROPOSALS_FOR_CLS_MEMBERS;
                Model model = request.result.getModel();
                boolean parentContext = false;
                boolean selfContext = false;
                boolean staticLateBindingContext = false;
                boolean specialVariable = false;
                if (TokenUtilities.textEquals((CharSequence)varName, (CharSequence)"$this")) {
                    specialVariable = true;
                } else if (TokenUtilities.textEquals((CharSequence)varName, (CharSequence)"self")) {
                    isStaticContext = true;
                    selfContext = true;
                    specialVariable = true;
                } else if (TokenUtilities.textEquals((CharSequence)varName, (CharSequence)"parent")) {
                    invalidProposalsForClsMembers = Collections.emptyList();
                    isStaticContext = true;
                    isInstanceContext = true;
                    specialVariable = true;
                    parentContext = true;
                } else if (TokenUtilities.textEquals((CharSequence)varName, (CharSequence)"static")) {
                    isStaticContext = true;
                    isInstanceContext = false;
                    staticLateBindingContext = true;
                    specialVariable = true;
                }
                Collection<? extends TypeScope> types = ModelUtils.resolveTypeAfterReferenceToken(model, tokenSequence, request.anchor, specialVariable);
                TypeElement enclosingType = this.getEnclosingType(request, types);
                HashSet<PhpElement> duplicateElementCheck = new HashSet<PhpElement>();
                for (TypeScope typeScope : types) {
                    ClassElement classElement;
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    StaticOrInstanceMembersFilter staticFlagFilter = new StaticOrInstanceMembersFilter(isStaticContext, isInstanceContext, selfContext, staticLateBindingContext, true);
                    ElementFilter methodsFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.METHOD), ElementFilter.forName(NameKind.exact(functionName.text().toString())), staticFlagFilter, ElementFilter.forExcludedNames(invalidProposalsForClsMembers, PhpElementKind.METHOD), ElementFilter.forInstanceOf(MethodElement.class));
                    HashSet<TypeMemberElement> accessibleTypeMembers = new HashSet<TypeMemberElement>();
                    accessibleTypeMembers.addAll(request.index.getAccessibleTypeMembers(typeScope, enclosingType));
                    if (typeScope instanceof ClassElement && !(classElement = (ClassElement)((Object)typeScope)).getFQMixinClassNames().isEmpty()) {
                        accessibleTypeMembers.addAll(request.index.getAccessibleMixinTypeMembers(typeScope, enclosingType));
                    }
                    HashSet<String> duplicateCheck = new HashSet<String>();
                    for (PhpElement phpElement : accessibleTypeMembers) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (!duplicateElementCheck.add(phpElement) || !methodsFilter.isAccepted(phpElement)) continue;
                        MethodElement method = (MethodElement)phpElement;
                        this.addParameterNameItems(completionResult, request, method.getParameters(), duplicateCheck);
                    }
                }
            }
            finally {
                request.anchor = originalAnchor;
            }
        }
    }

    private void autoCompleteFunctionParameterName(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(th, request.anchor);
        if (tokenSequence == null) {
            return;
        }
        Token<? extends PHPTokenId> functionName = CompletionContextFinder.findFunctionInvocationName(tokenSequence, request.anchor);
        if (functionName != null) {
            Set<PhpElement> elements = request.index.getTopLevelElements(NameKind.exact(functionName.text().toString()));
            HashSet<String> duplicateCheck = new HashSet<String>();
            for (PhpElement element : elements) {
                FunctionElement functionElement;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (!(element instanceof FunctionElement) || (functionElement = (FunctionElement)element).isAnonymous()) continue;
                this.addParameterNameItems(completionResult, request, functionElement.getParameters(), duplicateCheck);
            }
        }
    }

    private void addParameterNameItems(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, List<ParameterElement> parameters, Set<String> duplicateCheck) {
        for (ParameterElement parameter : parameters) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            String name = parameter.getName();
            if (!StringUtils.isEmpty((String)name)) {
                name = name.substring(1);
            }
            if (StringUtils.isEmpty((String)name) || !name.startsWith(request.prefix) || !duplicateCheck.add(name)) continue;
            completionResult.add(new PHPCompletionItem.ParameterNameItem(parameter, request));
        }
    }

    private void autoCompleteClassConstants(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        ElementFilter constantsFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.TYPE_CONSTANT), ElementFilter.forName(NameKind.caseInsensitivePrefix(request.prefix)), ElementFilter.forInstanceOf(TypeConstantElement.class));
        Model model = request.result.getModel();
        Collection<? extends TypeScope> types = ModelUtils.resolveType(model, request.anchor);
        TypeElement enclosingType = this.getEnclosingType(request, types);
        for (TypeScope typeScope : types) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            for (PhpElement phpElement : request.index.getAccessibleTypeMembers(typeScope, enclosingType)) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (!constantsFilter.isAccepted(phpElement)) continue;
                TypeConstantElement constant = (TypeConstantElement)phpElement;
                PHPCompletionItem.TypeConstantItem constantItem = PHPCompletionItem.TypeConstantItem.getItem(constant, request, true);
                completionResult.add(constantItem);
            }
        }
    }

    private void autoCompleteClassFields(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(th, request.anchor);
        Model model = request.result.getModel();
        Collection<? extends TypeScope> types = ModelUtils.resolveTypeAfterReferenceToken(model, tokenSequence, request.anchor, false);
        ElementFilter fieldsFilter = ElementFilter.allOf(ElementFilter.forKind(PhpElementKind.FIELD), ElementFilter.forName(NameKind.caseInsensitivePrefix(request.prefix)), ElementFilter.forInstanceOf(FieldElement.class));
        if (types != null) {
            TypeElement enclosingType = this.getEnclosingType(request, types);
            for (TypeScope typeScope : types) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                for (PhpElement phpElement : request.index.getAccessibleTypeMembers(typeScope, enclosingType)) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    if (!fieldsFilter.isAccepted(phpElement)) continue;
                    FieldElement field = (FieldElement)phpElement;
                    PHPCompletionItem.FieldItem fieldItem = PHPCompletionItem.FieldItem.getItem(field, request);
                    completionResult.add(fieldItem);
                }
            }
        }
    }

    @CheckForNull
    private TypeElement getEnclosingType(PHPCompletionItem.CompletionRequest request, Collection<? extends TypeScope> types) {
        ElementFilter forFiles;
        Set<TypeElement> set;
        EnclosingType enclosingType = PHPCodeCompletion.findEnclosingType(request.info, CompletionContextFinder.lexerToASTOffset(request.result, request.anchor));
        String enclosingTypeName = enclosingType != null ? enclosingType.extractTypeName() : null;
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(request.result.getModel().getFileScope(), request.anchor);
        String enclosingFQTypeName = VariousUtils.qualifyTypeNames(enclosingTypeName, request.anchor, namespaceScope);
        NameKind.Exact enclosingTypeNameKind = enclosingFQTypeName != null && !enclosingFQTypeName.trim().isEmpty() ? NameKind.exact(enclosingFQTypeName) : null;
        HashSet<FileObject> preferedFileObjects = new HashSet<FileObject>();
        Set<TypeScope> enclosingTypes = null;
        FileObject currentFile = request.result.getSnapshot().getSource().getFileObject();
        if (currentFile != null) {
            preferedFileObjects.add(currentFile);
        }
        for (TypeScope typeScope : types) {
            FileObject fileObject = typeScope.getFileObject();
            if (fileObject != null) {
                preferedFileObjects.add(fileObject);
            }
            if (enclosingTypeNameKind == null || enclosingTypes != null || !enclosingTypeNameKind.matchesName(typeScope)) continue;
            enclosingTypes = Collections.singleton(typeScope);
        }
        if (enclosingTypeNameKind != null && enclosingTypes == null && !(set = (forFiles = ElementFilter.forFiles(preferedFileObjects.toArray(new FileObject[0]))).prefer(request.index.getTypes(enclosingTypeNameKind))).isEmpty()) {
            enclosingTypes = new HashSet<TypeElement>(set);
        }
        return enclosingTypes == null || enclosingTypes.isEmpty() ? null : (TypeElement)enclosingTypes.iterator().next();
    }

    private static boolean isNullableType(ParserResult info, int caretOffset) {
        Token<? extends PHPTokenId> previousToken;
        TokenSequence<PHPTokenId> tokenSequence = PHPCodeCompletion.getTokenSequence(info, caretOffset);
        tokenSequence.move(caretOffset);
        return tokenSequence.movePrevious() && (previousToken = LexUtilities.findPrevious(tokenSequence, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING))).id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)previousToken.text(), (CharSequence)"?");
    }

    private static boolean isUnionType(ParserResult info, int caretOffset) {
        Token<? extends PHPTokenId> previousToken;
        TokenSequence<PHPTokenId> tokenSequence = PHPCodeCompletion.getTokenSequence(info, caretOffset);
        return tokenSequence.movePrevious() && (previousToken = LexUtilities.findPrevious(tokenSequence, VALID_UNION_TYPE_TOKENS)).id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)previousToken.text(), (CharSequence)"|");
    }

    private static boolean isIntersectionType(ParserResult info, int caretOffset) {
        TokenSequence<PHPTokenId> tokenSequence = PHPCodeCompletion.getTokenSequence(info, caretOffset);
        if (tokenSequence.movePrevious() && tokenSequence.moveNext() && tokenSequence.token().id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)tokenSequence.token().text(), (CharSequence)"&&")) {
            return true;
        }
        tokenSequence.move(caretOffset);
        if (tokenSequence.movePrevious()) {
            Token previousToken = LexUtilities.findPrevious(tokenSequence, VALID_INTERSECTION_TYPE_TOKENS);
            if (previousToken == null) {
                return false;
            }
            if (previousToken.id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)previousToken.text(), (CharSequence)"&")) {
                return true;
            }
            if (CompletionContextFinder.isLeftParen(previousToken)) {
                if (!tokenSequence.movePrevious()) {
                    return false;
                }
                previousToken = tokenSequence.token();
                if (previousToken.id() == PHPTokenId.WHITESPACE || CompletionContextFinder.isLeftParen((Token<? extends PHPTokenId>)previousToken) || CompletionContextFinder.isVerticalBar((Token<? extends PHPTokenId>)previousToken) || CompletionContextFinder.isComma((Token<? extends PHPTokenId>)previousToken)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static TokenSequence<PHPTokenId> getTokenSequence(ParserResult info, int caretOffset) {
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        TokenSequence tokenSequence = th.tokenSequence(PHPTokenId.language());
        assert (tokenSequence != null);
        tokenSequence.move(caretOffset);
        return tokenSequence;
    }

    private static boolean isInType(PHPCompletionItem.CompletionRequest request) {
        return PHPCodeCompletion.findEnclosingType(request.info, CompletionContextFinder.lexerToASTOffset(request.result, request.anchor)) != null;
    }

    private static boolean isInInterface(PHPCompletionItem.CompletionRequest request) {
        EnclosingType enclosingType = PHPCodeCompletion.findEnclosingType(request.info, CompletionContextFinder.lexerToASTOffset(request.result, request.anchor));
        return enclosingType != null && enclosingType.isInterface();
    }

    @CheckForNull
    private static NamespaceName findNamespaceName(ParserResult info, int offset) {
        List<ASTNode> nodes = NavUtils.underCaret(info, offset);
        for (int i = nodes.size() - 1; i >= 0; --i) {
            ASTNode node = nodes.get(i);
            if (!(node instanceof NamespaceName) || node.getStartOffset() >= offset || node.getEndOffset() <= offset) continue;
            return (NamespaceName)node;
        }
        return null;
    }

    @CheckForNull
    private static EnclosingType findEnclosingType(ParserResult info, int offset) {
        List<ASTNode> nodes = NavUtils.underCaret(info, offset);
        for (int i = nodes.size() - 1; i >= 0; --i) {
            ClassInstanceCreation classInstanceCreation;
            ASTNode node = nodes.get(i);
            if (node instanceof TypeDeclaration && node.getEndOffset() > offset) {
                return EnclosingType.forTypeDeclaration((TypeDeclaration)node);
            }
            if (!(node instanceof ClassInstanceCreation) || node.getEndOffset() <= offset || !(classInstanceCreation = (ClassInstanceCreation)node).isAnonymous()) continue;
            Block body = classInstanceCreation.getBody();
            if (body != null && body.getStartOffset() <= offset && body.getEndOffset() >= offset) {
                return EnclosingType.forClassInstanceCreation(classInstanceCreation);
            }
            List<Attribute> attributes = classInstanceCreation.getAttributes();
            for (Attribute attribute : attributes) {
                if (attribute.getStartOffset() >= offset || attribute.getEndOffset() <= offset) continue;
                return EnclosingType.forClassInstanceCreation(classInstanceCreation);
            }
        }
        return PHPCodeCompletion.findEclosingType(info, offset, TYPE_TOKENS);
    }

    @CheckForNull
    private static EnclosingType findEclosingType(ParserResult info, int offset, List<PHPTokenId> typeTokenIds) {
        TokenSequence<PHPTokenId> tokenSequence = PHPCodeCompletion.getTokenSequence(info, offset);
        if (!tokenSequence.moveNext()) {
            return null;
        }
        int curlyBalance = 0;
        Token<? extends PHPTokenId> typeToken = LexUtilities.findPreviousToken(tokenSequence, typeTokenIds);
        if (typeToken == null) {
            return null;
        }
        TokenId typeId = typeToken.id();
        String typeName = PHPCodeCompletion.getTypeName(tokenSequence);
        if (typeName == null && typeId == PHPTokenId.PHP_CLASS) {
            typeName = "#anon";
        }
        if (typeName == null) {
            return null;
        }
        while (tokenSequence.moveNext()) {
            if (tokenSequence.offset() >= offset) {
                if (curlyBalance <= 0) break;
                return EnclosingType.forTokenId(typeId, typeName);
            }
            Token token = tokenSequence.token();
            TokenId id = token.id();
            if (id.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) {
                ++curlyBalance;
                continue;
            }
            if (!id.equals((Object)PHPTokenId.PHP_CURLY_CLOSE) || --curlyBalance != 0) continue;
            break;
        }
        return null;
    }

    @CheckForNull
    private static String getTypeName(TokenSequence<PHPTokenId> tokenSequence) {
        String typeName = null;
        List<PHPTokenId> typeNameTokenChains = Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING);
        for (PHPTokenId typeNameToken : typeNameTokenChains) {
            if (!tokenSequence.moveNext() || typeNameToken != tokenSequence.token().id() || typeNameToken != PHPTokenId.PHP_STRING) continue;
            typeName = tokenSequence.token().text().toString();
        }
        return typeName;
    }

    @CheckForNull
    private static EnclosingClass findEnclosingClass(ParserResult info, int offset) {
        List<ASTNode> nodes = NavUtils.underCaret(info, offset);
        for (int i = nodes.size() - 1; i >= 0; --i) {
            Block body;
            ClassInstanceCreation classInstanceCreation;
            ASTNode node = nodes.get(i);
            if (node instanceof ClassDeclaration && node.getEndOffset() > offset) {
                return EnclosingClass.forClassDeclaration((ClassDeclaration)node);
            }
            if (node instanceof EnumDeclaration && node.getEndOffset() > offset) {
                return EnclosingClass.forEnumDeclaration((EnumDeclaration)node);
            }
            if (!(node instanceof ClassInstanceCreation) || node.getEndOffset() <= offset || !(classInstanceCreation = (ClassInstanceCreation)node).isAnonymous() || (body = classInstanceCreation.getBody()) == null || body.getStartOffset() > offset || body.getEndOffset() < offset) continue;
            return EnclosingClass.forClassInstanceCreation((ClassInstanceCreation)node);
        }
        return null;
    }

    private void autoCompleteExpression(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        this.autoCompleteNamespaces(completionResult, request);
        ArrayList<String> defaultKeywords = new ArrayList<String>(PHP_KEYWORDS.keySet());
        defaultKeywords.remove("default =>");
        defaultKeywords.removeAll(PHP_ASYMMETRIC_VISIBILITY_KEYWORDS);
        if (PHPCodeCompletion.isInInterface(request)) {
            defaultKeywords.removeAll(PHP_SET_VISIBILITY_KEYWORDS);
        }
        this.autoCompleteExpression(completionResult, request, defaultKeywords);
    }

    private void autoCompleteExpression(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request, List<String> keywords) {
        String typeName;
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        for (String keyword : keywords) {
            if (!this.startsWith(keyword, request.prefix)) continue;
            completionResult.add(new PHPCompletionItem.KeywordItem(keyword, request));
        }
        for (String keyword : PHP_LANGUAGE_CONSTRUCTS_WITH_QUOTES) {
            if (!this.startsWith(keyword, request.prefix)) continue;
            completionResult.add(new PHPCompletionItem.LanguageConstructWithQuotesItem(keyword, request));
        }
        for (String construct : PHP_LANGUAGE_CONSTRUCTS_WITH_PARENTHESES) {
            if (!this.startsWith(construct, request.prefix)) continue;
            completionResult.add(new PHPCompletionItem.LanguageConstructWithParenthesesItem(construct, request));
        }
        for (String construct : PHP_LANGUAGE_CONSTRUCTS_WITH_SEMICOLON) {
            if (!this.startsWith(construct, request.prefix)) continue;
            completionResult.add(new PHPCompletionItem.LanguageConstructWithSemicolonItem(construct, request));
        }
        boolean offerGlobalVariables = OptionsUtils.codeCompletionVariablesScope().equals((Object)CodeCompletionPanel.VariablesScope.ALL);
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind prefix = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        HashSet<VariableElement> globalVariables = new HashSet<VariableElement>();
        Model model = request.result.getModel();
        Set<AliasedName> aliasedNames = ModelUtils.getAliasedNames(model, request.anchor);
        for (PhpElement element : request.index.getTopLevelElements(prefix, aliasedNames, AliasedElement.Trait.ALIAS)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (element instanceof FunctionElement) {
                FunctionElement functionElement = (FunctionElement)element;
                if (functionElement.isAnonymous()) continue;
                for (PHPCompletionItem.FunctionElementItem functionItem : PHPCompletionItem.FunctionElementItem.getItems(functionElement, request)) {
                    completionResult.add(functionItem);
                }
                continue;
            }
            if (element instanceof ClassElement) {
                ClassElement classElement = (ClassElement)element;
                if (classElement.isAnonymous()) continue;
                completionResult.add(new PHPCompletionItem.ClassItem(classElement, request, true, null));
                continue;
            }
            if (element instanceof EnumElement) {
                EnumElement enumElement = (EnumElement)element;
                completionResult.add(new PHPCompletionItem.EnumItem(enumElement, request, true, null));
                continue;
            }
            if (element instanceof InterfaceElement) {
                completionResult.add(new PHPCompletionItem.InterfaceItem((InterfaceElement)element, request, true));
                continue;
            }
            if (offerGlobalVariables && element instanceof VariableElement) {
                globalVariables.add((VariableElement)element);
                continue;
            }
            if (!(element instanceof ConstantElement)) continue;
            completionResult.add(new PHPCompletionItem.ConstantItem((ConstantElement)element, request));
        }
        FileObject fileObject = request.result.getSnapshot().getSource().getFileObject();
        ElementFilter forCurrentFile = ElementFilter.forFiles(fileObject);
        completionResult.addAll(this.getVariableProposals(request, forCurrentFile.reverseFilter(globalVariables)));
        EnclosingType enclosingType = PHPCodeCompletion.findEnclosingType(request.info, CompletionContextFinder.lexerToASTOffset(request.result, request.anchor));
        if (enclosingType != null && (enclosingType.isClassDeclaration() || enclosingType.isTraitDeclaration() || enclosingType.isEnumDeclaration()) && (typeName = enclosingType.extractTypeName()) != null) {
            for (String keyword : PHP_CLASS_KEYWORDS) {
                if (!this.startsWith(keyword, request.prefix)) continue;
                completionResult.add(new PHPCompletionItem.ClassScopeKeywordItem(typeName, keyword, request));
            }
            this.autoCompleteClassMembers(completionResult, request, false, true);
        }
    }

    private void autoCompleteAttributeExpression(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        this.autoCompleteNamespaces(completionResult, request);
        EnclosingType enclosingClassWithAttribute = PHPCodeCompletion.findEnclosingType(request.info, request.anchor);
        if (enclosingClassWithAttribute != null) {
            this.autoCompleteKeywords(completionResult, request, PHP_ATTRIBUTE_EXPRESSION_KEYWORDS);
        }
        this.autoCompleteTypeNames(completionResult, request, null, true);
        this.autoCompleteConstants(completionResult, request);
    }

    private void autoCompleteGlobals(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        if (OptionsUtils.codeCompletionVariablesScope().equals((Object)CodeCompletionPanel.VariablesScope.ALL)) {
            NameKind.CaseInsensitivePrefix prefix = NameKind.caseInsensitivePrefix(QualifiedName.create(request.prefix));
            for (VariableElement variableElement : request.index.getTopLevelVariables(prefix)) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                completionResult.add(new PHPCompletionItem.VariableItem(variableElement, request));
            }
        }
    }

    private void autoCompleteConstants(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        boolean isCamelCase = PHPCodeCompletion.isCamelCaseForTypeNames(request.prefix);
        NameKind prefix = NameKind.create(request.prefix, isCamelCase ? QuerySupport.Kind.CAMEL_CASE : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        Model model = request.result.getModel();
        Set<AliasedName> aliasedNames = ModelUtils.getAliasedNames(model, request.anchor);
        for (ConstantElement element : request.index.getConstants(prefix, aliasedNames, AliasedElement.Trait.ALIAS)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            completionResult.add(new PHPCompletionItem.ConstantItem(element, request));
        }
    }

    private Collection<CompletionProposal> getVariableProposals(PHPCompletionItem.CompletionRequest request, Set<VariableElement> globalVariables) {
        if (CancelSupport.getDefault().isCancelled()) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, PHPCompletionItem> proposals = new LinkedHashMap<String, PHPCompletionItem>();
        Model model = request.result.getModel();
        VariableScope variableScope = model.getVariableScope(request.anchor);
        if (variableScope != null) {
            if (variableScope instanceof NamespaceScope || variableScope instanceof ArrowFunctionScope) {
                if (globalVariables == null) {
                    FileObject fileObject = request.result.getSnapshot().getSource().getFileObject();
                    ElementFilter forCurrentFile = ElementFilter.forFiles(fileObject);
                    globalVariables = forCurrentFile.reverseFilter(request.index.getTopLevelVariables(NameKind.caseInsensitivePrefix(QualifiedName.create(request.prefix))));
                }
                for (VariableElement globalVariable : globalVariables) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return Collections.emptyList();
                    }
                    proposals.put(globalVariable.getName(), new PHPCompletionItem.VariableItem(globalVariable, request));
                }
            }
            ArrayList<? extends VariableName> allDeclaredVariables = new ArrayList<VariableName>(variableScope.getDeclaredVariables());
            if (variableScope instanceof ArrowFunctionScope) {
                Scope inScope = variableScope.getInScope();
                while (inScope instanceof FunctionScope || inScope instanceof NamespaceScope) {
                    allDeclaredVariables.addAll(((VariableScope)inScope).getDeclaredVariables());
                    if (inScope instanceof FunctionScope && !(inScope instanceof ArrowFunctionScope)) break;
                    inScope = inScope.getInScope();
                }
            }
            List<? extends VariableName> declaredVariables = ModelUtils.filter(allDeclaredVariables, this.nameKind, request.prefix);
            int caretOffset = request.anchor + request.prefix.length();
            for (VariableName variableName : declaredVariables) {
                Set<Pair<QualifiedName, Boolean>> qualifiedNames;
                String name;
                String notDollaredName;
                if (CancelSupport.getDefault().isCancelled()) {
                    return Collections.emptyList();
                }
                FileObject realFileObject = variableName.getRealFileObject();
                if (realFileObject == null && variableName.getNameRange().getEnd() >= caretOffset || PredefinedSymbols.SUPERGLOBALS.contains(notDollaredName = (name = variableName.getName()).startsWith("$") ? name.substring(1) : name) || variableName.representsThis()) continue;
                Collection typeNames = variableName.getTypeNames(request.anchor);
                String typeName = typeNames.size() > 1 ? "mixed" : (String)ModelUtils.getFirst(typeNames);
                Set<Object> set = qualifiedNames = typeName != null ? Collections.singleton(Pair.of((Object)QualifiedName.create(typeName), (Object)false)) : Collections.emptySet();
                if (realFileObject != null) {
                    proposals.put(name, new PHPCompletionItem.VariableItem(VariableElementImpl.create(name, 0, realFileObject, variableName.getElementQuery(), TypeResolverImpl.forNames(qualifiedNames), variableName.isDeprecated()), request){

                        @Override
                        public boolean isSmart() {
                            return true;
                        }
                    });
                    continue;
                }
                proposals.put(name, new PHPCompletionItem.VariableItem(VariableElementImpl.create(name, 0, request.currentlyEditedFileURL, variableName.getElementQuery(), TypeResolverImpl.forNames(qualifiedNames), variableName.isDeprecated()), request));
            }
            for (String string : PredefinedSymbols.SUPERGLOBALS) {
                if (!this.isPrefix("$" + string, request.prefix)) continue;
                proposals.put(string, new PHPCompletionItem.SuperGlobalItem(request, string));
            }
        }
        return proposals.values();
    }

    private boolean isPrefix(String name, String prefix) {
        return name != null && (name.startsWith(prefix) || this.nameKind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && name.toLowerCase().startsWith(prefix.toLowerCase()));
    }

    public Documentation documentElement(ParserResult info, ElementHandle element, Callable<Boolean> cancel) {
        Documentation result;
        if (element instanceof ModelElement) {
            ModelElement mElem = (ModelElement)element;
            Scope parentElem = mElem.getInScope();
            FileObject fileObject = mElem.getFileObject();
            String fName = fileObject == null ? "?" : fileObject.getNameExt();
            String tooltip = parentElem instanceof TypeScope ? String.valueOf((Object)mElem.getPhpElementKind()) + ": " + parentElem.getName() + "<b> " + mElem.getName() + " </b>(" + fName + ")" : String.valueOf((Object)mElem.getPhpElementKind()) + ":<b> " + mElem.getName() + " </b>(" + fName + ")";
            result = Documentation.create((String)String.format("<div align=\"right\"><font size=-1>%s</font></div>", tooltip));
        } else {
            result = element instanceof MethodElement && ((MethodElement)element).isMagic() ? null : DocRenderer.document(info, element);
        }
        return result;
    }

    public String document(ParserResult info, ElementHandle element) {
        return null;
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    private static boolean isPHPIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '@';
    }

    @SuppressWarnings(value={"INT_BAD_COMPARISON_WITH_NONNEGATIVE_VALUE"}, justification="Not sure about FB analysis correctness")
    private String getPrefix(ParserResult info, int caretOffset, boolean upToOffset, PrefixBreaker prefixBreaker) {
        try {
            BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
            if (doc == null) {
                return null;
            }
            int lineBegin = LineDocumentUtils.getLineStart((LineDocument)doc, (int)caretOffset);
            if (lineBegin != -1) {
                String prefix;
                int lineOffset;
                int lineEnd = LineDocumentUtils.getLineEnd((LineDocument)doc, (int)caretOffset);
                String line = doc.getText(lineBegin, lineEnd - lineBegin);
                int start = lineOffset = caretOffset - lineBegin;
                if (lineOffset > 0) {
                    char c = '\u0000';
                    for (int i = lineOffset - 1; i >= 0; --i) {
                        assert (i >= 0 && i <= line.length() - 1) : "line:" + line + " | i:" + i + " | line.length():" + line.length() + " | lineBegin:" + lineBegin + " | lineEnd:" + lineEnd + " | caretOffset:" + caretOffset;
                        if (i < 0 || i > line.length() - 1) continue;
                        c = line.charAt(i);
                        if (!PHPCodeCompletion.isPHPIdentifierPart(c) && c != '\\') break;
                        start = i;
                    }
                    if (start == lineOffset && c == '?' && lineOffset - 2 >= 0 && line.charAt(lineOffset - 2) == '<') {
                        start -= 2;
                    }
                }
                if (upToOffset) {
                    prefix = line.substring(start, lineOffset);
                    int lastIndexOfDollar = prefix.lastIndexOf(36);
                    if (lastIndexOfDollar > 0) {
                        prefix = prefix.substring(lastIndexOfDollar);
                    }
                } else if (lineOffset == line.length()) {
                    prefix = line.substring(start);
                } else {
                    char d;
                    int n = line.length();
                    int end = lineOffset;
                    for (int j = lineOffset; j < n && PHPCodeCompletion.isPHPIdentifierPart(d = line.charAt(j)); ++j) {
                        end = j + 1;
                    }
                    prefix = line.substring(start, end);
                }
                if (prefix.length() > 0) {
                    if (prefix.endsWith("::")) {
                        return "";
                    }
                    if (prefix.endsWith(":") && prefix.length() > 1) {
                        return null;
                    }
                    int q = prefix.lastIndexOf("::");
                    if (q != -1) {
                        prefix = prefix.substring(q + 2);
                    }
                    if (prefix.length() == 1) {
                        char c = prefix.charAt(0);
                        if (prefixBreaker.isBreaker(c)) {
                            return null;
                        }
                    } else if (!"<?".equals(prefix)) {
                        for (int i = prefix.length() - 1; i >= 0; --i) {
                            char c = prefix.charAt(i);
                            if (i == 0 && c == ':' || !prefixBreaker.isBreaker(c)) continue;
                            prefix = prefix.substring(i + 1);
                            break;
                        }
                    }
                }
                if (prefix != null && prefix.startsWith("@")) {
                    TokenSequence<PHPTokenId> tokenSequence;
                    TokenHierarchy tokenHierarchy = info.getSnapshot().getTokenHierarchy();
                    TokenSequence<PHPTokenId> tokenSequence2 = tokenSequence = tokenHierarchy != null ? LexUtilities.getPHPTokenSequence(tokenHierarchy, caretOffset) : null;
                    if (tokenSequence != null) {
                        Token token;
                        PHPTokenId id;
                        tokenSequence.move(caretOffset);
                        if (tokenSequence.moveNext() && tokenSequence.movePrevious() && ((id = (PHPTokenId)(token = tokenSequence.token()).id()).equals((Object)PHPTokenId.PHP_STRING) || id.equals((Object)PHPTokenId.PHP_TOKEN))) {
                            prefix = prefix.substring(1);
                        }
                    }
                }
                return prefix;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        return this.getPrefix(info, caretOffset, upToOffset, PrefixBreaker.COMMON);
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        Token t;
        int offset;
        if (typedText.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        char lastChar = typedText.charAt(typedText.length() - 1);
        Document document = component.getDocument();
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(document, offset = component.getCaretPosition());
        if (ts == null) {
            return CodeCompletionHandler.QueryType.STOP;
        }
        int diff = ts.move(offset);
        if ((diff > 0 && ts.moveNext() || ts.movePrevious()) && (t = ts.token()) != null) {
            TokenId id;
            if (t.id() == PHPTokenId.T_INLINE_HTML) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            if (AUTOPOPUP_STOP_CHARS.contains(Character.valueOf(lastChar))) {
                return CodeCompletionHandler.QueryType.STOP;
            }
            if (OptionsUtils.autoCompletionTypes()) {
                if (lastChar == ' ' || lastChar == '\t') {
                    if (ts.movePrevious() && TOKENS_TRIGGERING_AUTOPUP_TYPES_WS.contains(ts.token().id())) {
                        return CodeCompletionHandler.QueryType.ALL_COMPLETION;
                    }
                    return CodeCompletionHandler.QueryType.STOP;
                }
                if (t.id() == PHPTokenId.PHP_OBJECT_OPERATOR || t.id() == PHPTokenId.PHP_NULLSAFE_OBJECT_OPERATOR || t.id() == PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM) {
                    return CodeCompletionHandler.QueryType.ALL_COMPLETION;
                }
            }
            if (OptionsUtils.autoCompletionVariables() && (t.id() == PHPTokenId.PHP_TOKEN && lastChar == '$' || t.id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && lastChar == '$')) {
                return CodeCompletionHandler.QueryType.ALL_COMPLETION;
            }
            if (OptionsUtils.autoCompletionNamespaces() && t.id() == PHPTokenId.PHP_NS_SEPARATOR) {
                return PHPCodeCompletion.isPhp53OrNewer(document) ? CodeCompletionHandler.QueryType.ALL_COMPLETION : CodeCompletionHandler.QueryType.NONE;
            }
            if (t.id() == PHPTokenId.PHPDOC_COMMENT && lastChar == '@') {
                return CodeCompletionHandler.QueryType.ALL_COMPLETION;
            }
            if (OptionsUtils.autoCompletionFull() && ((id = t.id()).equals((Object)PHPTokenId.PHP_STRING) || id.equals((Object)PHPTokenId.PHP_VARIABLE)) && t.length() > 0) {
                return CodeCompletionHandler.QueryType.ALL_COMPLETION;
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public static boolean isPhp53OrNewer(Document document) {
        FileObject fileObject = CodeUtils.getFileObject(document);
        assert (fileObject != null);
        return CodeUtils.isPhpVersionGreaterThan(fileObject, PhpVersion.PHP_5);
    }

    private static boolean isPhp74OrNewer(FileObject fileObject) {
        if (PHP_VERSION != null) {
            return PHP_VERSION.compareTo((Enum)PhpVersion.PHP_74) >= 0;
        }
        assert (fileObject != null);
        return CodeUtils.isPhpVersionGreaterThan(fileObject, PhpVersion.PHP_73);
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        Model model = ((PHPParseResult)info).getModel();
        ParameterInfoSupport infoSupport = model.getParameterInfoSupport(caretOffset);
        ParameterInfo parameterInfo = infoSupport.getParameterInfo();
        return parameterInfo == null ? ParameterInfo.NONE : parameterInfo;
    }

    private boolean startsWith(String theString, String prefix) {
        if (prefix.length() == 0) {
            return true;
        }
        return this.caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private int findBaseNamespaceEnd(ParserResult info, int caretOffset) {
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        assert (th != null);
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(th, caretOffset);
        assert (tokenSequence != null);
        tokenSequence.move(caretOffset);
        boolean moveNextSucces = tokenSequence.moveNext();
        if (!moveNextSucces && !tokenSequence.movePrevious()) {
            assert (false);
            return caretOffset;
        }
        boolean hasCurly = false;
        while (tokenSequence.movePrevious()) {
            if (!hasCurly) {
                if (tokenSequence.token().id() != PHPTokenId.PHP_CURLY_OPEN) continue;
                hasCurly = true;
                continue;
            }
            if (tokenSequence.token().id() == PHPTokenId.WHITESPACE) continue;
            tokenSequence.moveNext();
            break;
        }
        if (hasCurly) {
            return tokenSequence.offset();
        }
        assert (false);
        return caretOffset;
    }

    private static boolean isCamelCaseForTypeNames(String query) {
        return false;
    }

    static {
        PHP_KEYWORDS.put("use", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("namespace", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("class", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("trait", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("enum", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("const", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("continue", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("function", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("fn", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("new", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("static", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("var", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("final", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("interface", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("instanceof", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("implements", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("extends", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("public", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("private", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("protected", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("public(set)", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("private(set)", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("protected(set)", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("public protected(set)", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("public private(set)", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("protected private(set)", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("abstract", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("readonly", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("clone", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("global", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("goto", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("throw", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("if", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("switch", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("match", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("for", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("array", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("foreach", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("while", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("catch", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("try", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_CURLY_BRACKETS);
        PHP_KEYWORDS.put("default", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_COLON);
        PHP_KEYWORDS.put("default =>", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("break", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("endif", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("endfor", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("endforeach", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("endwhile", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("endswitch", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("case", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_COLON);
        PHP_KEYWORDS.put("and", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("as", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("declare", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("do", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_CURLY_BRACKETS);
        PHP_KEYWORDS.put("else", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_CURLY_BRACKETS);
        PHP_KEYWORDS.put("elseif", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_BRACKETS_AND_CURLY_BRACKETS);
        PHP_KEYWORDS.put("enddeclare", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("or", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("xor", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("finally", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_CURLY_BRACKETS);
        PHP_KEYWORDS.put("yield", CompletionContextFinder.KeywordCompletionType.CURSOR_BEFORE_ENDING_SEMICOLON);
        PHP_KEYWORDS.put("yield from", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_LANGUAGE_CONSTRUCTS_WITH_QUOTES = new String[]{"echo", "include", "include_once", "require", "require_once", "print"};
        PHP_LANGUAGE_CONSTRUCTS_WITH_PARENTHESES = new String[]{"die", "eval", "exit", "empty", "isset", "list", "unset"};
        PHP_LANGUAGE_CONSTRUCTS_WITH_SEMICOLON = new String[]{"return"};
        PHP_CLASS_KEYWORDS = new String[]{PHP_CLASS_KEYWORD_THIS, "self::", "parent::", "static::"};
        PHP_STATIC_CLASS_KEYWORDS = new String[]{"self::", "parent::", "static::"};
        PHP_GLOBAL_CONST_KEYWORDS = Arrays.asList("array", "new");
        PHP_CLASS_CONST_KEYWORDS = Arrays.asList("array", "self::", "parent::");
        PHP_ATTRIBUTE_EXPRESSION_KEYWORDS = Arrays.asList("new", "array", "self::", "parent::");
        PHP_MATCH_EXPRESSION_KEYWORDS = Arrays.asList("function", "fn", "new", "static", "instanceof", "clone", "throw", "match", "array", "default =>", "and", "or", "xor");
        PHP_VISIBILITY_KEYWORDS = Arrays.asList("public", "protected", "private");
        PHP_SET_VISIBILITY_KEYWORDS = Arrays.asList("public(set)", "protected(set)", "private(set)");
        PHP_ASYMMETRIC_VISIBILITY_KEYWORDS = Arrays.asList("public private(set)", "public protected(set)", "protected private(set)");
        AUTOPOPUP_STOP_CHARS = new TreeSet<Character>(Arrays.asList(Character.valueOf('='), Character.valueOf(';'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('?')));
        TOKENS_TRIGGERING_AUTOPUP_TYPES_WS = Arrays.asList(PHPTokenId.PHP_NEW, PHPTokenId.PHP_EXTENDS, PHPTokenId.PHP_IMPLEMENTS, PHPTokenId.PHP_INSTANCEOF);
        INVALID_PROPOSALS_FOR_CLS_MEMBERS = Arrays.asList("__construct", "__destruct", "__call", "__callStatic", "__clone", "__get", "__invoke", "__isset", "__set", "__set_state", "__sleep", "__toString", "__unset", "__wakeup");
        CLASS_CONTEXT_KEYWORD_PROPOSAL = Arrays.asList("abstract", "const", "function", "final", "private", "protected", "public", "static", "var", "readonly");
        INTERFACE_CONTEXT_KEYWORD_PROPOSAL = Arrays.asList("const", "function", "public", "static");
        INHERITANCE_KEYWORDS = Arrays.asList("extends", "implements");
        VALID_UNION_TYPE_TOKENS = Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.PHP_NS_SEPARATOR, PHPTokenId.PHP_TYPE_BOOL, PHPTokenId.PHP_TYPE_FLOAT, PHPTokenId.PHP_TYPE_INT, PHPTokenId.PHP_TYPE_STRING, PHPTokenId.PHP_TYPE_VOID, PHPTokenId.PHP_TYPE_OBJECT, PHPTokenId.PHP_TYPE_MIXED, PHPTokenId.PHP_SELF, PHPTokenId.PHP_PARENT, PHPTokenId.PHP_STATIC, PHPTokenId.PHP_NULL, PHPTokenId.PHP_FALSE, PHPTokenId.PHP_TRUE, PHPTokenId.PHP_ARRAY, PHPTokenId.PHP_ITERABLE, PHPTokenId.PHP_CALLABLE, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END);
        VALID_INTERSECTION_TYPE_TOKENS = Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.PHP_NS_SEPARATOR, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END);
        TYPE_TOKENS = Arrays.asList(PHPTokenId.PHP_CLASS, PHPTokenId.PHP_INTERFACE, PHPTokenId.PHP_TRAIT, PHPTokenId.PHP_ENUM);
    }

    private static interface PrefixBreaker {
        public static final PrefixBreaker COMMON = new PrefixBreaker(){

            @Override
            public boolean isBreaker(char c) {
                return !PHPCodeCompletion.isPHPIdentifierPart(c) && c != ':';
            }
        };
        public static final PrefixBreaker WITH_NS_PARTS = new PrefixBreaker(){

            @Override
            public boolean isBreaker(char c) {
                return !PHPCodeCompletion.isPHPIdentifierPart(c) && c != '\\' && c != ':';
            }
        };

        public boolean isBreaker(char var1);
    }

    private static interface EnclosingClass {
        public String getClassName();

        public Expression getSuperClass();

        public List<Expression> getInterfaces();

        public String extractClassName();

        public String extractUnqualifiedSuperClassName();

        public static EnclosingClass forClassDeclaration(final ClassDeclaration classDeclaration) {
            return new EnclosingClass(){

                @Override
                public String getClassName() {
                    return classDeclaration.getName().getName();
                }

                @Override
                public Expression getSuperClass() {
                    return classDeclaration.getSuperClass();
                }

                @Override
                public List<Expression> getInterfaces() {
                    return classDeclaration.getInterfaces();
                }

                @Override
                public String extractClassName() {
                    return CodeUtils.extractClassName(classDeclaration);
                }

                @Override
                public String extractUnqualifiedSuperClassName() {
                    return CodeUtils.extractUnqualifiedSuperClassName(classDeclaration);
                }
            };
        }

        public static EnclosingClass forClassInstanceCreation(final ClassInstanceCreation classInstanceCreation) {
            if (!5.$assertionsDisabled && !classInstanceCreation.isAnonymous()) {
                throw new AssertionError(classInstanceCreation);
            }
            return new EnclosingClass(){

                @Override
                public String getClassName() {
                    return CodeUtils.extractClassName(classInstanceCreation);
                }

                @Override
                public Expression getSuperClass() {
                    return classInstanceCreation.getSuperClass();
                }

                @Override
                public List<Expression> getInterfaces() {
                    return classInstanceCreation.getInterfaces();
                }

                @Override
                public String extractClassName() {
                    return CodeUtils.extractClassName(classInstanceCreation);
                }

                @Override
                public String extractUnqualifiedSuperClassName() {
                    return CodeUtils.extractUnqualifiedSuperClassName(classInstanceCreation);
                }
            };
        }

        public static EnclosingClass forEnumDeclaration(final EnumDeclaration enumDeclaration) {
            return new EnclosingClass(){

                @Override
                public String getClassName() {
                    return enumDeclaration.getName().getName();
                }

                @Override
                public Expression getSuperClass() {
                    return null;
                }

                @Override
                public List<Expression> getInterfaces() {
                    return enumDeclaration.getInterfaces();
                }

                @Override
                public String extractClassName() {
                    return CodeUtils.extractTypeName(enumDeclaration);
                }

                @Override
                public String extractUnqualifiedSuperClassName() {
                    return null;
                }
            };
        }
    }

    private static enum UseType {
        TYPE,
        CONST,
        FUNCTION;

    }

    private static class StaticOrInstanceMembersFilter
    extends ElementFilter {
        private final boolean forStaticContext;
        private final boolean forInstanceContext;
        private final boolean forSelfContext;
        private final boolean staticAllowed;
        private final boolean nonstaticAllowed;
        private final boolean forStaticLateBinding;
        private final boolean forParentContext;

        public StaticOrInstanceMembersFilter(boolean forStaticContext, boolean forInstanceContext, boolean forSelfContext, boolean forStaticLateBinding, boolean forParentContext) {
            this.forStaticContext = forStaticContext;
            this.forInstanceContext = forInstanceContext;
            this.forSelfContext = forSelfContext;
            this.forStaticLateBinding = forStaticLateBinding;
            this.staticAllowed = OptionsUtils.codeCompletionStaticMethods();
            this.nonstaticAllowed = OptionsUtils.codeCompletionNonStaticMethods();
            this.forParentContext = forParentContext;
        }

        @Override
        public boolean isAccepted(PhpElement element) {
            if (this.forSelfContext && this.isAcceptedForSelfContext(element)) {
                return true;
            }
            if (this.forStaticContext && this.isAcceptedForStaticContext(element)) {
                return true;
            }
            return this.forInstanceContext && this.isAcceptedForNotStaticContext(element);
        }

        private boolean isAcceptedForNotStaticContext(PhpElement element) {
            boolean isStatic = element.getPhpModifiers().isStatic();
            if (this.forParentContext && !isStatic && element.getPhpElementKind().equals((Object)PhpElementKind.FIELD)) {
                return false;
            }
            return !isStatic || this.staticAllowed && element.getPhpElementKind().equals((Object)PhpElementKind.METHOD);
        }

        private boolean isAcceptedForStaticContext(PhpElement element) {
            boolean isStatic = element.getPhpModifiers().isStatic();
            return isStatic || this.nonstaticAllowed && !this.forStaticLateBinding && element.getPhpElementKind().equals((Object)PhpElementKind.METHOD);
        }

        private boolean isAcceptedForSelfContext(PhpElement element) {
            return this.forSelfContext && this.nonstaticAllowed && !element.getPhpElementKind().equals((Object)PhpElementKind.FIELD);
        }
    }

    private static interface EnclosingType {
        public boolean isClassDeclaration();

        public boolean isTraitDeclaration();

        public boolean isEnumDeclaration();

        public boolean isInterface();

        public String extractTypeName();

        public static EnclosingType forTypeDeclaration(final TypeDeclaration typeDeclaration) {
            return new EnclosingType(){

                @Override
                public boolean isClassDeclaration() {
                    return typeDeclaration instanceof ClassDeclaration;
                }

                @Override
                public boolean isTraitDeclaration() {
                    return typeDeclaration instanceof TraitDeclaration;
                }

                @Override
                public boolean isEnumDeclaration() {
                    return typeDeclaration instanceof EnumDeclaration;
                }

                @Override
                public boolean isInterface() {
                    return typeDeclaration instanceof InterfaceDeclaration;
                }

                @Override
                public String extractTypeName() {
                    return CodeUtils.extractTypeName(typeDeclaration);
                }
            };
        }

        public static EnclosingType forTokenId(final TokenId tokenId, final String typeName) {
            return new EnclosingType(){

                @Override
                public boolean isClassDeclaration() {
                    return tokenId == PHPTokenId.PHP_CLASS;
                }

                @Override
                public boolean isTraitDeclaration() {
                    return tokenId == PHPTokenId.PHP_TRAIT;
                }

                @Override
                public boolean isEnumDeclaration() {
                    return tokenId == PHPTokenId.PHP_ENUM;
                }

                @Override
                public boolean isInterface() {
                    return tokenId == PHPTokenId.PHP_INTERFACE;
                }

                @Override
                public String extractTypeName() {
                    return typeName;
                }
            };
        }

        public static EnclosingType forClassInstanceCreation(final ClassInstanceCreation classInstanceCreation) {
            if (!5.$assertionsDisabled && !classInstanceCreation.isAnonymous()) {
                throw new AssertionError(classInstanceCreation);
            }
            return new EnclosingType(){

                @Override
                public boolean isClassDeclaration() {
                    return true;
                }

                @Override
                public boolean isTraitDeclaration() {
                    return false;
                }

                @Override
                public boolean isEnumDeclaration() {
                    return false;
                }

                @Override
                public boolean isInterface() {
                    return false;
                }

                @Override
                public String extractTypeName() {
                    return CodeUtils.extractClassName(classInstanceCreation);
                }
            };
        }

        static {
            if (5.$assertionsDisabled) {
                // empty if block
            }
        }
    }
}

