/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerApplication;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerCompile;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerJar;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerJavadoc;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerRun;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerSources;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.spi.project.support.ant.ui.CustomizerUtilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class J2SECompositePanelProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String SOURCES = "Sources";
    static final String LIBRARIES = "Libraries";
    private static final String BUILD = "Build";
    private static final String JAR = "Jar";
    private static final String JAVADOC = "Javadoc";
    public static final String RUN = "Run";
    private static final String APPLICATION = "Application";
    private static final String LICENSE = "License";
    private String name;

    private J2SECompositePanelProvider(String name) {
        this.name = name;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        ResourceBundle bundle = NbBundle.getBundle(CustomizerProviderImpl.class);
        Object toReturn = null;
        if (SOURCES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)SOURCES, (String)bundle.getString("LBL_Config_Sources"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (LIBRARIES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)LIBRARIES, (String)bundle.getString("LBL_Config_Libraries"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (BUILD.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)BUILD, (String)bundle.getString("LBL_Config_Build"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (JAR.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)JAR, (String)bundle.getString("LBL_Config_Jar"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (JAVADOC.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)JAVADOC, (String)bundle.getString("LBL_Config_Javadoc"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (LICENSE.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)LICENSE, (String)bundle.getString("LBL_Config_License"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (RUN.equals(this.name)) {
            boolean fxOverride = false;
            Project project = (Project)context.lookup(Project.class);
            if (project != null) {
                J2SEProject j2sepe = (J2SEProject)project.getLookup().lookup(J2SEProject.class);
                fxOverride = J2SEProjectUtil.isTrue(j2sepe.evaluator().getProperty("javafx.enabled"));
            }
            toReturn = fxOverride ? null : ProjectCustomizer.Category.create((String)RUN, (String)bundle.getString("LBL_Config_Run"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        }
        assert (toReturn != null || RUN.equals(this.name)) : "No category for name:" + this.name;
        return toReturn;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, final Lookup context) {
        String nm = category.getName();
        final J2SEProjectProperties uiProps = (J2SEProjectProperties)context.lookup(J2SEProjectProperties.class);
        if (SOURCES.equals(nm)) {
            return new CustomizerSources(uiProps);
        }
        if (LIBRARIES.equals(nm)) {
            CustomizerProviderImpl.SubCategoryProvider prov = (CustomizerProviderImpl.SubCategoryProvider)context.lookup(CustomizerProviderImpl.SubCategoryProvider.class);
            assert (prov != null) : "Assuming CustomizerProviderImpl.SubCategoryProvider in customizer context";
            return new CustomizerLibraries(uiProps, prov, category);
        }
        if (BUILD.equals(nm)) {
            return new CustomizerCompile(uiProps);
        }
        if (JAR.equals(nm)) {
            return new CustomizerJar(uiProps);
        }
        if (JAVADOC.equals(nm)) {
            return new CustomizerJavadoc(uiProps);
        }
        if (RUN.equals(nm)) {
            return new CustomizerRun(uiProps);
        }
        if (APPLICATION.equals(nm)) {
            return new CustomizerApplication(uiProps);
        }
        if (LICENSE.equals(nm)) {
            CustomizerUtilities.LicensePanelContentHandler handler = new CustomizerUtilities.LicensePanelContentHandler(){
                final /* synthetic */ J2SECompositePanelProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public String getProjectLicenseLocation() {
                    return uiProps.LICENSE_PATH_VALUE;
                }

                public String getGlobalLicenseName() {
                    return uiProps.LICENSE_NAME_VALUE;
                }

                public FileObject resolveProjectLocation(@NonNull String path) {
                    J2SEProject project = (J2SEProject)context.lookup(J2SEProject.class);
                    String evaluated = uiProps.getEvaluator().evaluate(path);
                    return project.getAntProjectHelper().resolveFileObject(evaluated);
                }

                public void setProjectLicenseLocation(@NullAllowed String newLocation) {
                    uiProps.LICENSE_PATH_VALUE = newLocation;
                }

                public void setGlobalLicenseName(@NullAllowed String newName) {
                    uiProps.LICENSE_NAME_VALUE = newName;
                }

                public String getDefaultProjectLicenseLocation() {
                    return "./nbproject/licenseheader.txt";
                }

                public void setProjectLicenseContent(@NullAllowed String text) {
                    uiProps.CHANGED_LICENSE_PATH_CONTENT = text;
                }
            };
            return CustomizerUtilities.createLicenseHeaderCustomizerPanel((ProjectCustomizer.Category)category, (CustomizerUtilities.LicensePanelContentHandler)handler);
        }
        return new JPanel();
    }

    public static J2SECompositePanelProvider createSources() {
        return new J2SECompositePanelProvider(SOURCES);
    }

    public static J2SECompositePanelProvider createLibraries() {
        return new J2SECompositePanelProvider(LIBRARIES);
    }

    public static J2SECompositePanelProvider createBuild() {
        return new J2SECompositePanelProvider(BUILD);
    }

    public static J2SECompositePanelProvider createJar() {
        return new J2SECompositePanelProvider(JAR);
    }

    public static J2SECompositePanelProvider createJavadoc() {
        return new J2SECompositePanelProvider(JAVADOC);
    }

    public static J2SECompositePanelProvider createRun() {
        return new J2SECompositePanelProvider(RUN);
    }

    public static J2SECompositePanelProvider createApplication() {
        return new J2SECompositePanelProvider(APPLICATION);
    }

    public static J2SECompositePanelProvider createLicense() {
        return new J2SECompositePanelProvider(LICENSE);
    }
}

