/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.List;
import org.netbeans.lib.profiler.heap.ArrayDump;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.PrimitiveArrayLazyList;

class PrimitiveArrayDump
extends ArrayDump
implements PrimitiveArrayInstance {
    private static final int charSize = 2;

    PrimitiveArrayDump(ClassDump cls, long offset) {
        super(cls, offset);
    }

    @Override
    public long getSize() {
        long elementSize = this.dumpClass.getHprof().getValueSize(this.getType());
        return (long)(this.dumpClass.classDumpSegment.getMinimumInstanceSize() + HPROF_ARRAY_OVERHEAD) + elementSize * (long)this.getLength();
    }

    @Override
    public List getValues() {
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        HprofHeap heap = this.dumpClass.getHprof();
        byte type = this.getType();
        long offset = this.getArrayStartOffset();
        return new PrimitiveArrayLazyList(dumpBuffer, this.getLength(), offset, heap.getValueSize(type), type);
    }

    char[] getChars(int start, int length) {
        assert (this.getType() == 5);
        char[] chars = new char[length];
        long offset = this.getArrayStartOffset() + (long)start * 2L;
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        for (int i = 0; i < length; ++i) {
            chars[i] = dumpBuffer.getChar(offset + (long)(i * 2));
        }
        return chars;
    }

    byte[] getBytes(int start, int length) {
        assert (this.getType() == 8);
        byte[] bytes = new byte[length];
        long offset = this.getArrayStartOffset() + (long)start;
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        for (int i = 0; i < length; ++i) {
            bytes[i] = dumpBuffer.get(offset + (long)i);
        }
        return bytes;
    }

    private long getArrayStartOffset() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return this.fileOffset + 1L + (long)idSize + 4L + 4L + 1L;
    }

    private byte getType() {
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        int idSize = dumpBuffer.getIDSize();
        return dumpBuffer.get(this.fileOffset + 1L + (long)idSize + 4L + 4L);
    }
}

